/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class OpenSearchQueryManager
implements QueryManager {
    private static final Logger LOG = LogManager.getLogger(OpenSearchQueryManager.class);
    private final NodeClient nodeClient;
    private final Settings settings;
    public static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";
    public static final String SQL_BACKGROUND_THREAD_POOL_NAME = "sql_background_io";

    public QueryId submit(AbstractPlan queryPlan) {
        TimeValue timeout = (TimeValue)this.settings.getSettingValue(Settings.Key.PPL_QUERY_TIMEOUT);
        this.schedule(this.nodeClient, () -> ((AbstractPlan)queryPlan).execute(), timeout);
        return queryPlan.getQueryId();
    }

    private void schedule(NodeClient client, Runnable task, TimeValue timeout) {
        ThreadPool threadPool = client.threadPool();
        Runnable wrappedTask = this.withCurrentContext(() -> {
            Thread executionThread = Thread.currentThread();
            Scheduler.ScheduledCancellable timeoutTask = threadPool.schedule(() -> {
                LOG.warn("Query execution timed out after {}. Interrupting execution thread.", (Object)timeout);
                executionThread.interrupt();
            }, timeout, "generic");
            try {
                task.run();
                timeoutTask.cancel();
                Thread.interrupted();
            }
            catch (Exception e) {
                timeoutTask.cancel();
                if (Thread.interrupted() || e.getCause() instanceof InterruptedException) {
                    LOG.error("Query was interrupted due to timeout after {}", (Object)timeout);
                    throw new OpenSearchTimeoutException("Query execution timed out after " + String.valueOf(timeout), new Object[0]);
                }
                throw e;
            }
        });
        threadPool.schedule(wrappedTask, new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    private Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    @Generated
    public OpenSearchQueryManager(NodeClient nodeClient, Settings settings) {
        this.nodeClient = nodeClient;
        this.settings = settings;
    }
}

