/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MapNode<K, V> {
    private final V value;
    private final Map<K, MapNode<K, V>> children;

    public static <K, V> MapNode<K, V> create(V value, Map<K, MapNode<K, V>> children) {
        return new MapNode<K, V>(value, children);
    }

    private MapNode(V value, Map<K, MapNode<K, V>> children) {
        this.value = Preconditions.checkNotNull(value, (Object)"value");
        Preconditions.checkArgument((!children.values().contains(this) ? 1 : 0) != 0, (Object)"I can't be my own child.");
        this.children = Collections.unmodifiableMap(children);
    }

    public V getValue() {
        return this.value;
    }

    public Map<K, MapNode<K, V>> getChildren() {
        return this.children;
    }

    int[] subtreeSizeAndLeafCount() {
        MapNode node;
        ArrayDeque<MapNode<K, V>> stack = new ArrayDeque<MapNode<K, V>>();
        stack.push(this);
        int size = 0;
        int leafCount = 0;
        while ((node = (MapNode)stack.poll()) != null) {
            ++size;
            if (node.children.isEmpty()) {
                ++leafCount;
            }
            for (MapNode<K, V> child : node.children.values()) {
                stack.push(child);
            }
        }
        return new int[]{size, leafCount};
    }

    public List<MapNode<K, V>> preorder() {
        MapNode node;
        ArrayList list = Lists.newArrayList();
        ArrayDeque<MapNode<K, V>> stack = new ArrayDeque<MapNode<K, V>>();
        stack.push(this);
        while ((node = (MapNode)stack.poll()) != null) {
            list.add(node);
            for (MapNode<K, V> child : node.children.values()) {
                stack.push(child);
            }
        }
        return list;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.children});
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapNode)) {
            return false;
        }
        MapNode other = (MapNode)o;
        return this.value.equals(other.value) && Objects.equal(this.children, other.children);
    }
}

