/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.referral.ReferralHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReferralHandler<Q extends Request, S>
implements ReferralHandler<Q, S> {
    protected static final int DEFAULT_REFERRAL_LIMIT = 10;
    protected static final ReferralConnectionFactory DEFAULT_CONNECTION_FACTORY = (config, ldapUrl) -> {
        ConnectionConfig cc = ConnectionConfig.newConnectionConfig(config);
        cc.setLdapUrl(ldapUrl);
        return new DefaultConnectionFactory(cc);
    };
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int referralLimit;
    private final int referralDepth;
    private final ReferralConnectionFactory connectionFactory;

    public AbstractReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        this.referralLimit = limit;
        this.referralDepth = depth;
        this.connectionFactory = factory;
    }

    public int getReferralLimit() {
        return this.referralLimit;
    }

    public int getReferralDepth() {
        return this.referralDepth;
    }

    public ReferralConnectionFactory getReferralConnectionFactory() {
        return this.connectionFactory;
    }

    protected abstract Q createReferralRequest(Q var1, LdapURL var2);

    protected abstract Operation<Q, S> createReferralOperation(Connection var1);

    protected Response<S> followReferral(Connection conn, Q request, String[] referralUrls) throws LdapException {
        Response<S> referralResponse = null;
        List<String> urls = Arrays.asList(referralUrls);
        Collections.shuffle(urls);
        this.logger.debug("Following referral with URLs: {}", urls);
        for (String url : urls) {
            block15: {
                LdapURL ldapUrl = new LdapURL(url);
                if (ldapUrl.getEntry().getHostname() == null) continue;
                ConnectionFactory cf = this.connectionFactory.getConnectionFactory(conn.getConnectionConfig(), ldapUrl.getEntry().getHostnameWithSchemeAndPort());
                try (Connection referralConn = cf.getConnection();){
                    referralConn.open();
                    Q referralRequest = this.createReferralRequest(request, ldapUrl);
                    Operation<Q, S> op = this.createReferralOperation(referralConn);
                    referralResponse = op.execute(referralRequest);
                }
                catch (LdapException e) {
                    this.logger.warn("Could not follow referral to " + url, (Throwable)e);
                    if (e.getResultCode() != ResultCode.REFERRAL_LIMIT_EXCEEDED) break block15;
                    throw e;
                }
            }
            if (referralResponse == null || referralResponse.getResultCode() != ResultCode.SUCCESS) continue;
            break;
        }
        return referralResponse;
    }

    @Override
    public HandlerResult<Response<S>> handle(Connection conn, Q request, Response<S> response) throws LdapException {
        Response<S> referralResponse;
        HandlerResult<Response<S>> result = this.referralDepth > this.referralLimit ? new HandlerResult<Response<S>>(new Response<S>(response.getResult(), ResultCode.REFERRAL_LIMIT_EXCEEDED, response.getMessage(), response.getMatchedDn(), response.getControls(), response.getReferralURLs(), response.getMessageId())) : ((referralResponse = this.followReferral(conn, request, response.getReferralURLs())) != null ? new HandlerResult<Response<S>>(referralResponse) : new HandlerResult<Response<S>>(response));
        return result;
    }

    @Override
    public HandlerResult<Response<S>> handle(Connection conn, Q request, String[] referralUrls) throws LdapException {
        Response<S> referralResponse;
        HandlerResult<Response<Object>> result = this.referralDepth > this.referralLimit ? new HandlerResult<Response<Object>>(new Response<Object>(null, ResultCode.REFERRAL_LIMIT_EXCEEDED, null, null, null, null, -1)) : ((referralResponse = this.followReferral(conn, request, referralUrls)) != null ? new HandlerResult<Response<S>>(referralResponse) : new HandlerResult<Object>(null));
        return result;
    }

    @Override
    public void initializeRequest(Q request) {
    }
}

