/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Clock;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;

public class DefaultPoolConfig<POOLABLE>
implements PoolConfig<POOLABLE> {
    protected final BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer;
    protected final Mono<POOLABLE> allocator;
    protected final AllocationStrategy allocationStrategy;
    protected final int maxPending;
    protected final Function<POOLABLE, ? extends Publisher<Void>> releaseHandler;
    protected final Function<POOLABLE, ? extends Publisher<Void>> destroyHandler;
    protected final BiPredicate<POOLABLE, PooledRefMetadata> evictionPredicate;
    protected final Duration evictInBackgroundInterval;
    protected final Scheduler evictInBackgroundScheduler;
    protected final Scheduler acquisitionScheduler;
    protected final PoolMetricsRecorder metricsRecorder;
    protected final Clock clock;
    protected final boolean isIdleLRU;

    public DefaultPoolConfig(Mono<POOLABLE> allocator, AllocationStrategy allocationStrategy, int maxPending, BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer, Function<POOLABLE, ? extends Publisher<Void>> releaseHandler, Function<POOLABLE, ? extends Publisher<Void>> destroyHandler, BiPredicate<POOLABLE, PooledRefMetadata> evictionPredicate, Duration evictInBackgroundInterval, Scheduler evictInBackgroundScheduler, Scheduler acquisitionScheduler, PoolMetricsRecorder metricsRecorder, Clock clock, boolean isIdleLRU) {
        this.pendingAcquireTimer = pendingAcquireTimer;
        this.allocator = allocator;
        this.allocationStrategy = allocationStrategy;
        this.maxPending = maxPending;
        this.releaseHandler = releaseHandler;
        this.destroyHandler = destroyHandler;
        this.evictionPredicate = evictionPredicate;
        this.evictInBackgroundInterval = evictInBackgroundInterval;
        this.evictInBackgroundScheduler = evictInBackgroundScheduler;
        this.acquisitionScheduler = acquisitionScheduler;
        this.metricsRecorder = metricsRecorder;
        this.clock = clock;
        this.isIdleLRU = isIdleLRU;
    }

    protected DefaultPoolConfig(PoolConfig<POOLABLE> toCopy) {
        if (toCopy instanceof DefaultPoolConfig) {
            DefaultPoolConfig toCopyDpc = (DefaultPoolConfig)toCopy;
            this.allocator = toCopyDpc.allocator;
            this.allocationStrategy = toCopyDpc.allocationStrategy;
            this.maxPending = toCopyDpc.maxPending;
            this.pendingAcquireTimer = toCopyDpc.pendingAcquireTimer;
            this.releaseHandler = toCopyDpc.releaseHandler;
            this.destroyHandler = toCopyDpc.destroyHandler;
            this.evictionPredicate = toCopyDpc.evictionPredicate;
            this.evictInBackgroundInterval = toCopyDpc.evictInBackgroundInterval;
            this.evictInBackgroundScheduler = toCopyDpc.evictInBackgroundScheduler;
            this.acquisitionScheduler = toCopyDpc.acquisitionScheduler;
            this.metricsRecorder = toCopyDpc.metricsRecorder;
            this.clock = toCopyDpc.clock;
            this.isIdleLRU = toCopyDpc.isIdleLRU;
        } else {
            this.allocator = toCopy.allocator();
            this.allocationStrategy = toCopy.allocationStrategy();
            this.maxPending = toCopy.maxPending();
            this.pendingAcquireTimer = toCopy.pendingAcquireTimer();
            this.releaseHandler = toCopy.releaseHandler();
            this.destroyHandler = toCopy.destroyHandler();
            this.evictionPredicate = toCopy.evictionPredicate();
            this.evictInBackgroundInterval = toCopy.evictInBackgroundInterval();
            this.evictInBackgroundScheduler = toCopy.evictInBackgroundScheduler();
            this.acquisitionScheduler = toCopy.acquisitionScheduler();
            this.metricsRecorder = toCopy.metricsRecorder();
            this.clock = toCopy.clock();
            this.isIdleLRU = toCopy.reuseIdleResourcesInLruOrder();
        }
    }

    @Override
    public Mono<POOLABLE> allocator() {
        return this.allocator;
    }

    @Override
    public AllocationStrategy allocationStrategy() {
        return this.allocationStrategy;
    }

    @Override
    public int maxPending() {
        return this.maxPending;
    }

    @Override
    public BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer() {
        return this.pendingAcquireTimer;
    }

    @Override
    public Function<POOLABLE, ? extends Publisher<Void>> releaseHandler() {
        return this.releaseHandler;
    }

    @Override
    public Function<POOLABLE, ? extends Publisher<Void>> destroyHandler() {
        return this.destroyHandler;
    }

    @Override
    public BiPredicate<POOLABLE, PooledRefMetadata> evictionPredicate() {
        return this.evictionPredicate;
    }

    @Override
    public Duration evictInBackgroundInterval() {
        return this.evictInBackgroundInterval;
    }

    @Override
    public Scheduler evictInBackgroundScheduler() {
        return this.evictInBackgroundScheduler;
    }

    @Override
    public Scheduler acquisitionScheduler() {
        return this.acquisitionScheduler;
    }

    @Override
    public PoolMetricsRecorder metricsRecorder() {
        return this.metricsRecorder;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public boolean reuseIdleResourcesInLruOrder() {
        return this.isIdleLRU;
    }
}

