/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.model.WriteBatch;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;

@SdkPublicApi
@ThreadSafe
public final class BatchWriteItemEnhancedRequest {
    private final List<WriteBatch> writeBatches;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;

    private BatchWriteItemEnhancedRequest(Builder builder) {
        this.writeBatches = BatchWriteItemEnhancedRequest.getListIfExist(builder.writeBatches);
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return BatchWriteItemEnhancedRequest.builder().writeBatches(this.writeBatches).returnConsumedCapacity(this.returnConsumedCapacity).returnItemCollectionMetrics(this.returnItemCollectionMetrics);
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue((String)this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    public Collection<WriteBatch> writeBatches() {
        return this.writeBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWriteItemEnhancedRequest that = (BatchWriteItemEnhancedRequest)o;
        return Objects.equals(this.writeBatches, that.writeBatches) && Objects.equals(this.returnConsumedCapacity, that.returnConsumedCapacity) && Objects.equals(this.returnItemCollectionMetrics, that.returnItemCollectionMetrics);
    }

    public int hashCode() {
        int result = this.writeBatches != null ? this.writeBatches.hashCode() : 0;
        result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
        return result;
    }

    private static List<WriteBatch> getListIfExist(List<WriteBatch> writeBatches) {
        return writeBatches != null ? Collections.unmodifiableList(writeBatches) : null;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<WriteBatch> writeBatches;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;

        private Builder() {
        }

        public Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString();
            return this;
        }

        public Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        public Builder writeBatches(Collection<WriteBatch> writeBatches) {
            this.writeBatches = writeBatches != null ? new ArrayList<WriteBatch>(writeBatches) : null;
            return this;
        }

        public Builder writeBatches(WriteBatch ... writeBatches) {
            this.writeBatches = Arrays.asList(writeBatches);
            return this;
        }

        public Builder addWriteBatch(WriteBatch writeBatch) {
            if (this.writeBatches == null) {
                this.writeBatches = new ArrayList<WriteBatch>();
            }
            this.writeBatches.add(writeBatch);
            return this;
        }

        public BatchWriteItemEnhancedRequest build() {
            return new BatchWriteItemEnhancedRequest(this);
        }
    }
}

