/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.plugin.stats.StatNames;
import org.opensearch.knn.plugin.transport.KNNStatsAction;
import org.opensearch.knn.plugin.transport.KNNStatsNodeResponse;
import org.opensearch.knn.plugin.transport.KNNStatsRequest;
import org.opensearch.knn.plugin.transport.KNNStatsResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class KNNCircuitBreaker {
    private static Logger logger = LogManager.getLogger(KNNCircuitBreaker.class);
    public static final String KNN_CIRCUIT_BREAKER_TIER = "knn_cb_tier";
    public static int CB_TIME_INTERVAL = 120;
    private static KNNCircuitBreaker INSTANCE;
    private ThreadPool threadPool;
    private ClusterService clusterService;
    private Client client;

    private KNNCircuitBreaker() {
    }

    public static synchronized KNNCircuitBreaker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KNNCircuitBreaker();
        }
        return INSTANCE;
    }

    public static synchronized void setInstance(KNNCircuitBreaker instance) {
        INSTANCE = instance;
    }

    public void initialize(ThreadPool threadPool, ClusterService clusterService, Client client) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        NativeMemoryCacheManager nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
        Runnable runnable = () -> {
            if (nativeMemoryCacheManager.isCacheCapacityReached().booleanValue() && clusterService.localNode().isDataNode()) {
                long currentSizeKiloBytes = nativeMemoryCacheManager.getCacheSizeInKilobytes();
                long circuitBreakerLimitSizeKiloBytes = KNNSettings.state().getCircuitBreakerLimit().getKb();
                long circuitBreakerUnsetSizeKiloBytes = (long)(KNNSettings.getCircuitBreakerUnsetPercentage() / 100.0 * (double)circuitBreakerLimitSizeKiloBytes);
                if (currentSizeKiloBytes <= circuitBreakerUnsetSizeKiloBytes) {
                    nativeMemoryCacheManager.setCacheCapacityReached(false);
                }
            }
            if (KNNSettings.isCircuitBreakerTriggered() && clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
                KNNStatsRequest knnStatsRequest = new KNNStatsRequest();
                knnStatsRequest.addStat(StatNames.CACHE_CAPACITY_REACHED.getName());
                knnStatsRequest.timeout(new TimeValue(10000L));
                try {
                    KNNStatsResponse knnStatsResponse = (KNNStatsResponse)((Object)((Object)client.execute((ActionType)KNNStatsAction.INSTANCE, (ActionRequest)knnStatsRequest).get()));
                    List nodeResponses = knnStatsResponse.getNodes();
                    ArrayList<String> nodesAtMaxCapacity = new ArrayList<String>();
                    for (KNNStatsNodeResponse nodeResponse : nodeResponses) {
                        if (!((Boolean)nodeResponse.getStatsMap().get(StatNames.CACHE_CAPACITY_REACHED.getName())).booleanValue()) continue;
                        nodesAtMaxCapacity.add(nodeResponse.getNode().getId());
                    }
                    if (!nodesAtMaxCapacity.isEmpty()) {
                        logger.info("[KNN] knn.circuit_breaker.triggered stays set. Nodes at max cache capacity: " + String.join((CharSequence)",", nodesAtMaxCapacity) + ".");
                    } else {
                        logger.info("[KNN] Cache capacity below 75% of the circuit breaker limit for all nodes. Unsetting knn.circuit_breaker.triggered flag.");
                        KNNSettings.state().updateCircuitBreakerSettings(false);
                    }
                }
                catch (Exception e) {
                    logger.error("[KNN] Exception getting stats: " + String.valueOf(e));
                }
            }
        };
        this.threadPool.scheduleWithFixedDelay(runnable, TimeValue.timeValueSeconds((long)CB_TIME_INTERVAL), "generic");
    }
}

