/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.update;

import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.replication.action.update.UpdateIndexReplicationRequest;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.state.ReplicationStateMetadataKt;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00010BI\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0014J&\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014J\u0010\u0010&\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0002H\u0002J\b\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0014R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010,\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lorg/opensearch/replication/action/update/TransportUpdateIndexReplicationAction;", "Lorg/opensearch/action/support/clustermanager/TransportClusterManagerNodeAction;", "Lorg/opensearch/replication/action/update/UpdateIndexReplicationRequest;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "Lkotlinx/coroutines/CoroutineScope;", "transportService", "Lorg/opensearch/transport/TransportService;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "client", "Lorg/opensearch/transport/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/common/settings/IndexScopedSettings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;)V", "getIndexScopedSettings", "()Lorg/opensearch/common/settings/IndexScopedSettings;", "getClient", "()Lorg/opensearch/transport/client/Client;", "getReplicationMetadataManager", "()Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "checkBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "request", "state", "Lorg/opensearch/cluster/ClusterState;", "clusterManagerOperation", "", "listener", "Lorg/opensearch/core/action/ActionListener;", "validateUpdateReplicationRequest", "executor", "", "read", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Companion", "opensearch-cross-cluster-replication"})
public final class TransportUpdateIndexReplicationAction
extends TransportClusterManagerNodeAction<UpdateIndexReplicationRequest, AcknowledgedResponse>
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ GlobalScope $$delegate_0;
    @NotNull
    private final IndexScopedSettings indexScopedSettings;
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    private static final Logger log = LogManager.getLogger(TransportUpdateIndexReplicationAction.class);

    @Inject
    public TransportUpdateIndexReplicationAction(@NotNull TransportService transportService, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull IndexScopedSettings indexScopedSettings, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        super("indices:admin/plugins/replication/index/update", transportService, clusterService, threadPool, actionFilters, UpdateIndexReplicationRequest::new, indexNameExpressionResolver);
        this.$$delegate_0 = GlobalScope.INSTANCE;
        this.indexScopedSettings = indexScopedSettings;
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
    }

    @NotNull
    public final IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ReplicationMetadataManager getReplicationMetadataManager() {
        return this.replicationMetadataManager;
    }

    @Nullable
    protected ClusterBlockException checkBlock(@NotNull UpdateIndexReplicationRequest request, @NotNull ClusterState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(@NotNull UpdateIndexReplicationRequest request, @NotNull ClusterState state, @NotNull ActionListener<AcknowledgedResponse> listener2) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        CoroutineScope coroutineScope = this;
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getUnconfined();
        ThreadPool threadPool = this.threadPool;
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"threadPool");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineDispatcher.plus(CoroutinesKt.coroutineContext(threadPool)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, request, this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ UpdateIndexReplicationRequest $request;
            final /* synthetic */ TransportUpdateIndexReplicationAction this$0;
            {
                this.$listener = $listener;
                this.$request = $request;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$listener;
                        var3_4 = this.$request;
                        var4_5 = this.this$0;
                        $i$f$completeWith = 0;
                        var8_8 = $this$completeWith$iv;
                        $i$a$-completeWith-TransportUpdateIndexReplicationAction$clusterManagerOperation$1$1 = 0;
                        TransportUpdateIndexReplicationAction.access$getLog$cp().info("Updating index replication on index:" + var3_4.getIndexName());
                        TransportUpdateIndexReplicationAction.access$validateUpdateReplicationRequest(var4_5, var3_4);
                        this.L$0 = $this$completeWith$iv;
                        this.L$1 = var8_8;
                        this.I$0 = $i$f$completeWith;
                        this.I$1 = $i$a$-completeWith-TransportUpdateIndexReplicationAction$clusterManagerOperation$1$1;
                        this.label = 1;
                        v0 = var4_5.getReplicationMetadataManager().updateSettings(var3_4.getIndexName(), var3_4.getSettings(), (Continuation<? super Unit>)this);
                        ** if (v0 != var9_2) goto lbl23
lbl22:
                        // 1 sources

                        return var9_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl33
                    }
                    case 1: {
                        $i$a$-completeWith-TransportUpdateIndexReplicationAction$clusterManagerOperation$1$1 = this.I$1;
                        $i$f$completeWith = this.I$0;
                        var8_8 = (ActionListener)this.L$1;
                        $this$completeWith$iv = (ActionListener)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl33:
                            // 2 sources

                            var8_8.onResponse((Object)new AcknowledgedResponse(true));
                        }
                        catch (Exception e$iv) {
                            $this$completeWith$iv.onFailure(e$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void validateUpdateReplicationRequest(UpdateIndexReplicationRequest request) {
        this.indexScopedSettings.validate(request.getSettings(), false, false);
        ClusterService clusterService = this.clusterService;
        Intrinsics.checkNotNullExpressionValue((Object)clusterService, (String)"clusterService");
        Map<String, String> map = ReplicationStateMetadataKt.getReplicationStateParamsForIndex(clusterService, request.getIndexName());
        if (map == null) {
            throw new IllegalArgumentException("No replication in progress for index:" + request.getIndexName());
        }
        Map<String, String> replicationStateParams = map;
        String replicationOverallState = replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE");
        if (Intrinsics.areEqual((Object)replicationOverallState, (Object)"RUNNING") || Intrinsics.areEqual((Object)replicationOverallState, (Object)"PAUSED")) {
            return;
        }
        throw new IllegalStateException("Cannot update settings when in " + replicationOverallState + " state");
    }

    @NotNull
    protected String executor() {
        return "same";
    }

    @NotNull
    protected AcknowledgedResponse read(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        return new AcknowledgedResponse(inp);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$validateUpdateReplicationRequest(TransportUpdateIndexReplicationAction $this, UpdateIndexReplicationRequest request) {
        $this.validateUpdateReplicationRequest(request);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/action/update/TransportUpdateIndexReplicationAction$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

