/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ratelimit.CheckpointMaintainRequest;
import org.opensearch.timeseries.ratelimit.CheckpointWriteRequest;
import org.opensearch.timeseries.util.DateUtils;

public class CheckPointMaintainRequestAdapter<RCFModelType extends ThresholdedRandomCutForest, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CacheType extends TimeSeriesCache<RCFModelType>> {
    private static final Logger LOG = LogManager.getLogger(CheckPointMaintainRequestAdapter.class);
    private CheckpointDaoType checkpointDao;
    private String indexName;
    private Duration checkpointInterval;
    private Clock clock;
    private Provider<CacheType> cache;

    public CheckPointMaintainRequestAdapter(CheckpointDaoType checkpointDao, String indexName, Setting<TimeValue> checkpointIntervalSetting, Clock clock, ClusterService clusterService, Settings settings, Provider<CacheType> cache) {
        this.checkpointDao = checkpointDao;
        this.indexName = indexName;
        this.checkpointInterval = DateUtils.toDuration((TimeValue)checkpointIntervalSetting.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointIntervalSetting, it -> {
            this.checkpointInterval = DateUtils.toDuration(it);
        });
        this.clock = clock;
        this.cache = cache;
    }

    public Optional<CheckpointWriteRequest> convert(CheckpointMaintainRequest request) {
        String configId = request.getConfigId();
        String modelId = request.getModelId();
        Optional stateToMaintain = ((TimeSeriesCache)this.cache.get()).getForMaintainance(configId, modelId);
        if (stateToMaintain.isPresent()) {
            ModelState state = stateToMaintain.get();
            if (!((CheckpointDao)this.checkpointDao).shouldSave(state, false, this.checkpointInterval, this.clock)) {
                return Optional.empty();
            }
            try {
                Map<String, Object> source = ((CheckpointDao)this.checkpointDao).toIndexSource(state);
                if (source == null || source.isEmpty() || Strings.isEmpty((CharSequence)modelId)) {
                    return Optional.empty();
                }
                return Optional.of(new CheckpointWriteRequest(request.getExpirationEpochMs(), configId, request.getPriority(), new UpdateRequest(this.indexName, modelId).docAsUpsert(true).doc(source)));
            }
            catch (Exception e) {
                LOG.error((Message)new ParameterizedMessage("Exception while serializing models for [{}]", (Object)modelId), (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

