/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.xcontent;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.statestore.StateModel;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializer;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializerUtil;

public class AsyncQueryJobMetadataXContentSerializer
implements XContentSerializer<AsyncQueryJobMetadata> {
    public static final String TYPE_JOBMETA = "jobmeta";
    public static final String JOB_TYPE = "jobType";
    public static final String INDEX_NAME = "indexName";
    public static final String RESULT_INDEX = "resultIndex";
    public static final String SESSION_ID = "sessionId";

    @Override
    public XContentBuilder toXContent(AsyncQueryJobMetadata jobMetadata, ToXContent.Params params) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("queryId", jobMetadata.getQueryId()).field("type", TYPE_JOBMETA).field("jobId", jobMetadata.getJobId()).field("accountId", jobMetadata.getAccountId()).field("applicationId", jobMetadata.getApplicationId()).field(RESULT_INDEX, jobMetadata.getResultIndex()).field(SESSION_ID, jobMetadata.getSessionId()).field("dataSourceName", jobMetadata.getDatasourceName()).field(JOB_TYPE, jobMetadata.getJobType().getText().toLowerCase(Locale.ROOT)).field(INDEX_NAME, jobMetadata.getIndexName()).endObject();
    }

    @Override
    public AsyncQueryJobMetadata fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        AsyncQueryJobMetadata.AsyncQueryJobMetadataBuilder<?, ?> builder = AsyncQueryJobMetadata.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "queryId": {
                    builder.queryId(parser.textOrNull());
                    continue block26;
                }
                case "jobId": {
                    builder.jobId(parser.textOrNull());
                    continue block26;
                }
                case "accountId": {
                    builder.accountId(parser.textOrNull());
                    continue block26;
                }
                case "applicationId": {
                    builder.applicationId(parser.textOrNull());
                    continue block26;
                }
                case "resultIndex": {
                    builder.resultIndex(parser.textOrNull());
                    continue block26;
                }
                case "sessionId": {
                    builder.sessionId(parser.textOrNull());
                    continue block26;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.textOrNull());
                    continue block26;
                }
                case "jobType": {
                    String jobTypeStr = parser.textOrNull();
                    builder.jobType(Strings.isNullOrEmpty((String)jobTypeStr) ? null : JobType.fromString(jobTypeStr));
                    continue block26;
                }
                case "indexName": {
                    builder.indexName(parser.textOrNull());
                    continue block26;
                }
                case "type": {
                    continue block26;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        builder.metadata(XContentSerializerUtil.buildMetadata(seqNo, primaryTerm));
        StateModel result = builder.build();
        if (((AsyncQueryJobMetadata)result).getJobId() == null || ((AsyncQueryJobMetadata)result).getApplicationId() == null) {
            throw new IllegalArgumentException("jobId and applicationId are required fields.");
        }
        return builder.build();
    }
}

