/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.opensearch.common.util.SetBackedScalingCuckooFilter;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;
import org.opensearch.search.internal.SearchContext;

public abstract class AbstractRareTermsAggregator
extends DeferableBucketAggregator {
    static final BucketOrder ORDER = BucketOrder.compound(BucketOrder.count(true), BucketOrder.key(true));
    protected final long maxDocCount;
    private final double precision;
    protected final DocValueFormat format;
    private final int filterSeed;
    protected MergingBucketsDeferringCollector deferringCollector;

    AbstractRareTermsAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, DocValueFormat format) throws IOException {
        super(name, factories, context, parent, metadata);
        this.maxDocCount = maxDocCount;
        this.precision = precision;
        this.format = format;
        this.filterSeed = context.indexShard().shardId().hashCode();
        String scoringAgg = this.subAggsNeedScore();
        String nestedAgg = this.descendsFromNestedAggregator(parent);
        if (scoringAgg != null && nestedAgg != null) {
            throw new IllegalStateException("RareTerms agg [" + this.name() + "] is the child of the nested agg [" + nestedAgg + "], and also has a scoring child agg [" + scoringAgg + "].  This combination is not supported because it requires executing in [depth_first] mode, which the RareTerms agg cannot do.");
        }
    }

    protected SetBackedScalingCuckooFilter newFilter() {
        SetBackedScalingCuckooFilter filter = new SetBackedScalingCuckooFilter(10000, new Random(this.filterSeed), this.precision);
        filter.registerBreaker(x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return filter;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, AbstractRareTermsAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    private String subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return subAgg.name();
        }
        return null;
    }

    private String descendsFromNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == NestedAggregator.class) {
                return parent.name();
            }
            parent = parent.parent();
        }
        return null;
    }
}

