/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox.jcajce;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Arrays;

public class JcaBlobVerifier
implements BlobVerifier {
    private final MessageDigest sha1Digest;
    private final MessageDigest md5Digest;

    JcaBlobVerifier(JcaJceHelper helper) throws NoSuchProviderException, NoSuchAlgorithmException {
        MessageDigest md5;
        this.sha1Digest = helper.createMessageDigest("SHA-1");
        try {
            md5 = helper.createMessageDigest("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            md5 = null;
        }
        this.md5Digest = md5;
    }

    @Override
    public boolean isMatched(byte[] blobData, byte[] blobDigest) {
        this.sha1Digest.update(blobData, 0, blobData.length);
        byte[] calculatedDigest = this.sha1Digest.digest();
        if (!Arrays.constantTimeAreEqual((byte[])calculatedDigest, (byte[])blobDigest)) {
            if (blobDigest[0] == 0 && blobDigest[1] == 0 && blobDigest[2] == 0 && blobDigest[3] == 0) {
                this.md5Digest.update(blobData, 0, blobData.length);
                Arrays.fill((byte[])calculatedDigest, (byte)0);
                try {
                    this.md5Digest.digest(calculatedDigest, 4, this.md5Digest.getDigestLength());
                }
                catch (DigestException e) {
                    throw new IllegalStateException("internal buffer to small: " + e.getMessage(), e);
                }
                return Arrays.constantTimeAreEqual((byte[])calculatedDigest, (byte[])blobDigest);
            }
            return false;
        }
        return true;
    }
}

