/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.jsexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.backend.js.Exportability;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedAttribute;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedClassDeclarationsInfo;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.jsexport.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J#\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u000e*\u0002H\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002J(\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u00192\u0016\b\u0002\u0010-\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u00010\u000e0.H\u0002J,\u0010\u0017\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\rH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020/H\u0002J\u0010\u00104\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateNamespacesForPackages", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getGenerateNamespacesForPackages", "()Z", "generateExport", "", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "withAttributesFor", "T", "(Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedDeclaration;", "exportClass", "candidate", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportPropertyUnsafely", "exportEnumEntry", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedProperty;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/Exportability;", "klass", "exportDeclarationImplicitly", "exportOrdinaryClass", "exportEnumClass", "exportClassDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedClassDeclarationsInfo;", "specialProcessing", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "members", "nestedClasses", "Lorg/jetbrains/kotlin/ir/backend/js/jsexport/ExportedClass;", "exportAsEnumMember", "functionExportability", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n*L\n1#1,537:1\n32#2:538\n1651#3:539\n1915#3:540\n1916#3:543\n1652#3:544\n1807#3,3:548\n812#3,12:563\n1642#3,10:575\n1915#3:585\n1916#3:587\n1652#3:588\n1807#3,3:592\n1807#3,3:595\n1#4:541\n1#4:542\n1#4:546\n1#4:552\n1#4:555\n1#4:558\n1#4:561\n1#4:586\n1#4:590\n28#5:545\n29#5:547\n28#5:551\n29#5:553\n28#5:554\n29#5:556\n28#5:557\n29#5:559\n28#5:560\n29#5:562\n28#5:589\n29#5:591\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGenerator\n*L\n23#1:538\n23#1:539\n23#1:540\n23#1:543\n23#1:544\n82#1:548,3\n183#1:563,12\n184#1:575,10\n184#1:585\n184#1:587\n184#1:588\n317#1:592,3\n346#1:595,3\n23#1:542\n43#1:546\n103#1:552\n111#1:555\n154#1:558\n173#1:561\n184#1:586\n254#1:590\n43#1:545\n43#1:547\n103#1:551\n103#1:553\n111#1:554\n111#1:556\n154#1:557\n154#1:559\n173#1:560\n173#1:562\n254#1:589\n254#1:591\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean generateNamespacesForPackages;

    public ExportModelGenerator(@NotNull JsIrBackendContext context2, boolean generateNamespacesForPackages) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.generateNamespacesForPackages = generateNamespacesForPackages;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public final boolean getGenerateNamespacesForPackages() {
        return this.generateNamespacesForPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        FqName namespaceFqName = file.getPackageFqName();
        Collection $this$memoryOptimizedMapNotNull$iv = file.getDeclarations();
        boolean $i$f$memoryOptimizedMapNotNull = false;
        Iterable iterable = $this$memoryOptimizedMapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExportedDeclaration exportedDeclaration;
            IrDeclaration irDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration declaration = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            IrDeclaration it = irDeclaration = declaration;
            boolean bl3 = false;
            if ((!Intrinsics.areEqual(AnnotationUtilsKt.couldBeConvertedToExplicitExport(it), true) ? irDeclaration : null) != null) {
                IrDeclaration p0;
                p0 = p0;
                boolean bl4 = false;
                exportedDeclaration = this.exportDeclaration(p0);
            } else {
                exportedDeclaration = null;
            }
            if (exportedDeclaration == null) continue;
            ExportedDeclaration it$iv$iv = exportedDeclaration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exports = CollectionsKt.compactIfPossible((List)destination$iv$iv);
        return exports.isEmpty() ? kotlin.collections.CollectionsKt.emptyList() : (!this.generateNamespacesForPackages || namespaceFqName.isRoot() ? exports : kotlin.collections.CollectionsKt.listOf(new ExportedNamespace(namespaceFqName.toString(), exports)));
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context, declaration)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Can't export declaration";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportDeclaration_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportDeclaration_u24lambda_u240.withIrEntry("candidate", candidate2);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        ExportedDeclaration exportedDeclaration2 = exportedDeclaration;
        return exportedDeclaration2 != null ? this.withAttributesFor(exportedDeclaration2, candidate2) : null;
    }

    private final <T extends ExportedDeclaration> T withAttributesFor(T $this$withAttributesFor, IrDeclaration declaration) {
        if (AnnotationUtilsKt.isJsExportDefault(declaration)) {
            $this$withAttributesFor.getAttributes().add(ExportedAttribute.DefaultExport.INSTANCE);
        }
        return $this$withAttributesFor;
    }

    private final ExportedDeclaration exportClass(IrClass candidate2) {
        return IrUtilsKt.isEnumClass(candidate2) ? this.exportEnumClass(candidate2) : this.exportOrdinaryClass(candidate2);
    }

    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded || exportability instanceof Exportability.Implicit || exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Allowed) {
            exportedDeclaration = new ExportedFunction(ExportModelGeneratorKt.getExportedIdentifier(function2), ExportModelGeneratorKt.access$isStaticMethod(function2), function2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportProperty(IrProperty property2) {
        IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()};
        for (IrSimpleFunction accessor : kotlin.collections.CollectionsKt.listOfNotNull(irSimpleFunctionArray)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = accessor.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            if (!accessor.isFakeOverride() || ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(accessor, this.context)) continue;
            return null;
        }
        return this.exportPropertyUnsafely(property2);
    }

    private final ExportedDeclaration exportPropertyUnsafely(IrProperty property2) {
        String string = ExportModelGeneratorKt.getExportedIdentifier(property2);
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        IrSimpleFunction irSimpleFunction2 = property2.getSetter();
        IrSimpleFunction irSimpleFunction3 = property2.getGetter();
        if (irSimpleFunction3 == null) {
            irSimpleFunction3 = property2.getSetter();
        }
        boolean bl = irSimpleFunction3 != null ? IrDeclarationsKt.isStaticMethodOfClass(irSimpleFunction3) : false;
        return new ExportedProperty(string, bl, irSimpleFunction, irSimpleFunction2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedProperty exportEnumEntry(IrField field) {
        IrEnumEntry irEnumEntry = JsIrAttributesKt.getCorrespondingEnumEntry(field);
        if (irEnumEntry == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find enum entry";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumEntry_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumEntry_u24lambda_u240.withIrEntry("field", field);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        IrEnumEntry irEnumEntry2 = irEnumEntry;
        String string = ExportModelGeneratorKt.getExportedIdentifier(irEnumEntry2);
        IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getGetInstanceFun(irEnumEntry2);
        if (irSimpleFunction == null) {
            void $this$exportEnumEntry_u24lambda_u241;
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find get instance fun";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumEntry_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl3 = true;
            String string2 = string;
            boolean bl4 = false;
            $this$exportEnumEntry_u24lambda_u241.withIrEntry("field", field);
            Unit unit = Unit.INSTANCE;
            String string3 = string2;
            boolean bl5 = bl3;
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 8;
        IrFunction irFunction = null;
        IrFunction irFunction2 = irSimpleFunction;
        boolean bl = true;
        String string4 = string;
        return new ExportedProperty(string4, bl, irFunction2, irFunction, n2, defaultConstructorMarker);
    }

    private final Exportability classExportability(IrClass klass) {
        switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable(klass) + " with kind: " + (Object)((Object)klass.getKind()));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (AnnotationUtilsKt.isJsImplicitExport(klass)) {
            return Exportability.Implicit.INSTANCE;
        }
        if (IrDeclarationsKt.isSingleFieldValueClass(klass)) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable(klass));
        }
        return Exportability.Allowed.INSTANCE;
    }

    private final ExportedDeclaration exportDeclarationImplicitly(IrClass klass) {
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(klass);
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, null, 2, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return new ExportedRegularClass(name2, true, members, nestedClasses, klass);
    }

    private final ExportedDeclaration exportOrdinaryClass(IrClass klass) {
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportOrdinaryClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportOrdinaryClass_u24lambda_u240.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual(exportability, Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual(exportability, Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass);
        }
        if (!Intrinsics.areEqual(exportability, Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, null, 2, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, members, nestedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportEnumClass(IrClass klass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumClass_u24lambda_u240.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual(exportability, Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual(exportability, Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass);
        }
        if (!Intrinsics.areEqual(exportability, Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrField it = (IrField)element$iv$iv;
            boolean bl3 = false;
            if (JsIrAttributesKt.getCorrespondingEnumEntry(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        CollectionsKt.keysToMap(enumEntries, (Function1)new Function1<IrEnumEntry, Integer>((Object)enumEntries){

            public final Integer invoke(IrEnumEntry p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((List)this.receiver).indexOf(p0);
            }
        });
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = this.exportClassDeclarations(klass, arg_0 -> ExportModelGenerator.exportEnumClass$lambda$2(this, arg_0));
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, members, nestedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedClassDeclarationsInfo exportClassDeclarations(IrClass klass, Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration> specialProcessing) {
        List members = new ArrayList();
        List specialMembers = new ArrayList();
        List nestedClasses = new ArrayList();
        boolean isImplicitlyExportedClass = AnnotationUtilsKt.isJsImplicitExport(klass);
        for (IrDeclaration declaration : klass.getDeclarations()) {
            Object object;
            IrDeclarationWithName candidate2;
            if (ExportModelGeneratorKt.access$getExportCandidate(declaration) == null || isImplicitlyExportedClass && !(candidate2 instanceof IrClass) || !ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context, declaration) || IrFakeOverrideUtilsKt.isFakeOverride(candidate2) && IrUtilsKt.isInterface(klass)) continue;
            ExportedDeclaration processingResult = specialProcessing.invoke(candidate2);
            if (processingResult != null) {
                specialMembers.add(processingResult);
                continue;
            }
            IrDeclarationWithName irDeclarationWithName = candidate2;
            if (irDeclarationWithName instanceof IrSimpleFunction) {
                CollectionsKt.addIfNotNull(members, this.exportFunction((IrSimpleFunction)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrConstructor) continue;
            if (irDeclarationWithName instanceof IrProperty) {
                CollectionsKt.addIfNotNull(members, this.exportProperty((IrProperty)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrClass) {
                if (IrUtilsKt.isInterface(klass)) {
                    ExportedClass exportedClass;
                    Collection collection = nestedClasses;
                    if (AdditionalIrUtilsKt.companionObject(klass) != null) {
                        void it;
                        Collection collection2 = collection;
                        boolean bl = false;
                        ExportedDeclaration exportedDeclaration = this.exportClass((IrClass)it);
                        exportedClass = exportedDeclaration instanceof ExportedClass ? (ExportedClass)exportedDeclaration : null;
                        collection = collection2;
                    } else {
                        exportedClass = null;
                    }
                    CollectionsKt.addIfNotNull(collection, exportedClass);
                    continue;
                }
                ExportedDeclaration ec = this.exportClass((IrClass)candidate2);
                if (ec instanceof ExportedClass) {
                    nestedClasses.add(ec);
                    continue;
                }
                CollectionsKt.addIfNotNull(members, ec);
                continue;
            }
            if (irDeclarationWithName instanceof IrField) {
                boolean ec;
                boolean bl = ec = Intrinsics.areEqual(candidate2.getOrigin(), IrDeclarationOrigin.Companion.getFIELD_FOR_OBJECT_INSTANCE()) || Intrinsics.areEqual(candidate2.getOrigin(), IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS()) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                if (!_Assertions.ENABLED || ec) continue;
                boolean $i$a$-assert-ExportModelGenerator$exportClassDeclarations$42 = false;
                String $i$a$-assert-ExportModelGenerator$exportClassDeclarations$42 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable(candidate2);
                throw new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClassDeclarations$42);
            }
            String message$iv = "Can't export member declaration";
            boolean $i$f$irError = false;
            Object $this$irError_u24lambda_u240$iv = object = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            Object $this$exportClassDeclarations_u24lambda_u243 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            ((IrExceptionBuilder)$this$exportClassDeclarations_u24lambda_u243).withIrEntry("declaration", declaration);
            Object builder$iv = object;
            throw new IllegalStateException(((IrExceptionBuilder)builder$iv).buildString().toString());
        }
        return new ExportedClassDeclarationsInfo(kotlin.collections.CollectionsKt.plus((Collection)specialMembers, (Iterable)members), nestedClasses);
    }

    static /* synthetic */ ExportedClassDeclarationsInfo exportClassDeclarations$default(ExportModelGenerator exportModelGenerator, IrClass irClass, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = ExportModelGenerator::exportClassDeclarations$lambda$0;
        }
        return exportModelGenerator.exportClassDeclarations(irClass, function1);
    }

    private final ExportedDeclaration exportClass(IrClass klass, List<? extends ExportedDeclaration> members, List<? extends ExportedClass> nestedClasses) {
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getObjectGetInstanceFunction(klass);
            Intrinsics.checkNotNull(irSimpleFunction);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            return new ExportedObject(name2, members, nestedClasses, klass, irSimpleFunction2);
        }
        return new ExportedRegularClass(name2, IrUtilsKt.isInterface(klass), members, nestedClasses, klass);
    }

    private final ExportedDeclaration exportAsEnumMember(IrDeclarationWithName candidate2) {
        IrDeclarationWithName irDeclarationWithName = candidate2;
        return irDeclarationWithName instanceof IrProperty ? (ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)candidate2, this.context) ? this.exportPropertyUnsafely((IrProperty)candidate2) : null) : (irDeclarationWithName instanceof IrField ? (ExportedDeclaration)(Intrinsics.areEqual(candidate2.getOrigin(), IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRY()) ? this.exportEnumEntry((IrField)candidate2) : null) : null);
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        IrClass parentClass;
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride() && !ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(function2, this.context)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME()) || Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR()) || Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME()) || Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getOBJECT_GET_INSTANCE_FUNCTION()) || Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_EXPORT()) || Intrinsics.areEqual(function2.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getENUM_GET_INSTANCE_FUNCTION())) {
            return Exportability.NotNeeded.INSTANCE;
        }
        IrDeclarationParent $i$f$any = function2.getParent();
        IrClass irClass = parentClass = $i$f$any instanceof IrClass ? (IrClass)$i$f$any : null;
        if (parentClass != null && Intrinsics.areEqual(JsIrAttributesKt.getInitEntryInstancesFun(parentClass), function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String nameString = string;
        if (StringsKt.endsWith$default(nameString, "-impl", false, 2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default(nameString, "$", false, 2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string2 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                        if (!StringsKt.contains$default((CharSequence)string2, "$mask", false, 2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(function2);
        if (parentClass == null && ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name2)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    private static final ExportedDeclaration exportEnumClass$lambda$2(ExportModelGenerator this$0, IrDeclarationWithName candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        ExportedDeclaration enumExportedMember = this$0.exportAsEnumMember(candidate2);
        return enumExportedMember;
    }

    private static final ExportedDeclaration exportClassDeclarations$lambda$0(IrDeclarationWithName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

