/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.tokenexchange;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenExchangeProvider;
import org.keycloak.protocol.oidc.tokenexchange.AbstractTokenExchangeProvider;
import org.keycloak.protocol.oidc.tokenexchange.StandardTokenExchangeProvider;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.managers.UserSessionManager;

public class ExternalToInternalTokenExchangeProvider
extends StandardTokenExchangeProvider {
    @Override
    public boolean supports(TokenExchangeContext context) {
        return this.isExternalInternalTokenExchangeRequest(context);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    protected Response tokenExchange() {
        String subjectToken = this.context.getParams().getSubjectToken();
        String subjectTokenType = this.context.getParams().getSubjectTokenType();
        String subjectIssuer = this.getSubjectIssuer(this.context, subjectToken, subjectTokenType);
        return this.exchangeExternalToken(subjectIssuer, subjectToken);
    }

    @Override
    protected List<String> getSupportedOAuthResponseTokenTypes() {
        return Arrays.asList("urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:id_token");
    }

    @Override
    protected String getRequestedTokenType() {
        String requestedTokenType = this.params.getRequestedTokenType();
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:access_token";
            return requestedTokenType;
        }
        if (this.getSupportedOAuthResponseTokenTypes().contains(requestedTokenType)) {
            return requestedTokenType;
        }
        this.event.detail("reason", "requested_token_type unsupported");
        this.event.error("invalid_request");
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }

    @Override
    protected Response exchangeExternalToken(String subjectIssuer, String subjectToken) {
        AbstractTokenExchangeProvider.ExternalExchangeContext externalExchangeContext = this.locateExchangeExternalTokenByAlias(subjectIssuer);
        if (externalExchangeContext == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        BrokeredIdentityContext context = externalExchangeContext.provider().exchangeExternal((TokenExchangeProvider)this, this.context);
        if (context == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.importUserFromExternalIdentity(context);
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteHost(), "external-exchange", false, null, null);
        externalExchangeContext.provider().exchangeExternalComplete(userSession, context, this.formParams);
        userSession.setNote("EXTERNAL_IDENTITY_PROVIDER", externalExchangeContext.idpModel().getAlias());
        userSession.setNote("FEDERATED_ACCESS_TOKEN", subjectToken);
        context.addSessionNotesToUserSession(userSession);
        return this.exchangeClientToClient(user, userSession, null, false);
    }
}

