/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.Date;
import liquibase.ChecksumVersion;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import lombok.Generated;

public class RanChangeSet {
    private String changeLog;
    private String storedChangeLog;
    private String id;
    private String author;
    private CheckSum lastCheckSum;
    private Date dateExecuted;
    private String tag;
    private ChangeSet.ExecType execType;
    private String description;
    private String comments;
    private Integer orderExecuted;
    private ContextExpression contextExpression;
    private Labels labels;
    private String deploymentId;
    private String liquibaseVersion;

    public RanChangeSet(ChangeSet changeSet) {
        this(changeSet, null, null, null);
    }

    public RanChangeSet(ChangeSet changeSet, ChangeSet.ExecType execType, ContextExpression contexts, Labels labels) {
        this(changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor(), changeSet.generateCheckSum(changeSet.getStoredCheckSum() != null ? ChecksumVersion.enumFromChecksumVersion(changeSet.getStoredCheckSum().getVersion()) : ChecksumVersion.latest()), new Date(), null, execType, changeSet.getDescription(), changeSet.getComments(), contexts, labels, null, changeSet.getStoredFilePath());
    }

    public RanChangeSet(String changeLog, String id, String author, CheckSum lastCheckSum, Date dateExecuted, String tag, ChangeSet.ExecType execType, String description, String comments, ContextExpression contextExpression, Labels labels, String deploymentId) {
        this(changeLog, id, author, lastCheckSum, dateExecuted, tag, execType, description, comments, contextExpression, labels, deploymentId, null);
    }

    public RanChangeSet(String changeLog, String id, String author, CheckSum lastCheckSum, Date dateExecuted, String tag, ChangeSet.ExecType execType, String description, String comments, ContextExpression contextExpression, Labels labels, String deploymentId, String storedChangeLog) {
        this.changeLog = changeLog;
        this.storedChangeLog = storedChangeLog;
        this.id = id;
        this.author = author;
        this.lastCheckSum = lastCheckSum;
        this.dateExecuted = dateExecuted == null ? null : new Date(dateExecuted.getTime());
        this.tag = tag;
        this.execType = execType;
        this.description = description;
        this.comments = comments;
        this.contextExpression = contextExpression;
        this.labels = labels;
        this.deploymentId = deploymentId;
    }

    public Date getDateExecuted() {
        if (this.dateExecuted == null) {
            return null;
        }
        return (Date)this.dateExecuted.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RanChangeSet that = (RanChangeSet)o;
        return this.author.equals(that.author) && this.changeLog.equals(that.changeLog) && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.changeLog.hashCode();
        result = 29 * result + this.id.hashCode();
        result = 29 * result + this.author.hashCode();
        return result;
    }

    public String toString() {
        return DatabaseChangeLog.normalizePath(this.getChangeLog()) + "::" + this.getId() + "::" + this.getAuthor();
    }

    public boolean isSameAs(ChangeSet changeSet) {
        return this.getId().equalsIgnoreCase(changeSet.getId()) && this.getAuthor().equalsIgnoreCase(changeSet.getAuthor()) && this.isSamePath(changeSet.getFilePath());
    }

    private boolean isSamePath(String filePath) {
        String normalizedFilePath = DatabaseChangeLog.normalizePath(this.getChangeLog());
        return normalizedFilePath.equalsIgnoreCase(DatabaseChangeLog.normalizePath(filePath));
    }

    @Generated
    public RanChangeSet() {
    }

    @Generated
    public String getChangeLog() {
        return this.changeLog;
    }

    @Generated
    public String getStoredChangeLog() {
        return this.storedChangeLog;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public CheckSum getLastCheckSum() {
        return this.lastCheckSum;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public ChangeSet.ExecType getExecType() {
        return this.execType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public Integer getOrderExecuted() {
        return this.orderExecuted;
    }

    @Generated
    public ContextExpression getContextExpression() {
        return this.contextExpression;
    }

    @Generated
    public Labels getLabels() {
        return this.labels;
    }

    @Generated
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Generated
    public String getLiquibaseVersion() {
        return this.liquibaseVersion;
    }

    @Generated
    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    @Generated
    public void setStoredChangeLog(String storedChangeLog) {
        this.storedChangeLog = storedChangeLog;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setLastCheckSum(CheckSum lastCheckSum) {
        this.lastCheckSum = lastCheckSum;
    }

    @Generated
    public void setDateExecuted(Date dateExecuted) {
        this.dateExecuted = dateExecuted;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setExecType(ChangeSet.ExecType execType) {
        this.execType = execType;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Generated
    public void setOrderExecuted(Integer orderExecuted) {
        this.orderExecuted = orderExecuted;
    }

    @Generated
    public void setContextExpression(ContextExpression contextExpression) {
        this.contextExpression = contextExpression;
    }

    @Generated
    public void setLabels(Labels labels) {
        this.labels = labels;
    }

    @Generated
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Generated
    public void setLiquibaseVersion(String liquibaseVersion) {
        this.liquibaseVersion = liquibaseVersion;
    }
}

