/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.NoBatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.builder.ColumnValuesTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.RestrictedTableMutationBuilder;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;

@Internal
public abstract class AbstractMutationCoordinator {
    protected final EntityPersister entityPersister;
    protected final SessionFactoryImplementor factory;
    protected final MutationExecutorService mutationExecutorService;
    protected final Dialect dialect;

    public AbstractMutationCoordinator(EntityPersister entityPersister, SessionFactoryImplementor factory) {
        this.entityPersister = entityPersister;
        this.factory = factory;
        this.dialect = factory.getJdbcServices().getDialect();
        this.mutationExecutorService = factory.getServiceRegistry().getService(MutationExecutorService.class);
    }

    protected EntityPersister entityPersister() {
        return this.entityPersister;
    }

    protected SessionFactoryImplementor factory() {
        return this.factory;
    }

    protected Dialect dialect() {
        return this.dialect;
    }

    protected BatchKeyAccess resolveBatchKeyAccess(boolean dynamicUpdate, SharedSessionContractImplementor session) {
        if (!dynamicUpdate && !this.entityPersister().optimisticLockStyle().isAllOrDirty() && session.getTransactionCoordinator() != null && session.getTransactionCoordinator().isTransactionActive()) {
            return this::getBatchKey;
        }
        return NoBatchKeyAccess.INSTANCE;
    }

    protected abstract BatchKey getBatchKey();

    protected MutationOperationGroup createOperationGroup(ValuesAnalysis valuesAnalysis, MutationGroup mutationGroup) {
        int numberOfTableMutations = mutationGroup.getNumberOfTableMutations();
        switch (numberOfTableMutations) {
            case 0: {
                return MutationOperationGroupFactory.noOperations(mutationGroup);
            }
            case 1: {
                MutationOperation operation = this.createOperation(valuesAnalysis, mutationGroup.getSingleTableMutation());
                return operation == null ? MutationOperationGroupFactory.noOperations(mutationGroup) : MutationOperationGroupFactory.singleOperation(mutationGroup, operation);
            }
        }
        MutationOperation[] operations = new MutationOperation[numberOfTableMutations];
        int outputIndex = 0;
        int skipped = 0;
        for (int i = 0; i < mutationGroup.getNumberOfTableMutations(); ++i) {
            TableMutation tableMutation = mutationGroup.getTableMutation(i);
            Object operation = tableMutation.createMutationOperation(valuesAnalysis, this.factory);
            if (operation != null) {
                operations[outputIndex++] = operation;
                continue;
            }
            ++skipped;
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping table update - %s", (Object)tableMutation.getTableName());
        }
        if (skipped != 0) {
            MutationOperation[] trimmed = new MutationOperation[outputIndex];
            System.arraycopy(operations, 0, trimmed, 0, outputIndex);
            operations = trimmed;
        }
        return MutationOperationGroupFactory.manyOperations(mutationGroup.getMutationType(), this.entityPersister, operations);
    }

    protected MutationOperation createOperation(ValuesAnalysis valuesAnalysis, TableMutation<?> singleTableMutation) {
        return singleTableMutation.createMutationOperation(valuesAnalysis, this.factory());
    }

    protected void handleValueGeneration(AttributeMapping attributeMapping, MutationGroupBuilder mutationGroupBuilder, OnExecutionGenerator generator) {
        Dialect dialect = this.factory.getJdbcServices().getDialect();
        boolean writePropertyValue = generator.writePropertyValue();
        String[] columnValues = writePropertyValue ? null : generator.getReferencedColumnValues(dialect);
        attributeMapping.forEachSelectable((j, mapping) -> {
            String tableName = this.entityPersister.physicalTableNameForMutation(mapping);
            ColumnValuesTableMutationBuilder tableUpdateBuilder = (ColumnValuesTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(tableName);
            tableUpdateBuilder.addValueColumn(mapping.getSelectionExpression(), writePropertyValue ? "?" : columnValues[j], mapping.getJdbcMapping(), mapping.isLob());
        });
    }

    protected void bindPartitionColumnValueBindings(Object[] loadedState, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        EntityPersister persister = this.entityPersister();
        if (persister.hasPartitionedSelectionMapping()) {
            AttributeMappingsList attributeMappings = persister.getAttributeMappings();
            int size = attributeMappings.size();
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = attributeMappings.get(i);
                if (!attributeMapping.hasPartitionedSelectionMapping()) continue;
                attributeMapping.decompose(loadedState[i], 0, jdbcValueBindings, null, (valueIndex, bindings, noop, value, jdbcValueMapping) -> {
                    if (jdbcValueMapping.isPartitioned()) {
                        bindings.bindValue(value, jdbcValueMapping, ParameterUsage.RESTRICT);
                    }
                }, session);
            }
        }
    }

    protected static boolean needsRowId(EntityPersister entityPersister, EntityTableMapping tableMapping) {
        return entityPersister.getRowIdMapping() != null && tableMapping.isIdentifierTable();
    }

    protected static void applyKeyRestriction(Object rowId, EntityPersister entityPersister, RestrictedTableMutationBuilder<?, ?> tableMutationBuilder, EntityTableMapping tableMapping) {
        if (rowId != null && AbstractMutationCoordinator.needsRowId(entityPersister, tableMapping)) {
            tableMutationBuilder.addKeyRestrictionLeniently(entityPersister.getRowIdMapping());
        } else {
            tableMutationBuilder.addKeyRestrictions(tableMapping.getKeyMapping());
        }
    }

    protected void breakDownKeyJdbcValues(Object id, Object rowId, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableMapping) {
        if (rowId != null && AbstractMutationCoordinator.needsRowId(this.entityPersister(), tableMapping)) {
            jdbcValueBindings.bindValue(rowId, tableMapping.getTableName(), this.entityPersister().getRowIdMapping().getRowIdName(), ParameterUsage.RESTRICT);
        } else {
            tableMapping.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableMapping.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT), session);
        }
    }
}

