/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jspecview.api.JSVFileHelper;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.java.AwtDialogFileFilter;
import jspecview.java.AwtFile;
import org.jmol.api.GenericFileInterface;

public class AwtFileHelper
implements JSVFileHelper {
    public String dirLastOpened;
    public boolean useDirLastOpened;
    public boolean useDirLastExported;
    public String dirLastExported;
    private JFileChooser fc;
    private JSViewer vwr;

    @Override
    public AwtFileHelper set(JSViewer jSViewer) {
        this.vwr = jSViewer;
        return this;
    }

    @Override
    public void setFileChooser(ExportType exportType) {
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        AwtDialogFileFilter awtDialogFileFilter = new AwtDialogFileFilter();
        this.fc.resetChoosableFileFilters();
        switch (exportType) {
            case UNK: {
                awtDialogFileFilter = new AwtDialogFileFilter();
                awtDialogFileFilter.addExtension("xml");
                awtDialogFileFilter.addExtension("aml");
                awtDialogFileFilter.addExtension("cml");
                awtDialogFileFilter.setDescription("CML/XML Files");
                this.fc.setFileFilter(awtDialogFileFilter);
                awtDialogFileFilter = new AwtDialogFileFilter();
                awtDialogFileFilter.addExtension("jdx");
                awtDialogFileFilter.addExtension("dx");
                awtDialogFileFilter.setDescription("JCAMP-DX Files");
                this.fc.setFileFilter(awtDialogFileFilter);
                break;
            }
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                awtDialogFileFilter.addExtension("jdx");
                awtDialogFileFilter.addExtension("dx");
                awtDialogFileFilter.setDescription("JCAMP-DX Files");
                break;
            }
            default: {
                awtDialogFileFilter.addExtension(exportType.toString().toLowerCase());
                awtDialogFileFilter.setDescription((Object)((Object)exportType) + " Files");
            }
        }
        this.fc.setFileFilter(awtDialogFileFilter);
    }

    @Override
    public GenericFileInterface showFileOpenDialog(Object object, Object[] objectArray) {
        this.setFileChooser(ExportType.UNK);
        return this.getFile("", object, false);
    }

    @Override
    public GenericFileInterface getFile(String string, Object object, boolean bl) {
        int n;
        if (!this.vwr.hasDisplay) {
            return null;
        }
        Component component = (Component)object;
        this.fc.setSelectedFile(new File(string));
        if (bl) {
            this.fc.setFileSelectionMode(0);
            if (this.useDirLastExported) {
                this.fc.setCurrentDirectory(new File(this.dirLastExported));
            }
        } else {
            this.fc.setFileSelectionMode(2);
            if (this.useDirLastOpened) {
                this.fc.setCurrentDirectory(new File(this.dirLastOpened));
            }
        }
        int n2 = n = bl ? this.fc.showSaveDialog(component) : this.fc.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        AwtFile awtFile = new AwtFile(this.fc.getSelectedFile().getAbsolutePath());
        if (bl) {
            int n3;
            this.dirLastExported = awtFile.getParent();
            this.vwr.setProperty("directoryLastExportedFile", this.dirLastExported);
            if (awtFile.exists() && (n3 = JOptionPane.showConfirmDialog(component, "Overwrite " + awtFile.getName() + "?", "Confirm Overwrite Existing File", 0, 3)) == 1) {
                return null;
            }
        } else {
            this.dirLastOpened = awtFile.getParent();
            this.vwr.setProperty("directoryLastOpenedFile", this.dirLastOpened);
        }
        return awtFile;
    }

    @Override
    public String setDirLastExported(String string) {
        this.dirLastExported = string;
        return this.dirLastExported;
    }

    @Override
    public String getUrlFromDialog(String string, String string2) {
        return (String)JOptionPane.showInputDialog(null, string, "Open URL", -1, null, null, string2);
    }
}

