#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-sapic
version:              1.10.0
visibility:           public
id:                   tamarin-prover-sapic-1.10.0-6H1RoIDnUlY3QkY6UTFSos
key:                  tamarin-prover-sapic-1.10.0-6H1RoIDnUlY3QkY6UTFSos
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  573cbe44773dd3c81525ddbbd5ed4d0f
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Bindings
    Sapic.Compression Sapic.Exceptions Sapic.Facts Sapic.LetDestructors
    Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels Sapic.States Sapic.Typing
    Sapic.Warnings

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-sapic
hs-libraries:         HStamarin-prover-sapic-1.10.0-6H1RoIDnUlY3QkY6UTFSos
depends:
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    aeson-pretty-0.8.10-LSDchJgtnQ46sIK4bUu3co base-4.18.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    dlist-1.0-B7D1vsARFiIHVaGk5CGbYO exceptions-0.10.7
    fclabels-2.0.5.1-7N0HCwWfRM0Bq8M2ZnpsmD mtl-2.3.1
    parallel-3.2.2.0-4GFGhbl8Ae06nPoqdIyBUD parsec-3.1.16.1
    process-1.6.19.0 raw-strings-qq-1.1-HgsCJbBD5QVLggpDhmUWHl
    safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    tamarin-prover-term-1.10.0-K1DwPJWoWIKF5CFDcqNbBl
    tamarin-prover-theory-1.10.0-B343wTQjW1PB1xylIhass1
    tamarin-prover-utils-1.10.0-6O4xovRc5rA2UtTdwPacBp text-2.0.2
    transformers-0.6.1.0 uniplate-1.6.13-3P4N77JJWXwIhcpvSX1zzA

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

