/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.freeplane.core.ui.DelayedMouseListener;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.view.swing.ui.mindmapmode.GlassPaneNodeSelector;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;

public class GlassPaneManager
implements AncestorListener {
    private final IMouseListener mouseListener;
    private final JRootPane rootPane;

    public GlassPaneManager(JRootPane jframe, INodeSelector nodeSelector) {
        this.mouseListener = new DelayedMouseListener((IMouseListener)new GlassPaneNodeSelector(nodeSelector), 2, 1);
        this.rootPane = jframe;
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        Component glassPane = this.rootPane.getRootPane().getGlassPane();
        glassPane.removeMouseListener((MouseListener)this.mouseListener);
        glassPane.removeMouseMotionListener((MouseMotionListener)this.mouseListener);
        glassPane.setVisible(false);
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.rootPane);
        windowAncestor.setFocusableWindowState(true);
        Component mostRecentFocusOwner = windowAncestor.getMostRecentFocusOwner();
        if (mostRecentFocusOwner != null) {
            mostRecentFocusOwner.requestFocus();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        Component glassPane = this.rootPane.getRootPane().getGlassPane();
        glassPane.addMouseListener((MouseListener)this.mouseListener);
        glassPane.addMouseMotionListener((MouseMotionListener)this.mouseListener);
        glassPane.setVisible(true);
        SwingUtilities.getWindowAncestor(this.rootPane).setFocusableWindowState(false);
    }
}

