/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.ui.properties.PropertyDescriptorDelegate;
import org.jkiss.utils.CommonUtils;

public class PropertySourceDelegate
implements IPropertySource2 {
    private final DBPPropertySource source;

    public PropertySourceDelegate(DBPPropertySource source) {
        this.source = source;
    }

    public boolean isPropertyResettable(Object id) {
        return this.source.isPropertyResettable(CommonUtils.toString((Object)id));
    }

    public Object getEditableValue() {
        return this.source.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        DBPPropertyDescriptor[] src = this.source.getProperties();
        if (src == null) {
            return null;
        }
        IPropertyDescriptor[] dst = new IPropertyDescriptor[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = new PropertyDescriptorDelegate(this.source, src[i]);
        }
        return dst;
    }

    public Object getPropertyValue(Object id) {
        Object value = this.source.getPropertyValue(null, CommonUtils.toString((Object)id));
        if (value instanceof DBPNamedObject) {
            return ((DBPNamedObject)value).getName();
        }
        return CommonUtils.toString((Object)value);
    }

    public boolean isPropertySet(Object id) {
        return this.source.isPropertySet(CommonUtils.toString((Object)id));
    }

    public void resetPropertyValue(Object id) {
        this.source.resetPropertyValue(null, CommonUtils.toString((Object)id));
    }

    public void setPropertyValue(Object id, Object value) {
        this.source.setPropertyValue(null, CommonUtils.toString((Object)id), value);
    }
}

