﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/supplychain/SupplyChain_EXPORTS.h>
#include <aws/supplychain/model/Instance.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SupplyChain {
namespace Model {
/**
 * <p>The response parameters for DeleteInstance.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/supplychain-2024-01-01/DeleteInstanceResponse">AWS
 * API Reference</a></p>
 */
class DeleteInstanceResult {
 public:
  AWS_SUPPLYCHAIN_API DeleteInstanceResult() = default;
  AWS_SUPPLYCHAIN_API DeleteInstanceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SUPPLYCHAIN_API DeleteInstanceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The AWS Supply Chain instance resource data details.</p>
   */
  inline const Instance& GetInstance() const { return m_instance; }
  template <typename InstanceT = Instance>
  void SetInstance(InstanceT&& value) {
    m_instanceHasBeenSet = true;
    m_instance = std::forward<InstanceT>(value);
  }
  template <typename InstanceT = Instance>
  DeleteInstanceResult& WithInstance(InstanceT&& value) {
    SetInstance(std::forward<InstanceT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteInstanceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Instance m_instance;

  Aws::String m_requestId;
  bool m_instanceHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SupplyChain
}  // namespace Aws
