﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/gamelift/GameLift_EXPORTS.h>

namespace Aws {
namespace GameLift {
namespace Model {
enum class EC2InstanceType {
  NOT_SET,
  t2_micro,
  t2_small,
  t2_medium,
  t2_large,
  c3_large,
  c3_xlarge,
  c3_2xlarge,
  c3_4xlarge,
  c3_8xlarge,
  c4_large,
  c4_xlarge,
  c4_2xlarge,
  c4_4xlarge,
  c4_8xlarge,
  c5_large,
  c5_xlarge,
  c5_2xlarge,
  c5_4xlarge,
  c5_9xlarge,
  c5_12xlarge,
  c5_18xlarge,
  c5_24xlarge,
  c5a_large,
  c5a_xlarge,
  c5a_2xlarge,
  c5a_4xlarge,
  c5a_8xlarge,
  c5a_12xlarge,
  c5a_16xlarge,
  c5a_24xlarge,
  r3_large,
  r3_xlarge,
  r3_2xlarge,
  r3_4xlarge,
  r3_8xlarge,
  r4_large,
  r4_xlarge,
  r4_2xlarge,
  r4_4xlarge,
  r4_8xlarge,
  r4_16xlarge,
  r5_large,
  r5_xlarge,
  r5_2xlarge,
  r5_4xlarge,
  r5_8xlarge,
  r5_12xlarge,
  r5_16xlarge,
  r5_24xlarge,
  r5a_large,
  r5a_xlarge,
  r5a_2xlarge,
  r5a_4xlarge,
  r5a_8xlarge,
  r5a_12xlarge,
  r5a_16xlarge,
  r5a_24xlarge,
  m3_medium,
  m3_large,
  m3_xlarge,
  m3_2xlarge,
  m4_large,
  m4_xlarge,
  m4_2xlarge,
  m4_4xlarge,
  m4_10xlarge,
  m5_large,
  m5_xlarge,
  m5_2xlarge,
  m5_4xlarge,
  m5_8xlarge,
  m5_12xlarge,
  m5_16xlarge,
  m5_24xlarge,
  m5a_large,
  m5a_xlarge,
  m5a_2xlarge,
  m5a_4xlarge,
  m5a_8xlarge,
  m5a_12xlarge,
  m5a_16xlarge,
  m5a_24xlarge,
  c5d_large,
  c5d_xlarge,
  c5d_2xlarge,
  c5d_4xlarge,
  c5d_9xlarge,
  c5d_12xlarge,
  c5d_18xlarge,
  c5d_24xlarge,
  c6a_large,
  c6a_xlarge,
  c6a_2xlarge,
  c6a_4xlarge,
  c6a_8xlarge,
  c6a_12xlarge,
  c6a_16xlarge,
  c6a_24xlarge,
  c6i_large,
  c6i_xlarge,
  c6i_2xlarge,
  c6i_4xlarge,
  c6i_8xlarge,
  c6i_12xlarge,
  c6i_16xlarge,
  c6i_24xlarge,
  r5d_large,
  r5d_xlarge,
  r5d_2xlarge,
  r5d_4xlarge,
  r5d_8xlarge,
  r5d_12xlarge,
  r5d_16xlarge,
  r5d_24xlarge,
  m6g_medium,
  m6g_large,
  m6g_xlarge,
  m6g_2xlarge,
  m6g_4xlarge,
  m6g_8xlarge,
  m6g_12xlarge,
  m6g_16xlarge,
  c6g_medium,
  c6g_large,
  c6g_xlarge,
  c6g_2xlarge,
  c6g_4xlarge,
  c6g_8xlarge,
  c6g_12xlarge,
  c6g_16xlarge,
  r6g_medium,
  r6g_large,
  r6g_xlarge,
  r6g_2xlarge,
  r6g_4xlarge,
  r6g_8xlarge,
  r6g_12xlarge,
  r6g_16xlarge,
  c6gn_medium,
  c6gn_large,
  c6gn_xlarge,
  c6gn_2xlarge,
  c6gn_4xlarge,
  c6gn_8xlarge,
  c6gn_12xlarge,
  c6gn_16xlarge,
  c7g_medium,
  c7g_large,
  c7g_xlarge,
  c7g_2xlarge,
  c7g_4xlarge,
  c7g_8xlarge,
  c7g_12xlarge,
  c7g_16xlarge,
  r7g_medium,
  r7g_large,
  r7g_xlarge,
  r7g_2xlarge,
  r7g_4xlarge,
  r7g_8xlarge,
  r7g_12xlarge,
  r7g_16xlarge,
  m7g_medium,
  m7g_large,
  m7g_xlarge,
  m7g_2xlarge,
  m7g_4xlarge,
  m7g_8xlarge,
  m7g_12xlarge,
  m7g_16xlarge,
  g5g_xlarge,
  g5g_2xlarge,
  g5g_4xlarge,
  g5g_8xlarge,
  g5g_16xlarge,
  r6i_large,
  r6i_xlarge,
  r6i_2xlarge,
  r6i_4xlarge,
  r6i_8xlarge,
  r6i_12xlarge,
  r6i_16xlarge,
  c6gd_medium,
  c6gd_large,
  c6gd_xlarge,
  c6gd_2xlarge,
  c6gd_4xlarge,
  c6gd_8xlarge,
  c6gd_12xlarge,
  c6gd_16xlarge,
  c6in_large,
  c6in_xlarge,
  c6in_2xlarge,
  c6in_4xlarge,
  c6in_8xlarge,
  c6in_12xlarge,
  c6in_16xlarge,
  c7a_medium,
  c7a_large,
  c7a_xlarge,
  c7a_2xlarge,
  c7a_4xlarge,
  c7a_8xlarge,
  c7a_12xlarge,
  c7a_16xlarge,
  c7gd_medium,
  c7gd_large,
  c7gd_xlarge,
  c7gd_2xlarge,
  c7gd_4xlarge,
  c7gd_8xlarge,
  c7gd_12xlarge,
  c7gd_16xlarge,
  c7gn_medium,
  c7gn_large,
  c7gn_xlarge,
  c7gn_2xlarge,
  c7gn_4xlarge,
  c7gn_8xlarge,
  c7gn_12xlarge,
  c7gn_16xlarge,
  c7i_large,
  c7i_xlarge,
  c7i_2xlarge,
  c7i_4xlarge,
  c7i_8xlarge,
  c7i_12xlarge,
  c7i_16xlarge,
  m6a_large,
  m6a_xlarge,
  m6a_2xlarge,
  m6a_4xlarge,
  m6a_8xlarge,
  m6a_12xlarge,
  m6a_16xlarge,
  m6gd_medium,
  m6gd_large,
  m6gd_xlarge,
  m6gd_2xlarge,
  m6gd_4xlarge,
  m6gd_8xlarge,
  m6gd_12xlarge,
  m6gd_16xlarge,
  m6i_large,
  m6i_xlarge,
  m6i_2xlarge,
  m6i_4xlarge,
  m6i_8xlarge,
  m6i_12xlarge,
  m6i_16xlarge,
  m7a_medium,
  m7a_large,
  m7a_xlarge,
  m7a_2xlarge,
  m7a_4xlarge,
  m7a_8xlarge,
  m7a_12xlarge,
  m7a_16xlarge,
  m7gd_medium,
  m7gd_large,
  m7gd_xlarge,
  m7gd_2xlarge,
  m7gd_4xlarge,
  m7gd_8xlarge,
  m7gd_12xlarge,
  m7gd_16xlarge,
  m7i_large,
  m7i_xlarge,
  m7i_2xlarge,
  m7i_4xlarge,
  m7i_8xlarge,
  m7i_12xlarge,
  m7i_16xlarge,
  r6gd_medium,
  r6gd_large,
  r6gd_xlarge,
  r6gd_2xlarge,
  r6gd_4xlarge,
  r6gd_8xlarge,
  r6gd_12xlarge,
  r6gd_16xlarge,
  r7a_medium,
  r7a_large,
  r7a_xlarge,
  r7a_2xlarge,
  r7a_4xlarge,
  r7a_8xlarge,
  r7a_12xlarge,
  r7a_16xlarge,
  r7gd_medium,
  r7gd_large,
  r7gd_xlarge,
  r7gd_2xlarge,
  r7gd_4xlarge,
  r7gd_8xlarge,
  r7gd_12xlarge,
  r7gd_16xlarge,
  r7i_large,
  r7i_xlarge,
  r7i_2xlarge,
  r7i_4xlarge,
  r7i_8xlarge,
  r7i_12xlarge,
  r7i_16xlarge,
  r7i_24xlarge,
  r7i_48xlarge,
  c5ad_large,
  c5ad_xlarge,
  c5ad_2xlarge,
  c5ad_4xlarge,
  c5ad_8xlarge,
  c5ad_12xlarge,
  c5ad_16xlarge,
  c5ad_24xlarge,
  c5n_large,
  c5n_xlarge,
  c5n_2xlarge,
  c5n_4xlarge,
  c5n_9xlarge,
  c5n_18xlarge,
  r5ad_large,
  r5ad_xlarge,
  r5ad_2xlarge,
  r5ad_4xlarge,
  r5ad_8xlarge,
  r5ad_12xlarge,
  r5ad_16xlarge,
  r5ad_24xlarge,
  c6id_large,
  c6id_xlarge,
  c6id_2xlarge,
  c6id_4xlarge,
  c6id_8xlarge,
  c6id_12xlarge,
  c6id_16xlarge,
  c6id_24xlarge,
  c6id_32xlarge,
  c8g_medium,
  c8g_large,
  c8g_xlarge,
  c8g_2xlarge,
  c8g_4xlarge,
  c8g_8xlarge,
  c8g_12xlarge,
  c8g_16xlarge,
  c8g_24xlarge,
  c8g_48xlarge,
  m5ad_large,
  m5ad_xlarge,
  m5ad_2xlarge,
  m5ad_4xlarge,
  m5ad_8xlarge,
  m5ad_12xlarge,
  m5ad_16xlarge,
  m5ad_24xlarge,
  m5d_large,
  m5d_xlarge,
  m5d_2xlarge,
  m5d_4xlarge,
  m5d_8xlarge,
  m5d_12xlarge,
  m5d_16xlarge,
  m5d_24xlarge,
  m5dn_large,
  m5dn_xlarge,
  m5dn_2xlarge,
  m5dn_4xlarge,
  m5dn_8xlarge,
  m5dn_12xlarge,
  m5dn_16xlarge,
  m5dn_24xlarge,
  m5n_large,
  m5n_xlarge,
  m5n_2xlarge,
  m5n_4xlarge,
  m5n_8xlarge,
  m5n_12xlarge,
  m5n_16xlarge,
  m5n_24xlarge,
  m6id_large,
  m6id_xlarge,
  m6id_2xlarge,
  m6id_4xlarge,
  m6id_8xlarge,
  m6id_12xlarge,
  m6id_16xlarge,
  m6id_24xlarge,
  m6id_32xlarge,
  m6idn_large,
  m6idn_xlarge,
  m6idn_2xlarge,
  m6idn_4xlarge,
  m6idn_8xlarge,
  m6idn_12xlarge,
  m6idn_16xlarge,
  m6idn_24xlarge,
  m6idn_32xlarge,
  m6in_large,
  m6in_xlarge,
  m6in_2xlarge,
  m6in_4xlarge,
  m6in_8xlarge,
  m6in_12xlarge,
  m6in_16xlarge,
  m6in_24xlarge,
  m6in_32xlarge,
  m8g_medium,
  m8g_large,
  m8g_xlarge,
  m8g_2xlarge,
  m8g_4xlarge,
  m8g_8xlarge,
  m8g_12xlarge,
  m8g_16xlarge,
  m8g_24xlarge,
  m8g_48xlarge,
  r5dn_large,
  r5dn_xlarge,
  r5dn_2xlarge,
  r5dn_4xlarge,
  r5dn_8xlarge,
  r5dn_12xlarge,
  r5dn_16xlarge,
  r5dn_24xlarge,
  r5n_large,
  r5n_xlarge,
  r5n_2xlarge,
  r5n_4xlarge,
  r5n_8xlarge,
  r5n_12xlarge,
  r5n_16xlarge,
  r5n_24xlarge,
  r6a_large,
  r6a_xlarge,
  r6a_2xlarge,
  r6a_4xlarge,
  r6a_8xlarge,
  r6a_12xlarge,
  r6a_16xlarge,
  r6a_24xlarge,
  r6a_32xlarge,
  r6a_48xlarge,
  r6id_large,
  r6id_xlarge,
  r6id_2xlarge,
  r6id_4xlarge,
  r6id_8xlarge,
  r6id_12xlarge,
  r6id_16xlarge,
  r6id_24xlarge,
  r6id_32xlarge,
  r6idn_large,
  r6idn_xlarge,
  r6idn_2xlarge,
  r6idn_4xlarge,
  r6idn_8xlarge,
  r6idn_12xlarge,
  r6idn_16xlarge,
  r6idn_24xlarge,
  r6idn_32xlarge,
  r6in_large,
  r6in_xlarge,
  r6in_2xlarge,
  r6in_4xlarge,
  r6in_8xlarge,
  r6in_12xlarge,
  r6in_16xlarge,
  r6in_24xlarge,
  r6in_32xlarge,
  r8g_medium,
  r8g_large,
  r8g_xlarge,
  r8g_2xlarge,
  r8g_4xlarge,
  r8g_8xlarge,
  r8g_12xlarge,
  r8g_16xlarge,
  r8g_24xlarge,
  r8g_48xlarge,
  m4_16xlarge,
  c6a_32xlarge,
  c6a_48xlarge,
  c6i_32xlarge,
  r6i_24xlarge,
  r6i_32xlarge,
  c6in_24xlarge,
  c6in_32xlarge,
  c7a_24xlarge,
  c7a_32xlarge,
  c7a_48xlarge,
  c7i_24xlarge,
  c7i_48xlarge,
  m6a_24xlarge,
  m6a_32xlarge,
  m6a_48xlarge,
  m6i_24xlarge,
  m6i_32xlarge,
  m7a_24xlarge,
  m7a_32xlarge,
  m7a_48xlarge,
  m7i_24xlarge,
  m7i_48xlarge,
  r7a_24xlarge,
  r7a_32xlarge,
  r7a_48xlarge
};

namespace EC2InstanceTypeMapper {
AWS_GAMELIFT_API EC2InstanceType GetEC2InstanceTypeForName(const Aws::String& name);

AWS_GAMELIFT_API Aws::String GetNameForEC2InstanceType(EC2InstanceType value);
}  // namespace EC2InstanceTypeMapper
}  // namespace Model
}  // namespace GameLift
}  // namespace Aws
