export namespace handlers {
    export { blockquote };
    export { break_ as break };
    export { code };
    export { ignore as definition };
    export { delete_ as delete };
    export { emphasis };
    export { ignore as footnoteDefinition };
    export { ignore as footnoteReference };
    export { heading };
    export { ignore as html };
    export { image };
    export { imageReference };
    export { inlineCode };
    export { link };
    export { linkReference };
    export { list };
    export { listItem };
    export { paragraph };
    export { root };
    export { strong };
    export { table };
    export { ignore as tableCell };
    export { ignore as tableRow };
    export { text };
    export { thematicBreak };
    export { ignore as yaml };
}
export type Blockquote = import('mdast').Blockquote;
export type Code = import('mdast').Code;
export type Delete = import('mdast').Delete;
export type Emphasis = import('mdast').Emphasis;
export type Heading = import('mdast').Heading;
export type Image = import('mdast').Image;
export type ImageReference = import('mdast').ImageReference;
export type InlineCode = import('mdast').InlineCode;
export type Link = import('mdast').Link;
export type LinkReference = import('mdast').LinkReference;
export type List = import('mdast').List;
export type ListItem = import('mdast').ListItem;
export type Nodes = import('mdast').Nodes;
export type Paragraph = import('mdast').Paragraph;
export type Root = import('mdast').Root;
export type Strong = import('mdast').Strong;
export type Table = import('mdast').Table;
export type Text = import('mdast').Text;
export type Handle = import('./to-roff.js').Handle;
export type State = import('./to-roff.js').State;
/**
 * Handle block quote.
 *
 * @satisfies {Handle}
 * @param {Blockquote} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function blockquote(node: Blockquote, state: State): string;
/**
 * Handle break.
 *
 * @satisfies {Handle}
 * @returns {string}
 *   Roff.
 */
declare function break_(): string;
/**
 * Handle code.
 *
 * @satisfies {Handle}
 * @param {Code} node
 *   Node.
 * @returns {string}
 *   Roff.
 */
declare function code(node: Code): string;
/**
 * Handle explicitly ignored nodes.
 *
 * @satisfies {Handle}
 * @returns {undefined}
 *   Nothing.
 */
declare function ignore(): undefined;
/**
 * Handle GFM delete.
 *
 * @satisfies {Handle}
 * @param {Delete} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function delete_(node: Delete, state: State): string;
/**
 * Handle emphasis.
 *
 * @satisfies {Handle}
 * @param {Emphasis} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function emphasis(node: Emphasis, state: State): string;
/**
 * Handle heading.
 *
 * @satisfies {Handle}
 * @param {Heading} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string | undefined}
 *   Roff.
 */
declare function heading(node: Heading, state: State): string | undefined;
/**
 * Handle image.
 *
 * @satisfies {Handle}
 * @param {Image} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function image(node: Image, state: State): string;
/**
 * Handle image reference.
 *
 * @satisfies {Handle}
 * @param {ImageReference} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function imageReference(node: ImageReference, state: State): string;
/**
 * Handle code (text).
 *
 * @satisfies {Handle}
 * @param {InlineCode} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function inlineCode(node: InlineCode, state: State): string;
/**
 * Handle link.
 *
 * @satisfies {Handle}
 * @param {Link} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function link(node: Link, state: State): string;
/**
 * Handle link reference.
 *
 * @satisfies {Handle}
 * @param {LinkReference} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function linkReference(node: LinkReference, state: State): string;
/**
 * Handle list.
 *
 * @satisfies {Handle}
 * @param {List} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function list(node: List, state: State): string;
/**
 * Handle list item.
 *
 * @satisfies {Handle}
 * @param {ListItem} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @param {string | undefined} [marker]
 *   Marker (if parent is list).
 * @returns {string}
 *   Roff.
 */
declare function listItem(node: ListItem, state: State, marker?: string | undefined): string;
/**
 * Handle paragraph.
 *
 * @satisfies {Handle}
 * @param {Paragraph} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function paragraph(node: Paragraph, state: State): string;
/**
 * Handle root.
 *
 * @satisfies {Handle}
 * @param {Root} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function root(node: Root, state: State): string;
/**
 * Handle strong.
 *
 * @satisfies {Handle}
 * @param {Strong} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function strong(node: Strong, state: State): string;
/**
 * Handle GFM table.
 *
 * @satisfies {Handle}
 * @param {Table} node
 *   Node.
 * @param {State} state
 *   Info passed around.
 * @returns {string}
 *   Roff.
 */
declare function table(node: Table, state: State): string;
/**
 * Handle text.
 *
 * @satisfies {Handle}
 * @param {Text} node
 *   Node.
 * @returns {string}
 *   Roff.
 */
declare function text(node: Text): string;
/**
 * Handle thematic break.
 *
 * @satisfies {Handle}
 * @returns {string}
 *   Roff.
 */
declare function thematicBreak(): string;
export {};
