/**
 * src/classes/sys-users.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * "THE SYSUSER MASTER"
 * Gestione pura Node.js per utenti e gruppi di sistema.
 * Sostituisce i binari (useradd/usermod/deluser) per garantire operazioni atomiche
 * e compatibilità SELinux (Fedora/RHEL) scrivendo file puliti.
 */
export interface IPasswdEntry {
    gecos: string;
    gid: string;
    home: string;
    password: string;
    shell: string;
    uid: string;
    username: string;
}
export interface IShadowEntry {
    expire: string;
    hash: string;
    inactive: string;
    lastChange: string;
    max: string;
    min: string;
    username: string;
    warn: string;
}
export interface IGroupEntry {
    gid: string;
    groupName: string;
    members: string[];
    password: string;
}
export default class SysUsers {
    private distroFamily;
    private group;
    private gshadowLines;
    private passwd;
    private shadow;
    private subgidLines;
    private subuidLines;
    private targetRoot;
    constructor(targetRoot: string, distroFamily: string);
    /**
     * Crea un nuovo utente completo
     */
    addUser(user: IPasswdEntry, cleanPassword: string): void;
    /**
     * Aggiunge utente a un gruppo supplementare
     */
    addUserToGroup(username: string, groupName: string): void;
    /**
     * Carica tutti i file di configurazione in memoria
     */
    load(): void;
    /**
     * Verifica l'esistenza di un gruppo
     */
    groupExists(groupName: string): boolean;
    /**
     * Rimuove completamente un utente
     */
    removeUser(username: string): void;
    /**
     * Salva lo stato della memoria su disco e applica SELinux fix
     */
    save(): Promise<void>;
    /**
     * Cambia password utente
     */
    setPassword(username: string, password: string): void;
    private parseGroup;
    private parsePasswd;
    private parseShadow;
    private readFile;
    private serializeGroup;
    private serializePasswd;
    private serializeShadow;
    private writeFile;
}
