# (c) Copyright 2009, 2014. CodeWeavers, Inc.
# -*- coding: utf-8 -*-

CX_VERSION = "22.1.1.35679"
PUBLIC_VERSION = "22.1.1"
DATE = "2023/04/02"
DEMO_EXTREP = "0"
DEMO_SKU = "crosslin"
DEMO_URL = "https://www.codeweavers.com/store/checkout/?cart=add;sku%5Bsku%5D=crosslin-pro;sku%5Bqty%5D=1"
DEMO_URL_VISIBLE = "store.codeweavers.com"
HAS_GAMES = 1
HAS_MULTI_USER = 1
HAS_OFFICE = 1
IS_MACOSX = 0
PLATFORM = "Linux"
BUILTIN_PRODUCT_ID = "cxoffice"
PRODUCT_NAME = "CrossOver"
REPORT_USAGE_URL = "http://www.codeweavers.com/bin/usage_collect"
PRODUCT_COPYRIGHT = "2004-2022, CodeWeavers, Inc."

def get_user_languages():
    """Returns the user's preferred languages based on $LANGUAGE or his
    locale.
    """
    # Probe $LANGUAGE manually because getdefaultlocale() would only return
    # the first locale it contains. Normally $LANGUAGE only specifies the
    # language, not a full locale. But that should not be an issue for the
    # remainder of this function.
    import os
    locales = os.environ.get('LANGUAGE', '')
    import locale
    if locales == '':
        locales, _encoding = locale.getdefaultlocale()
        if locales is None:
            locales = ''

    languages = []
    for loc in locales.split(':'):
        # The user may have set LANG='french' which we would be unable to deal
        # with. So ensure it gets normalized to something like 'fr_FR'. But we
        # must also make sure something like 'fr' does not get converted to
        # 'fr_FR'.
        normalized = locale.normalize(loc)
        if not normalized.startswith(loc + '_'):
            loc = normalized
        # Remove the encoding and modifier that we are not interested in
        loc = loc.split('.')[0].split('@')[0]

        if loc in ('C', ''):
            # These two are synonymous with English
            languages.append('en')
        elif loc == 'pt_PT':
            # This is synonymous with pt which is what we normally use
            languages.append('pt')
        elif '-' in loc:
            # In theory getdefaultlocale() may return a locale where the part
            # before the underscore already follows RFC 1766. So if that's the
            # case pass it through unmolested.
            languages.append(loc.split('_')[0])
        else:
            # This is the most common case. We transform a locale of the
            # form 'fr_FR' into what we hope will be a valid language
            # identifier like 'fr-FR'.
            languages.append(loc.replace('_', '-'))
    return languages


class CXMacObject:
    pass
