/*
 This file is part of GNU Taler
 (C) 2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { InternationalizedString } from "./types-taler-common.js";
import { AccountRestriction } from "./types-taler-exchange.js";

export function checkAccountRestriction(
  paytoUri: string,
  restrictions: AccountRestriction[],
): { ok: boolean; hint?: string; hintI18n?: InternationalizedString } {
  for (const myRestriction of restrictions) {
    switch (myRestriction.type) {
      case "deny":
        return { ok: false };
      case "regex": {
        const regex = new RegExp(myRestriction.payto_regex);
        if (!regex.test(paytoUri)) {
          return {
            ok: false,
            hint: myRestriction.human_hint,
            hintI18n: myRestriction.human_hint_i18n,
          };
        }
      }
    }
  }
  return {
    ok: true,
  };
}
