; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt %s -S -msan-check-access-address=0 -passes=msan 2>&1 | FileCheck %s
; RUN: opt %s -S -msan-check-access-address=0 -msan-track-origins=2 -passes=msan 2>&1 | FileCheck %s --check-prefixes=CHECK,ORIGIN

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define <4 x i64> @test_mm256_abs_epi8(<4 x i64> %a) local_unnamed_addr #0 {
; ORIGIN-LABEL: @test_mm256_abs_epi8(
; ORIGIN-NEXT:  entry:
; ORIGIN-NEXT:    [[TMP0:%.*]] = load <4 x i64>, ptr @__msan_param_tls, align 8
; ORIGIN-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_origin_tls, align 4
; ORIGIN-NEXT:    call void @llvm.donothing()
; ORIGIN-NEXT:    [[TMP2:%.*]] = bitcast <4 x i64> [[TMP0]] to <32 x i8>
; ORIGIN-NEXT:    [[TMP3:%.*]] = bitcast <4 x i64> [[A:%.*]] to <32 x i8>
; ORIGIN-NEXT:    [[TMP4:%.*]] = icmp eq <32 x i8> [[TMP3]], splat (i8 -128)
; ORIGIN-NEXT:    [[TMP5:%.*]] = select <32 x i1> [[TMP4]], <32 x i8> splat (i8 -1), <32 x i8> [[TMP2]]
; ORIGIN-NEXT:    [[TMP6:%.*]] = select i1 false, <32 x i8> [[TMP5]], <32 x i8> [[TMP2]]
; ORIGIN-NEXT:    [[TMP7:%.*]] = tail call <32 x i8> @llvm.abs.v32i8(<32 x i8> [[TMP3]], i1 false)
; ORIGIN-NEXT:    [[TMP8:%.*]] = bitcast <32 x i8> [[TMP6]] to <4 x i64>
; ORIGIN-NEXT:    [[TMP9:%.*]] = bitcast <32 x i8> [[TMP7]] to <4 x i64>
; ORIGIN-NEXT:    store <4 x i64> [[TMP8]], ptr @__msan_retval_tls, align 8
; ORIGIN-NEXT:    store i32 [[TMP1]], ptr @__msan_retval_origin_tls, align 4
; ORIGIN-NEXT:    ret <4 x i64> [[TMP9]]
;
entry:
  %0 = bitcast <4 x i64> %a to <32 x i8>
  %1 = tail call <32 x i8> @llvm.abs.v32i8(<32 x i8> %0, i1 false)
  %2 = bitcast <32 x i8> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_abs_epi16(<4 x i64> %a) local_unnamed_addr #0 {
; ORIGIN-LABEL: @test_mm256_abs_epi16(
; ORIGIN-NEXT:  entry:
; ORIGIN-NEXT:    [[TMP0:%.*]] = load <4 x i64>, ptr @__msan_param_tls, align 8
; ORIGIN-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_origin_tls, align 4
; ORIGIN-NEXT:    call void @llvm.donothing()
; ORIGIN-NEXT:    [[TMP2:%.*]] = bitcast <4 x i64> [[TMP0]] to <16 x i16>
; ORIGIN-NEXT:    [[TMP3:%.*]] = bitcast <4 x i64> [[A:%.*]] to <16 x i16>
; ORIGIN-NEXT:    [[TMP4:%.*]] = icmp eq <16 x i16> [[TMP3]], splat (i16 -32768)
; ORIGIN-NEXT:    [[TMP5:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> splat (i16 -1), <16 x i16> [[TMP2]]
; ORIGIN-NEXT:    [[TMP6:%.*]] = select i1 false, <16 x i16> [[TMP5]], <16 x i16> [[TMP2]]
; ORIGIN-NEXT:    [[TMP7:%.*]] = tail call <16 x i16> @llvm.abs.v16i16(<16 x i16> [[TMP3]], i1 false)
; ORIGIN-NEXT:    [[TMP8:%.*]] = bitcast <16 x i16> [[TMP6]] to <4 x i64>
; ORIGIN-NEXT:    [[TMP9:%.*]] = bitcast <16 x i16> [[TMP7]] to <4 x i64>
; ORIGIN-NEXT:    store <4 x i64> [[TMP8]], ptr @__msan_retval_tls, align 8
; ORIGIN-NEXT:    store i32 [[TMP1]], ptr @__msan_retval_origin_tls, align 4
; ORIGIN-NEXT:    ret <4 x i64> [[TMP9]]
;
entry:
  %0 = bitcast <4 x i64> %a to <16 x i16>
  %1 = tail call <16 x i16> @llvm.abs.v16i16(<16 x i16> %0, i1 false)
  %2 = bitcast <16 x i16> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_abs_epi32(<4 x i64> %a) local_unnamed_addr #0 {
; ORIGIN-LABEL: @test_mm256_abs_epi32(
; ORIGIN-NEXT:  entry:
; ORIGIN-NEXT:    [[TMP0:%.*]] = load <4 x i64>, ptr @__msan_param_tls, align 8
; ORIGIN-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_origin_tls, align 4
; ORIGIN-NEXT:    call void @llvm.donothing()
; ORIGIN-NEXT:    [[TMP2:%.*]] = bitcast <4 x i64> [[TMP0]] to <8 x i32>
; ORIGIN-NEXT:    [[TMP3:%.*]] = bitcast <4 x i64> [[A:%.*]] to <8 x i32>
; ORIGIN-NEXT:    [[TMP4:%.*]] = icmp eq <8 x i32> [[TMP3]], splat (i32 -2147483648)
; ORIGIN-NEXT:    [[TMP5:%.*]] = select <8 x i1> [[TMP4]], <8 x i32> splat (i32 -1), <8 x i32> [[TMP2]]
; ORIGIN-NEXT:    [[TMP6:%.*]] = select i1 false, <8 x i32> [[TMP5]], <8 x i32> [[TMP2]]
; ORIGIN-NEXT:    [[TMP7:%.*]] = tail call <8 x i32> @llvm.abs.v8i32(<8 x i32> [[TMP3]], i1 false)
; ORIGIN-NEXT:    [[TMP8:%.*]] = bitcast <8 x i32> [[TMP6]] to <4 x i64>
; ORIGIN-NEXT:    [[TMP9:%.*]] = bitcast <8 x i32> [[TMP7]] to <4 x i64>
; ORIGIN-NEXT:    store <4 x i64> [[TMP8]], ptr @__msan_retval_tls, align 8
; ORIGIN-NEXT:    store i32 [[TMP1]], ptr @__msan_retval_origin_tls, align 4
; ORIGIN-NEXT:    ret <4 x i64> [[TMP9]]
;
entry:
  %0 = bitcast <4 x i64> %a to <8 x i32>
  %1 = tail call <8 x i32> @llvm.abs.v8i32(<8 x i32> %0, i1 false)
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <4 x double> @test_fabs(<4 x double> %a) local_unnamed_addr #0 {
; CHECK-LABEL: @test_fabs(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i64>, ptr @__msan_param_tls, align 8
; ORIGIN-NEXT:   [[TMP1:%.*]] = load i32, ptr @__msan_param_origin_tls, align 4
; CHECK:         call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = tail call <4 x double> @llvm.fabs.v4f64(<4 x double> [[A:%.*]])
; CHECK-NEXT:    store <4 x i64> [[TMP0]], ptr @__msan_retval_tls, align 8
; ORIGIN-NEXT:   store i32 [[TMP1]], ptr @__msan_retval_origin_tls, align 4
; CHECK:         ret <4 x double> [[TMP2]]
;
entry:
  %0 = tail call <4 x double> @llvm.fabs.v4f64(<4 x double> %a)
  ret <4 x double> %0
}

declare <32 x i8> @llvm.abs.v32i8(<32 x i8>, i1 immarg) #1
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1 immarg) #1
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1 immarg) #1
declare <4 x double> @llvm.fabs.v4f64(<4 x double>) #1

attributes #0 = { nounwind readnone sanitize_memory }
attributes #1 = { nounwind readnone speculatable willreturn }

!llvm.module.flags = !{!0}
!llvm.ident = !{!1}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{!"clang version 12.0.0"}
