; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,VEX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,VEX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX,AVX512,AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VLDQ
;
; 32-bit tests to make sure we're not doing anything stupid.
; RUN: llc < %s -mtriple=i686-unknown-unknown
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2

;
; Double to Signed Integer
;

define <2 x i64> @fptosi_2f64_to_2i64(<2 x double> %a) {
; SSE-LABEL: fptosi_2f64_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f64_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttsd2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm1
; VEX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; VEX-NEXT:    vcvttsd2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_2f64_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_2f64_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_2f64_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_2f64_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2qq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <2 x double> %a to <2 x i64>
  ret <2 x i64> %cvt
}

define <4 x i32> @fptosi_2f64_to_4i32(<2 x double> %a) {
; SSE-LABEL: fptosi_2f64_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f64_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <2 x double> %a to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %ext
}

define <2 x i32> @fptosi_2f64_to_2i32(<2 x double> %a) {
; SSE-LABEL: fptosi_2f64_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f64_to_2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <2 x double> %a to <2 x i32>
  ret <2 x i32> %cvt
}

define <4 x i32> @fptosi_4f64_to_2i32(<2 x double> %a) {
; SSE-LABEL: fptosi_4f64_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_4f64_to_2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %ext = shufflevector <2 x double> %a, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %cvt = fptosi <4 x double> %ext to <4 x i32>
  ret <4 x i32> %cvt
}

define <4 x i64> @fptosi_4f64_to_4i64(<4 x double> %a) {
; SSE-LABEL: fptosi_4f64_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    cvttsd2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1,1]
; SSE-NEXT:    cvttsd2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptosi_4f64_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vcvttsd2si %xmm1, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX1-NEXT:    vcvttsd2si %xmm1, %rax
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-NEXT:    vcvttsd2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvttsd2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptosi_4f64_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptosi_4f64_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512F-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_4f64_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_4f64_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_4f64_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2qq %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <4 x double> %a to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i32> @fptosi_4f64_to_4i32(<4 x double> %a) {
; SSE-LABEL: fptosi_4f64_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm1, %xmm1
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_4f64_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %cvt = fptosi <4 x double> %a to <4 x i32>
  ret <4 x i32> %cvt
}

;
; Double to Unsigned Integer
;

define <2 x i64> @fptoui_2f64_to_2i64(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm2 = [9.2233720368547758E+18,0.0E+0]
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    subsd %xmm2, %xmm1
; SSE-NEXT:    cvttsd2si %xmm1, %rax
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    subsd %xmm2, %xmm0
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; VEX-NEXT:    vsubsd %xmm1, %xmm0, %xmm2
; VEX-NEXT:    vcvttsd2si %xmm2, %rax
; VEX-NEXT:    vcvttsd2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm2
; VEX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; VEX-NEXT:    vsubsd %xmm1, %xmm0, %xmm1
; VEX-NEXT:    vcvttsd2si %xmm1, %rax
; VEX-NEXT:    vcvttsd2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f64_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f64_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f64_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f64_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2uqq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x double> %a to <2 x i64>
  ret <2 x i64> %cvt
}

define <4 x i32> @fptoui_2f64_to_4i32(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_4i32:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm1
; VEX-NEXT:    vpsrad $31, %xmm1, %xmm2
; VEX-NEXT:    vaddpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VEX-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; VEX-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f64_to_4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f64_to_4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f64_to_4i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f64_to_4i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x double> %a to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %ext
}

define <4 x i32> @fptoui_2f64_to_2i32(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_2i32:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm1
; VEX-NEXT:    vpsrad $31, %xmm1, %xmm2
; VEX-NEXT:    vaddpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VEX-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; VEX-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f64_to_2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f64_to_2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f64_to_2i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f64_to_2i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x double> %a to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  ret <4 x i32> %ext
}

define <4 x i32> @fptoui_4f64_to_2i32(<2 x double> %a) {
; SSE-LABEL: fptoui_4f64_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_4f64_to_2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovapd %xmm0, %xmm0
; AVX1-NEXT:    vcvttpd2dq %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX1-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_4f64_to_2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovapd %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [2.147483648E+9,2.147483648E+9,2.147483648E+9,2.147483648E+9]
; AVX2-NEXT:    vsubpd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vcvttpd2dq %ymm1, %xmm1
; AVX2-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vandpd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vorpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f64_to_2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps %xmm0, %xmm0
; AVX512F-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f64_to_2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps %xmm0, %xmm0
; AVX512VL-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f64_to_2i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %xmm0, %xmm0
; AVX512DQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f64_to_2i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vmovaps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %ext = shufflevector <2 x double> %a, <2 x double> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = fptoui <4 x double> %ext to <4 x i32>
  ret <4 x i32> %cvt
}

define <4 x i64> @fptoui_4f64_to_4i64(<4 x double> %a) {
; SSE-LABEL: fptoui_4f64_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd %xmm0, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm3 = [9.2233720368547758E+18,0.0E+0]
; SSE-NEXT:    subsd %xmm3, %xmm0
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    cvttsd2si %xmm2, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1,1]
; SSE-NEXT:    cvttsd2si %xmm2, %rax
; SSE-NEXT:    subsd %xmm3, %xmm2
; SSE-NEXT:    cvttsd2si %xmm2, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    subsd %xmm3, %xmm2
; SSE-NEXT:    cvttsd2si %xmm2, %rax
; SSE-NEXT:    cvttsd2si %xmm1, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1,1]
; SSE-NEXT:    cvttsd2si %xmm1, %rax
; SSE-NEXT:    subsd %xmm3, %xmm1
; SSE-NEXT:    cvttsd2si %xmm1, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_4f64_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; AVX1-NEXT:    vsubsd %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vcvttsd2si %xmm3, %rax
; AVX1-NEXT:    vcvttsd2si %xmm2, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX1-NEXT:    vsubsd %xmm1, %xmm2, %xmm4
; AVX1-NEXT:    vcvttsd2si %xmm4, %rax
; AVX1-NEXT:    vcvttsd2si %xmm2, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm2
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vsubsd %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vcvttsd2si %xmm3, %rax
; AVX1-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vsubsd %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcvttsd2si %xmm1, %rax
; AVX1-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_4f64_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttsd2si %xmm3, %rax
; AVX2-NEXT:    vcvttsd2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm2, %xmm4
; AVX2-NEXT:    vcvttsd2si %xmm4, %rax
; AVX2-NEXT:    vcvttsd2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vcvttsd2si %xmm3, %rax
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm1, %rax
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f64_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512F-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f64_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f64_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f64_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2uqq %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <4 x double> %a to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i32> @fptoui_4f64_to_4i32(<4 x double> %a) {
; SSE-LABEL: fptoui_4f64_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd {{.*#+}} xmm2 = [2.147483648E+9,2.147483648E+9]
; SSE-NEXT:    cvttpd2dq %xmm1, %xmm3
; SSE-NEXT:    subpd %xmm2, %xmm1
; SSE-NEXT:    cvttpd2dq %xmm1, %xmm1
; SSE-NEXT:    movapd %xmm3, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    subpd %xmm2, %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_4f64_to_4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttpd2dq %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX1-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_4f64_to_4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [2.147483648E+9,2.147483648E+9,2.147483648E+9,2.147483648E+9]
; AVX2-NEXT:    vsubpd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vcvttpd2dq %ymm1, %xmm1
; AVX2-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vandpd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vorpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f64_to_4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f64_to_4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f64_to_4i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f64_to_4i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <4 x double> %a to <4 x i32>
  ret <4 x i32> %cvt
}

;
; Float to Signed Integer
;

define <2 x i32> @fptosi_2f32_to_2i32(<2 x float> %a) {
; SSE-LABEL: fptosi_2f32_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f32_to_2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <2 x float> %a to <2 x i32>
  ret <2 x i32> %cvt
}

define <4 x i32> @fptosi_4f32_to_4i32(<4 x float> %a) {
; SSE-LABEL: fptosi_4f32_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_4f32_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <4 x float> %a to <4 x i32>
  ret <4 x i32> %cvt
}

define <2 x i64> @fptosi_2f32_to_2i64(<4 x float> %a) {
; SSE-LABEL: fptosi_2f32_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f32_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttss2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm1
; VEX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; VEX-NEXT:    vcvttss2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_2f32_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_2f32_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_2f32_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_2f32_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2qq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %shuf = shufflevector <4 x float> %a, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %cvt = fptosi <2 x float> %shuf to <2 x i64>
  ret <2 x i64> %cvt
}

define <2 x i64> @fptosi_4f32_to_2i64(<4 x float> %a) {
; SSE-LABEL: fptosi_4f32_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_4f32_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; VEX-NEXT:    vcvttss2si %xmm1, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    vmovq %rcx, %xmm0
; VEX-NEXT:    vmovq %rax, %xmm1
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_4f32_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm1, %rax
; AVX512F-NEXT:    vcvttss2si %xmm0, %rcx
; AVX512F-NEXT:    vmovq %rcx, %xmm0
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_4f32_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rcx
; AVX512VL-NEXT:    vmovq %rcx, %xmm0
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_4f32_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_4f32_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512VLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <4 x float> %a to <4 x i64>
  %shuf = shufflevector <4 x i64> %cvt, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x i64> %shuf
}

define <8 x i32> @fptosi_8f32_to_8i32(<8 x float> %a) {
; SSE-LABEL: fptosi_8f32_to_8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    cvttps2dq %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_8f32_to_8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    retq
  %cvt = fptosi <8 x float> %a to <8 x i32>
  ret <8 x i32> %cvt
}

define <4 x i64> @fptosi_4f32_to_4i64(<8 x float> %a) {
; SSE-LABEL: fptosi_4f32_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptosi_4f32_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX1-NEXT:    vcvttss2si %xmm1, %rax
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX1-NEXT:    vcvttss2si %xmm2, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-NEXT:    vcvttss2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvttss2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptosi_4f32_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptosi_4f32_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512F-NEXT:    vcvttss2si %xmm2, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_4f32_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttss2si %xmm2, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_4f32_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_4f32_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %shuf = shufflevector <8 x float> %a, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = fptosi <4 x float> %shuf to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i64> @fptosi_8f32_to_4i64(<8 x float> %a) {
; SSE-LABEL: fptosi_8f32_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptosi_8f32_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX1-NEXT:    vcvttss2si %xmm1, %rax
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX1-NEXT:    vcvttss2si %xmm2, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-NEXT:    vcvttss2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvttss2si %xmm0, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptosi_8f32_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptosi_8f32_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm1, %rax
; AVX512F-NEXT:    vcvttss2si %xmm0, %rcx
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvttss2si %xmm1, %rdx
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm0, %rsi
; AVX512F-NEXT:    vmovq %rsi, %xmm0
; AVX512F-NEXT:    vmovq %rdx, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vmovq %rcx, %xmm1
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_8f32_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rcx
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttss2si %xmm1, %rdx
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rsi
; AVX512VL-NEXT:    vmovq %rsi, %xmm0
; AVX512VL-NEXT:    vmovq %rdx, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vmovq %rcx, %xmm1
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_8f32_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_8f32_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512VLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <8 x float> %a to <8 x i64>
  %shuf = shufflevector <8 x i64> %cvt, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %shuf
}

;
; Float to Unsigned Integer
;

define <2 x i32> @fptoui_2f32_to_2i32(<2 x float> %a) {
; SSE-LABEL: fptoui_2f32_to_2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_2f32_to_2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttps2dq %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vsubps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_2f32_to_2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f32_to_2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f32_to_2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f32_to_2i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f32_to_2i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x float> %a to <2 x i32>
  ret <2 x i32> %cvt
}

define <4 x i32> @fptoui_4f32_to_4i32(<4 x float> %a) {
; SSE-LABEL: fptoui_4f32_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_4f32_to_4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttps2dq %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vsubps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_4f32_to_4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f32_to_4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f32_to_4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f32_to_4i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f32_to_4i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <4 x float> %a to <4 x i32>
  ret <4 x i32> %cvt
}

define <2 x i64> @fptoui_2f32_to_2i64(<4 x float> %a) {
; SSE-LABEL: fptoui_2f32_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    subss %xmm2, %xmm1
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f32_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; VEX-NEXT:    vsubss %xmm1, %xmm0, %xmm2
; VEX-NEXT:    vcvttss2si %xmm2, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm2
; VEX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; VEX-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; VEX-NEXT:    vcvttss2si %xmm1, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f32_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f32_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f32_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f32_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2uqq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %shuf = shufflevector <4 x float> %a, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  %cvt = fptoui <2 x float> %shuf to <2 x i64>
  ret <2 x i64> %cvt
}

define <2 x i64> @fptoui_4f32_to_2i64(<4 x float> %a) {
; SSE-LABEL: fptoui_4f32_to_2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    subss %xmm2, %xmm1
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_4f32_to_2i64:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; VEX-NEXT:    vmovss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; VEX-NEXT:    vsubss %xmm2, %xmm1, %xmm3
; VEX-NEXT:    vcvttss2si %xmm3, %rax
; VEX-NEXT:    vcvttss2si %xmm1, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vsubss %xmm2, %xmm0, %xmm1
; VEX-NEXT:    vcvttss2si %xmm1, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rsi
; VEX-NEXT:    sarq $63, %rsi
; VEX-NEXT:    andq %rax, %rsi
; VEX-NEXT:    orq %rcx, %rsi
; VEX-NEXT:    vmovq %rsi, %xmm0
; VEX-NEXT:    vmovq %rdx, %xmm1
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f32_to_2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rcx
; AVX512F-NEXT:    vmovq %rcx, %xmm0
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f32_to_2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rcx
; AVX512VL-NEXT:    vmovq %rcx, %xmm0
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f32_to_2i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f32_to_2i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512VLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <4 x float> %a to <4 x i64>
  %shuf = shufflevector <4 x i64> %cvt, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x i64> %shuf
}

define <8 x i32> @fptoui_8f32_to_8i32(<8 x float> %a) {
; SSE-LABEL: fptoui_8f32_to_8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm3
; SSE-NEXT:    subps %xmm2, %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    cvttps2dq %xmm1, %xmm3
; SSE-NEXT:    subps %xmm2, %xmm1
; SSE-NEXT:    cvttps2dq %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_8f32_to_8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttps2dq %ymm0, %ymm1
; AVX1-NEXT:    vsubps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vblendvps %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_8f32_to_8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_8f32_to_8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_8f32_to_8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_8f32_to_8i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_8f32_to_8i32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <8 x float> %a to <8 x i32>
  ret <8 x i32> %cvt
}

define <4 x i64> @fptoui_4f32_to_4i64(<8 x float> %a) {
; SSE-LABEL: fptoui_4f32_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    subss %xmm1, %xmm2
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm1, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm1, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_4f32_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX1-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX1-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vcvttss2si %xmm3, %rax
; AVX1-NEXT:    vcvttss2si %xmm2, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm2
; AVX1-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX1-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vcvttss2si %xmm4, %rax
; AVX1-NEXT:    vcvttss2si %xmm3, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vsubss %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vcvttss2si %xmm3, %rax
; AVX1-NEXT:    vcvttss2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcvttss2si %xmm1, %rax
; AVX1-NEXT:    vcvttss2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_4f32_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX2-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    vcvttss2si %xmm3, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_4f32_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512F-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_4f32_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_4f32_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_4f32_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %shuf = shufflevector <8 x float> %a, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = fptoui <4 x float> %shuf to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i64> @fptoui_8f32_to_4i64(<8 x float> %a) {
; SSE-LABEL: fptoui_8f32_to_4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    subss %xmm1, %xmm2
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm1, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm1, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_8f32_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX1-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX1-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vcvttss2si %xmm3, %rax
; AVX1-NEXT:    vcvttss2si %xmm2, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm2
; AVX1-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX1-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vcvttss2si %xmm4, %rax
; AVX1-NEXT:    vcvttss2si %xmm3, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vsubss %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vcvttss2si %xmm3, %rax
; AVX1-NEXT:    vcvttss2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm3
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcvttss2si %xmm1, %rax
; AVX1-NEXT:    vcvttss2si %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %rdx
; AVX1-NEXT:    sarq $63, %rdx
; AVX1-NEXT:    andq %rax, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_8f32_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX2-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    vcvttss2si %xmm3, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fptoui_8f32_to_4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rcx
; AVX512F-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvttss2usi %xmm1, %rdx
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rsi
; AVX512F-NEXT:    vmovq %rsi, %xmm0
; AVX512F-NEXT:    vmovq %rdx, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vmovq %rcx, %xmm1
; AVX512F-NEXT:    vmovq %rax, %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_8f32_to_4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rcx
; AVX512VL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvttss2usi %xmm1, %rdx
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rsi
; AVX512VL-NEXT:    vmovq %rsi, %xmm0
; AVX512VL-NEXT:    vmovq %rdx, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vmovq %rcx, %xmm1
; AVX512VL-NEXT:    vmovq %rax, %xmm2
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_8f32_to_4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_8f32_to_4i64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512VLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <8 x float> %a to <8 x i64>
  %shuf = shufflevector <8 x i64> %cvt, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %shuf
}

;
; Constant Folding
;

define <2 x i64> @fptosi_2f64_to_2i64_const() {
; SSE-LABEL: fptosi_2f64_to_2i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,18446744073709551615]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f64_to_2i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [1,18446744073709551615]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_2f64_to_2i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} xmm0 = [1,18446744073709551615]
; AVX512-NEXT:    retq
  %cvt = fptosi <2 x double> <double 1.0, double -1.0> to <2 x i64>
  ret <2 x i64> %cvt
}

define <4 x i32> @fptosi_2f64_to_2i32_const() {
; SSE-LABEL: fptosi_2f64_to_2i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = [4294967295,1,0,0]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f64_to_2i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovsd {{.*#+}} xmm0 = [4294967295,1,0,0]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_2f64_to_2i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [4294967295,1,0,0]
; AVX512-NEXT:    retq
  %cvt = fptosi <2 x double> <double -1.0, double 1.0> to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  ret <4 x i32> %ext
}

define <4 x i64> @fptosi_4f64_to_4i64_const() {
; SSE-LABEL: fptosi_4f64_to_4i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,18446744073709551615]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [2,18446744073709551613]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_4f64_to_4i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [1,18446744073709551615,2,18446744073709551613]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_4f64_to_4i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,18446744073709551615,2,18446744073709551613]
; AVX512-NEXT:    retq
  %cvt = fptosi <4 x double> <double 1.0, double -1.0, double 2.0, double -3.0> to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i32> @fptosi_4f64_to_4i32_const() {
; SSE-LABEL: fptosi_4f64_to_4i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [4294967295,1,4294967294,3]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_4f64_to_4i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [4294967295,1,4294967294,3]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_4f64_to_4i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [4294967295,1,4294967294,3]
; AVX512-NEXT:    retq
  %cvt = fptosi <4 x double> <double -1.0, double 1.0, double -2.0, double 3.0> to <4 x i32>
  ret <4 x i32> %cvt
}

define <2 x i64> @fptoui_2f64_to_2i64_const() {
; SSE-LABEL: fptoui_2f64_to_2i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [2,4]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_2i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [2,4]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_2f64_to_2i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} xmm0 = [2,4]
; AVX512-NEXT:    retq
  %cvt = fptoui <2 x double> <double 2.0, double 4.0> to <2 x i64>
  ret <2 x i64> %cvt
}

define <4 x i32> @fptoui_2f64_to_2i32_const(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_2i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = [2,4,0,0]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_2i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovsd {{.*#+}} xmm0 = [2,4,0,0]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_2f64_to_2i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [2,4,0,0]
; AVX512-NEXT:    retq
  %cvt = fptoui <2 x double> <double 2.0, double 4.0> to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  ret <4 x i32> %ext
}

define <4 x i64> @fptoui_4f64_to_4i64_const(<4 x double> %a) {
; SSE-LABEL: fptoui_4f64_to_4i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [2,4]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [6,8]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_4f64_to_4i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [2,4,6,8]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_4f64_to_4i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [2,4,6,8]
; AVX512-NEXT:    retq
  %cvt = fptoui <4 x double> <double 2.0, double 4.0, double 6.0, double 8.0> to <4 x i64>
  ret <4 x i64> %cvt
}

define <4 x i32> @fptoui_4f64_to_4i32_const(<4 x double> %a) {
; SSE-LABEL: fptoui_4f64_to_4i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [2,4,6,8]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_4f64_to_4i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [2,4,6,8]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_4f64_to_4i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [2,4,6,8]
; AVX512-NEXT:    retq
  %cvt = fptoui <4 x double> <double 2.0, double 4.0, double 6.0, double 8.0> to <4 x i32>
  ret <4 x i32> %cvt
}

define <4 x i32> @fptosi_4f32_to_4i32_const() {
; SSE-LABEL: fptosi_4f32_to_4i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,4294967295,2,3]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_4f32_to_4i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [1,4294967295,2,3]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_4f32_to_4i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [1,4294967295,2,3]
; AVX512-NEXT:    retq
  %cvt = fptosi <4 x float> <float 1.0, float -1.0, float 2.0, float 3.0> to <4 x i32>
  ret <4 x i32> %cvt
}

define <4 x i64> @fptosi_4f32_to_4i64_const() {
; SSE-LABEL: fptosi_4f32_to_4i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,18446744073709551615]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [2,3]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_4f32_to_4i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [1,18446744073709551615,2,3]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_4f32_to_4i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,18446744073709551615,2,3]
; AVX512-NEXT:    retq
  %cvt = fptosi <4 x float> <float 1.0, float -1.0, float 2.0, float 3.0> to <4 x i64>
  ret <4 x i64> %cvt
}

define <8 x i32> @fptosi_8f32_to_8i32_const(<8 x float> %a) {
; SSE-LABEL: fptosi_8f32_to_8i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,4294967295,2,3]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [6,4294967288,2,4294967295]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_8f32_to_8i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [1,4294967295,2,3,6,4294967288,2,4294967295]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptosi_8f32_to_8i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [1,4294967295,2,3,6,4294967288,2,4294967295]
; AVX512-NEXT:    retq
  %cvt = fptosi <8 x float> <float 1.0, float -1.0, float 2.0, float 3.0, float 6.0, float -8.0, float 2.0, float -1.0> to <8 x i32>
  ret <8 x i32> %cvt
}

define <4 x i32> @fptoui_4f32_to_4i32_const(<4 x float> %a) {
; SSE-LABEL: fptoui_4f32_to_4i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,2,4,6]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_4f32_to_4i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} xmm0 = [1,2,4,6]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_4f32_to_4i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm0 = [1,2,4,6]
; AVX512-NEXT:    retq
  %cvt = fptoui <4 x float> <float 1.0, float 2.0, float 4.0, float 6.0> to <4 x i32>
  ret <4 x i32> %cvt
}

define <4 x i64> @fptoui_4f32_to_4i64_const() {
; SSE-LABEL: fptoui_4f32_to_4i64_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,2]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [4,8]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_4f32_to_4i64_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [1,2,4,8]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_4f32_to_4i64_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,2,4,8]
; AVX512-NEXT:    retq
  %cvt = fptoui <4 x float> <float 1.0, float 2.0, float 4.0, float 8.0> to <4 x i64>
  ret <4 x i64> %cvt
}

define <8 x i32> @fptoui_8f32_to_8i32_const(<8 x float> %a) {
; SSE-LABEL: fptoui_8f32_to_8i32_const:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1,2,4,6]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [8,6,4,1]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_8f32_to_8i32_const:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovaps {{.*#+}} ymm0 = [1,2,4,6,8,6,4,1]
; VEX-NEXT:    retq
;
; AVX512-LABEL: fptoui_8f32_to_8i32_const:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm0 = [1,2,4,6,8,6,4,1]
; AVX512-NEXT:    retq
  %cvt = fptoui <8 x float> <float 1.0, float 2.0, float 4.0, float 6.0, float 8.0, float 6.0, float 4.0, float 1.0> to <8 x i32>
  ret <8 x i32> %cvt
}

define <4 x i32> @fptosi_2f80_to_4i32(<2 x x86_fp80> %a) nounwind {
; SSE-LABEL: fptosi_2f80_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE-NEXT:    fldt {{[0-9]+}}(%rsp)
; SSE-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movzwl -{{[0-9]+}}(%rsp), %eax
; SSE-NEXT:    orl $3072, %eax # imm = 0xC00
; SSE-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fistpl -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movzwl -{{[0-9]+}}(%rsp), %eax
; SSE-NEXT:    orl $3072, %eax # imm = 0xC00
; SSE-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fistpl -{{[0-9]+}}(%rsp)
; SSE-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movq {{.*#+}} xmm0 = xmm1[0],zero
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f80_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    fldt {{[0-9]+}}(%rsp)
; AVX-NEXT:    fldt {{[0-9]+}}(%rsp)
; AVX-NEXT:    fisttpl -{{[0-9]+}}(%rsp)
; AVX-NEXT:    fisttpl -{{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX-NEXT:    retq
  %cvt = fptosi <2 x x86_fp80> %a to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %ext
}

define <4 x i32> @fptosi_2f128_to_4i32(<2 x fp128> %a) nounwind {
; SSE-LABEL: fptosi_2f128_to_4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $16, %rsp
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixtfsi@PLT
; SSE-NEXT:    movl %eax, %ebx
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixtfsi@PLT
; SSE-NEXT:    movd %eax, %xmm0
; SSE-NEXT:    movd %ebx, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movq {{.*#+}} xmm0 = xmm1[0],zero
; SSE-NEXT:    addq $16, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f128_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $16, %rsp
; AVX-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX-NEXT:    callq __fixtfsi@PLT
; AVX-NEXT:    movl %eax, %ebx
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixtfsi@PLT
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    vmovd %ebx, %xmm1
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX-NEXT:    addq $16, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    retq
  %cvt = fptosi <2 x fp128> %a to <2 x i32>
  %ext = shufflevector <2 x i32> %cvt, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %ext
}

define <2 x i8> @fptosi_2f32_to_2i8(<2 x float> %a) {
; SSE-LABEL: fptosi_2f32_to_2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f32_to_2i8:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttps2dq %xmm0, %xmm0
; VEX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; VEX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_2f32_to_2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_2f32_to_2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_2f32_to_2i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_2f32_to_2i8:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <2 x float> %a to <2 x i8>
  ret <2 x i8> %cvt
}

define <2 x i16> @fptosi_2f32_to_2i16(<2 x float> %a) {
; SSE-LABEL: fptosi_2f32_to_2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f32_to_2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <2 x float> %a to <2 x i16>
  ret <2 x i16> %cvt
}

define <2 x i8> @fptoui_2f32_to_2i8(<2 x float> %a) {
; SSE-LABEL: fptoui_2f32_to_2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f32_to_2i8:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttps2dq %xmm0, %xmm0
; VEX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; VEX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f32_to_2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512F-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f32_to_2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f32_to_2i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f32_to_2i8:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x float> %a to <2 x i8>
  ret <2 x i8> %cvt
}

define <2 x i16> @fptoui_2f32_to_2i16(<2 x float> %a) {
; SSE-LABEL: fptoui_2f32_to_2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: fptoui_2f32_to_2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptoui <2 x float> %a to <2 x i16>
  ret <2 x i16> %cvt
}

define <2 x i8> @fptosi_2f64_to_2i8(<2 x double> %a) {
; SSE-LABEL: fptosi_2f64_to_2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f64_to_2i8:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VEX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; VEX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_2f64_to_2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_2f64_to_2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_2f64_to_2i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_2f64_to_2i8:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <2 x double> %a to <2 x i8>
  ret <2 x i8> %cvt
}

define <2 x i16> @fptosi_2f64_to_2i16(<2 x double> %a) {
; SSE-LABEL: fptosi_2f64_to_2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fptosi_2f64_to_2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptosi <2 x double> %a to <2 x i16>
  ret <2 x i16> %cvt
}

define <2 x i8> @fptoui_2f64_to_2i8(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f64_to_2i8:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VEX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; VEX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f64_to_2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512F-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f64_to_2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f64_to_2i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f64_to_2i8:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <2 x double> %a to <2 x i8>
  ret <2 x i8> %cvt
}

define <2 x i16> @fptoui_2f64_to_2i16(<2 x double> %a) {
; SSE-LABEL: fptoui_2f64_to_2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: fptoui_2f64_to_2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = fptoui <2 x double> %a to <2 x i16>
  ret <2 x i16> %cvt
}

define <8 x i16> @fptosi_8f64_to_8i16(<8 x double> %a) {
; SSE-LABEL: fptosi_8f64_to_8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm3, %xmm3
; SSE-NEXT:    cvttpd2dq %xmm2, %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    cvttpd2dq %xmm1, %xmm1
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_8f64_to_8i16:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %ymm1, %xmm1
; VEX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VEX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; VEX-NEXT:    vzeroupper
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_8f64_to_8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_8f64_to_8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_8f64_to_8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_8f64_to_8i16:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VLDQ-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = fptosi <8 x double> %a to <8 x i16>
  ret <8 x i16> %cvt
}

define <8 x i16> @fptoui_8f64_to_8i16(<8 x double> %a) {
; SSE-LABEL: fptoui_8f64_to_8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm3, %xmm3
; SSE-NEXT:    cvttpd2dq %xmm2, %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    cvttpd2dq %xmm1, %xmm1
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_8f64_to_8i16:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvttpd2dq %ymm1, %xmm1
; VEX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VEX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; VEX-NEXT:    vzeroupper
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_8f64_to_8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_8f64_to_8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_8f64_to_8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_8f64_to_8i16:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VLDQ-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = fptoui <8 x double> %a to <8 x i16>
  ret <8 x i16> %cvt
}

define <16 x i8> @fptosi_16f32_to_16i8(<16 x float> %a) {
; SSE-LABEL: fptosi_16f32_to_16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm3, %xmm3
; SSE-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    cvttps2dq %xmm1, %xmm1
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptosi_16f32_to_16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptosi_16f32_to_16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fptosi_16f32_to_16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = fptosi <16 x float> %a to <16 x i8>
  ret <16 x i8> %cvt
}

define <16 x i8> @fptoui_16f32_to_16i8(<16 x float> %a) {
; SSE-LABEL: fptoui_16f32_to_16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm3, %xmm3
; SSE-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    cvttps2dq %xmm1, %xmm1
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: fptoui_16f32_to_16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: fptoui_16f32_to_16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fptoui_16f32_to_16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = fptoui <16 x float> %a to <16 x i8>
  ret <16 x i8> %cvt
}

define <2 x i64> @fptosi_2f32_to_2i64_load(ptr %x) {
; SSE-LABEL: fptosi_2f32_to_2i64_load:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptosi_2f32_to_2i64_load:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; VEX-NEXT:    vcvttss2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm1
; VEX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; VEX-NEXT:    vcvttss2si %xmm0, %rax
; VEX-NEXT:    vmovq %rax, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptosi_2f32_to_2i64_load:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptosi_2f32_to_2i64_load:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptosi_2f32_to_2i64_load:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptosi_2f32_to_2i64_load:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2qq (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %a = load <2 x float>, ptr %x
  %b = fptosi <2 x float> %a to <2 x i64>
  ret <2 x i64> %b
}

define <2 x i64> @fptoui_2f32_to_2i64_load(ptr %x) {
; SSE-LABEL: fptoui_2f32_to_2i64_load:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    cvttss2si %xmm1, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    subss %xmm2, %xmm1
; SSE-NEXT:    cvttss2si %xmm1, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; VEX-LABEL: fptoui_2f32_to_2i64_load:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; VEX-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; VEX-NEXT:    vsubss %xmm1, %xmm0, %xmm2
; VEX-NEXT:    vcvttss2si %xmm2, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm2
; VEX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; VEX-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; VEX-NEXT:    vcvttss2si %xmm1, %rax
; VEX-NEXT:    vcvttss2si %xmm0, %rcx
; VEX-NEXT:    movq %rcx, %rdx
; VEX-NEXT:    sarq $63, %rdx
; VEX-NEXT:    andq %rax, %rdx
; VEX-NEXT:    orq %rcx, %rdx
; VEX-NEXT:    vmovq %rdx, %xmm0
; VEX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: fptoui_2f32_to_2i64_load:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fptoui_2f32_to_2i64_load:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: fptoui_2f32_to_2i64_load:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: fptoui_2f32_to_2i64_load:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvttps2uqq (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %a = load <2 x float>, ptr %x
  %b = fptoui <2 x float> %a to <2 x i64>
  ret <2 x i64> %b
}
