; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X86-AVX512DQVL,X86-AVX512-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X86-AVX512DQVL,X86-AVX512-LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=X86-AVX512DQ,X86-AVX512-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=X86-AVX512DQ,X86-AVX512-LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+avx512f | FileCheck %s --check-prefixes=X86-AVX512-WIN,X86-AVX512F-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+avx512f | FileCheck %s --check-prefixes=X86-AVX512-LIN,X86-AVX512F-LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+avx512f | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f | FileCheck %s --check-prefixes=X64-AVX512,X64-AVX512-LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+sse3 | FileCheck %s --check-prefixes=X86-SSE-WIN,X86-SSE3-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+sse3 | FileCheck %s --check-prefixes=X86-SSE-LIN,X86-SSE3-LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+sse3 | FileCheck %s --check-prefixes=X64-SSE,X64-SSE-WIN,X64-SSE3-WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse3 | FileCheck %s --check-prefixes=X64-SSE,X64-SSE-LIN,X64-SSE3-LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=+sse2 | FileCheck %s --check-prefixes=X86-SSE-WIN,X86-SSE2-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=+sse2 | FileCheck %s --check-prefixes=X86-SSE-LIN,X86-SSE2-LIN
; RUN: llc < %s -mtriple=x86_64-pc-windows-msvc   -mattr=+sse2 | FileCheck %s --check-prefixes=X64-SSE,X64-SSE-WIN,X64-SSE2-WIN
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse2 | FileCheck %s --check-prefixes=X64-SSE,X64-SSE-LIN,X64-SSE2-LIN
; RUN: llc < %s -mtriple=i386-pc-windows-msvc     -mattr=-sse  | FileCheck %s --check-prefix=X87-WIN
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu   -mattr=-sse  | FileCheck %s --check-prefix=X87-LIN

; Check that scalar FP conversions to signed and unsigned int64 are using
; reasonable sequences, across platforms and target switches.
;
; The signed case is straight forward, and the tests here basically
; ensure successful compilation (f80 with avx512 was broken at one point).
;
; For the unsigned case there are many possible sequences, so to avoid
; a fragile test we just check for the presence of a few key instructions.
; AVX512 on Intel64 can use vcvtts[ds]2usi directly for float and double.
; Otherwise the sequence will involve an FP subtract (fsub, subss or subsd),
; and a truncating conversion (cvtts[ds]2si, fisttp, or fnstcw+fist).  When
; both a subtract and fnstcw are needed, they can occur in either order.
;
; The interesting subtargets are AVX512F (vcvtts[ds]2usi), SSE3 (fisttp),
; SSE2 (cvtts[ds]2si) and vanilla X87 (fnstcw+fist, 32-bit only).

define i64 @f_to_u64(float %a) nounwind {
; X86-AVX512DQVL-LABEL: f_to_u64:
; X86-AVX512DQVL:       # %bb.0:
; X86-AVX512DQVL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512DQVL-NEXT:    vcvttps2uqq %xmm0, %xmm0
; X86-AVX512DQVL-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQVL-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQVL-NEXT:    retl
;
; X64-AVX512-LABEL: f_to_u64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vcvttss2usi %xmm0, %rax
; X64-AVX512-NEXT:    retq
;
; X86-AVX512DQ-LABEL: f_to_u64:
; X86-AVX512DQ:       # %bb.0:
; X86-AVX512DQ-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; X86-AVX512DQ-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQ-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQ-NEXT:    vzeroupper
; X86-AVX512DQ-NEXT:    retl
;
; X86-AVX512F-WIN-LABEL: f_to_u64:
; X86-AVX512F-WIN:       # %bb.0:
; X86-AVX512F-WIN-NEXT:    pushl %ebp
; X86-AVX512F-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512F-WIN-NEXT:    andl $-8, %esp
; X86-AVX512F-WIN-NEXT:    subl $8, %esp
; X86-AVX512F-WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512F-WIN-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-AVX512F-WIN-NEXT:    xorl %edx, %edx
; X86-AVX512F-WIN-NEXT:    vucomiss %xmm0, %xmm1
; X86-AVX512F-WIN-NEXT:    setbe %dl
; X86-AVX512F-WIN-NEXT:    kmovw %edx, %k1
; X86-AVX512F-WIN-NEXT:    vmovss %xmm1, %xmm1, %xmm1 {%k1} {z}
; X86-AVX512F-WIN-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; X86-AVX512F-WIN-NEXT:    vmovss %xmm0, (%esp)
; X86-AVX512F-WIN-NEXT:    flds (%esp)
; X86-AVX512F-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-WIN-NEXT:    shll $31, %edx
; X86-AVX512F-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512F-WIN-NEXT:    popl %ebp
; X86-AVX512F-WIN-NEXT:    retl
;
; X86-AVX512F-LIN-LABEL: f_to_u64:
; X86-AVX512F-LIN:       # %bb.0:
; X86-AVX512F-LIN-NEXT:    subl $12, %esp
; X86-AVX512F-LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512F-LIN-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-AVX512F-LIN-NEXT:    xorl %edx, %edx
; X86-AVX512F-LIN-NEXT:    vucomiss %xmm0, %xmm1
; X86-AVX512F-LIN-NEXT:    setbe %dl
; X86-AVX512F-LIN-NEXT:    kmovw %edx, %k1
; X86-AVX512F-LIN-NEXT:    vmovss %xmm1, %xmm1, %xmm1 {%k1} {z}
; X86-AVX512F-LIN-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; X86-AVX512F-LIN-NEXT:    vmovss %xmm0, (%esp)
; X86-AVX512F-LIN-NEXT:    flds (%esp)
; X86-AVX512F-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-LIN-NEXT:    shll $31, %edx
; X86-AVX512F-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-LIN-NEXT:    addl $12, %esp
; X86-AVX512F-LIN-NEXT:    retl
;
; X86-SSE3-WIN-LABEL: f_to_u64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-8, %esp
; X86-SSE3-WIN-NEXT:    subl $8, %esp
; X86-SSE3-WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE3-WIN-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-SSE3-WIN-NEXT:    ucomiss %xmm0, %xmm1
; X86-SSE3-WIN-NEXT:    jbe LBB0_2
; X86-SSE3-WIN-NEXT:  # %bb.1:
; X86-SSE3-WIN-NEXT:    xorps %xmm1, %xmm1
; X86-SSE3-WIN-NEXT:  LBB0_2:
; X86-SSE3-WIN-NEXT:    subss %xmm1, %xmm0
; X86-SSE3-WIN-NEXT:    movss %xmm0, (%esp)
; X86-SSE3-WIN-NEXT:    flds (%esp)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    setbe %al
; X86-SSE3-WIN-NEXT:    movzbl %al, %edx
; X86-SSE3-WIN-NEXT:    shll $31, %edx
; X86-SSE3-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: f_to_u64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE3-LIN-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-SSE3-LIN-NEXT:    ucomiss %xmm0, %xmm1
; X86-SSE3-LIN-NEXT:    jbe .LBB0_2
; X86-SSE3-LIN-NEXT:  # %bb.1:
; X86-SSE3-LIN-NEXT:    xorps %xmm1, %xmm1
; X86-SSE3-LIN-NEXT:  .LBB0_2:
; X86-SSE3-LIN-NEXT:    subss %xmm1, %xmm0
; X86-SSE3-LIN-NEXT:    movss %xmm0, (%esp)
; X86-SSE3-LIN-NEXT:    flds (%esp)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    setbe %al
; X86-SSE3-LIN-NEXT:    movzbl %al, %edx
; X86-SSE3-LIN-NEXT:    shll $31, %edx
; X86-SSE3-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE-WIN-LABEL: f_to_u64:
; X64-SSE-WIN:       # %bb.0:
; X64-SSE-WIN-NEXT:    cvttss2si %xmm0, %rcx
; X64-SSE-WIN-NEXT:    movq %rcx, %rdx
; X64-SSE-WIN-NEXT:    sarq $63, %rdx
; X64-SSE-WIN-NEXT:    subss __real@5f000000(%rip), %xmm0
; X64-SSE-WIN-NEXT:    cvttss2si %xmm0, %rax
; X64-SSE-WIN-NEXT:    andq %rdx, %rax
; X64-SSE-WIN-NEXT:    orq %rcx, %rax
; X64-SSE-WIN-NEXT:    retq
;
; X64-SSE-LIN-LABEL: f_to_u64:
; X64-SSE-LIN:       # %bb.0:
; X64-SSE-LIN-NEXT:    cvttss2si %xmm0, %rcx
; X64-SSE-LIN-NEXT:    movq %rcx, %rdx
; X64-SSE-LIN-NEXT:    sarq $63, %rdx
; X64-SSE-LIN-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-LIN-NEXT:    cvttss2si %xmm0, %rax
; X64-SSE-LIN-NEXT:    andq %rdx, %rax
; X64-SSE-LIN-NEXT:    orq %rcx, %rax
; X64-SSE-LIN-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: f_to_u64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-8, %esp
; X86-SSE2-WIN-NEXT:    subl $16, %esp
; X86-SSE2-WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-WIN-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-SSE2-WIN-NEXT:    ucomiss %xmm0, %xmm1
; X86-SSE2-WIN-NEXT:    jbe LBB0_2
; X86-SSE2-WIN-NEXT:  # %bb.1:
; X86-SSE2-WIN-NEXT:    xorps %xmm1, %xmm1
; X86-SSE2-WIN-NEXT:  LBB0_2:
; X86-SSE2-WIN-NEXT:    subss %xmm1, %xmm0
; X86-SSE2-WIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    setbe %al
; X86-SSE2-WIN-NEXT:    flds {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzbl %al, %edx
; X86-SSE2-WIN-NEXT:    shll $31, %edx
; X86-SSE2-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: f_to_u64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-LIN-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; X86-SSE2-LIN-NEXT:    ucomiss %xmm0, %xmm1
; X86-SSE2-LIN-NEXT:    jbe .LBB0_2
; X86-SSE2-LIN-NEXT:  # %bb.1:
; X86-SSE2-LIN-NEXT:    xorps %xmm1, %xmm1
; X86-SSE2-LIN-NEXT:  .LBB0_2:
; X86-SSE2-LIN-NEXT:    subss %xmm1, %xmm0
; X86-SSE2-LIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    setbe %al
; X86-SSE2-LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzbl %al, %edx
; X86-SSE2-LIN-NEXT:    shll $31, %edx
; X86-SSE2-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X87-WIN-LABEL: f_to_u64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-8, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    flds 8(%ebp)
; X87-WIN-NEXT:    flds __real@5f000000
; X87-WIN-NEXT:    fucom %st(1)
; X87-WIN-NEXT:    fnstsw %ax
; X87-WIN-NEXT:    xorl %edx, %edx
; X87-WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-WIN-NEXT:    sahf
; X87-WIN-NEXT:    setbe %al
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:    jbe LBB0_2
; X87-WIN-NEXT:  # %bb.1:
; X87-WIN-NEXT:    fstp %st(1)
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:  LBB0_2:
; X87-WIN-NEXT:    fstp %st(0)
; X87-WIN-NEXT:    fsubrp %st, %st(1)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-WIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movb %al, %dl
; X87-WIN-NEXT:    shll $31, %edx
; X87-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: f_to_u64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X87-LIN-NEXT:    fucom %st(1)
; X87-LIN-NEXT:    fnstsw %ax
; X87-LIN-NEXT:    xorl %edx, %edx
; X87-LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-LIN-NEXT:    sahf
; X87-LIN-NEXT:    setbe %al
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:    jbe .LBB0_2
; X87-LIN-NEXT:  # %bb.1:
; X87-LIN-NEXT:    fstp %st(1)
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:  .LBB0_2:
; X87-LIN-NEXT:    fstp %st(0)
; X87-LIN-NEXT:    fsubrp %st, %st(1)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-LIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movb %al, %dl
; X87-LIN-NEXT:    shll $31, %edx
; X87-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptoui float %a to i64
  ret i64 %r
}

define i64 @f_to_s64(float %a) nounwind {
; X86-AVX512DQVL-LABEL: f_to_s64:
; X86-AVX512DQVL:       # %bb.0:
; X86-AVX512DQVL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512DQVL-NEXT:    vcvttps2qq %xmm0, %xmm0
; X86-AVX512DQVL-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQVL-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQVL-NEXT:    retl
;
; X64-AVX512-LABEL: f_to_s64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vcvttss2si %xmm0, %rax
; X64-AVX512-NEXT:    retq
;
; X86-AVX512DQ-LABEL: f_to_s64:
; X86-AVX512DQ:       # %bb.0:
; X86-AVX512DQ-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; X86-AVX512DQ-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQ-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQ-NEXT:    vzeroupper
; X86-AVX512DQ-NEXT:    retl
;
; X86-AVX512F-WIN-LABEL: f_to_s64:
; X86-AVX512F-WIN:       # %bb.0:
; X86-AVX512F-WIN-NEXT:    pushl %ebp
; X86-AVX512F-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512F-WIN-NEXT:    andl $-8, %esp
; X86-AVX512F-WIN-NEXT:    subl $8, %esp
; X86-AVX512F-WIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512F-WIN-NEXT:    vmovss %xmm0, (%esp)
; X86-AVX512F-WIN-NEXT:    flds (%esp)
; X86-AVX512F-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512F-WIN-NEXT:    popl %ebp
; X86-AVX512F-WIN-NEXT:    retl
;
; X86-AVX512F-LIN-LABEL: f_to_s64:
; X86-AVX512F-LIN:       # %bb.0:
; X86-AVX512F-LIN-NEXT:    subl $12, %esp
; X86-AVX512F-LIN-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512F-LIN-NEXT:    vmovss %xmm0, (%esp)
; X86-AVX512F-LIN-NEXT:    flds (%esp)
; X86-AVX512F-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-LIN-NEXT:    addl $12, %esp
; X86-AVX512F-LIN-NEXT:    retl
;
; X86-SSE3-WIN-LABEL: f_to_s64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-8, %esp
; X86-SSE3-WIN-NEXT:    subl $8, %esp
; X86-SSE3-WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE3-WIN-NEXT:    movss %xmm0, (%esp)
; X86-SSE3-WIN-NEXT:    flds (%esp)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: f_to_s64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE3-LIN-NEXT:    movss %xmm0, (%esp)
; X86-SSE3-LIN-NEXT:    flds (%esp)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE-LABEL: f_to_s64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    cvttss2si %xmm0, %rax
; X64-SSE-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: f_to_s64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-8, %esp
; X86-SSE2-WIN-NEXT:    subl $16, %esp
; X86-SSE2-WIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-WIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    flds {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: f_to_s64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-LIN-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X87-WIN-LABEL: f_to_s64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-8, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    flds 8(%ebp)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: f_to_s64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    flds {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptosi float %a to i64
  ret i64 %r
}

define i64 @d_to_u64(double %a) nounwind {
; X86-AVX512DQVL-LABEL: d_to_u64:
; X86-AVX512DQVL:       # %bb.0:
; X86-AVX512DQVL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512DQVL-NEXT:    vcvttpd2uqq %xmm0, %xmm0
; X86-AVX512DQVL-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQVL-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQVL-NEXT:    retl
;
; X64-AVX512-LABEL: d_to_u64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vcvttsd2usi %xmm0, %rax
; X64-AVX512-NEXT:    retq
;
; X86-AVX512DQ-LABEL: d_to_u64:
; X86-AVX512DQ:       # %bb.0:
; X86-AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512DQ-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; X86-AVX512DQ-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQ-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQ-NEXT:    vzeroupper
; X86-AVX512DQ-NEXT:    retl
;
; X86-AVX512F-WIN-LABEL: d_to_u64:
; X86-AVX512F-WIN:       # %bb.0:
; X86-AVX512F-WIN-NEXT:    pushl %ebp
; X86-AVX512F-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512F-WIN-NEXT:    andl $-8, %esp
; X86-AVX512F-WIN-NEXT:    subl $8, %esp
; X86-AVX512F-WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512F-WIN-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-AVX512F-WIN-NEXT:    xorl %edx, %edx
; X86-AVX512F-WIN-NEXT:    vucomisd %xmm0, %xmm1
; X86-AVX512F-WIN-NEXT:    setbe %dl
; X86-AVX512F-WIN-NEXT:    kmovw %edx, %k1
; X86-AVX512F-WIN-NEXT:    vmovsd %xmm1, %xmm1, %xmm1 {%k1} {z}
; X86-AVX512F-WIN-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; X86-AVX512F-WIN-NEXT:    vmovsd %xmm0, (%esp)
; X86-AVX512F-WIN-NEXT:    fldl (%esp)
; X86-AVX512F-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-WIN-NEXT:    shll $31, %edx
; X86-AVX512F-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512F-WIN-NEXT:    popl %ebp
; X86-AVX512F-WIN-NEXT:    retl
;
; X86-AVX512F-LIN-LABEL: d_to_u64:
; X86-AVX512F-LIN:       # %bb.0:
; X86-AVX512F-LIN-NEXT:    subl $12, %esp
; X86-AVX512F-LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512F-LIN-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-AVX512F-LIN-NEXT:    xorl %edx, %edx
; X86-AVX512F-LIN-NEXT:    vucomisd %xmm0, %xmm1
; X86-AVX512F-LIN-NEXT:    setbe %dl
; X86-AVX512F-LIN-NEXT:    kmovw %edx, %k1
; X86-AVX512F-LIN-NEXT:    vmovsd %xmm1, %xmm1, %xmm1 {%k1} {z}
; X86-AVX512F-LIN-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; X86-AVX512F-LIN-NEXT:    vmovsd %xmm0, (%esp)
; X86-AVX512F-LIN-NEXT:    fldl (%esp)
; X86-AVX512F-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-LIN-NEXT:    shll $31, %edx
; X86-AVX512F-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-LIN-NEXT:    addl $12, %esp
; X86-AVX512F-LIN-NEXT:    retl
;
; X86-SSE3-WIN-LABEL: d_to_u64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-8, %esp
; X86-SSE3-WIN-NEXT:    subl $8, %esp
; X86-SSE3-WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE3-WIN-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-SSE3-WIN-NEXT:    ucomisd %xmm0, %xmm1
; X86-SSE3-WIN-NEXT:    jbe LBB2_2
; X86-SSE3-WIN-NEXT:  # %bb.1:
; X86-SSE3-WIN-NEXT:    xorpd %xmm1, %xmm1
; X86-SSE3-WIN-NEXT:  LBB2_2:
; X86-SSE3-WIN-NEXT:    subsd %xmm1, %xmm0
; X86-SSE3-WIN-NEXT:    movsd %xmm0, (%esp)
; X86-SSE3-WIN-NEXT:    fldl (%esp)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    setbe %al
; X86-SSE3-WIN-NEXT:    movzbl %al, %edx
; X86-SSE3-WIN-NEXT:    shll $31, %edx
; X86-SSE3-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: d_to_u64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE3-LIN-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-SSE3-LIN-NEXT:    ucomisd %xmm0, %xmm1
; X86-SSE3-LIN-NEXT:    jbe .LBB2_2
; X86-SSE3-LIN-NEXT:  # %bb.1:
; X86-SSE3-LIN-NEXT:    xorpd %xmm1, %xmm1
; X86-SSE3-LIN-NEXT:  .LBB2_2:
; X86-SSE3-LIN-NEXT:    subsd %xmm1, %xmm0
; X86-SSE3-LIN-NEXT:    movsd %xmm0, (%esp)
; X86-SSE3-LIN-NEXT:    fldl (%esp)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    setbe %al
; X86-SSE3-LIN-NEXT:    movzbl %al, %edx
; X86-SSE3-LIN-NEXT:    shll $31, %edx
; X86-SSE3-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE-WIN-LABEL: d_to_u64:
; X64-SSE-WIN:       # %bb.0:
; X64-SSE-WIN-NEXT:    cvttsd2si %xmm0, %rcx
; X64-SSE-WIN-NEXT:    movq %rcx, %rdx
; X64-SSE-WIN-NEXT:    sarq $63, %rdx
; X64-SSE-WIN-NEXT:    subsd __real@43e0000000000000(%rip), %xmm0
; X64-SSE-WIN-NEXT:    cvttsd2si %xmm0, %rax
; X64-SSE-WIN-NEXT:    andq %rdx, %rax
; X64-SSE-WIN-NEXT:    orq %rcx, %rax
; X64-SSE-WIN-NEXT:    retq
;
; X64-SSE-LIN-LABEL: d_to_u64:
; X64-SSE-LIN:       # %bb.0:
; X64-SSE-LIN-NEXT:    cvttsd2si %xmm0, %rcx
; X64-SSE-LIN-NEXT:    movq %rcx, %rdx
; X64-SSE-LIN-NEXT:    sarq $63, %rdx
; X64-SSE-LIN-NEXT:    subsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-LIN-NEXT:    cvttsd2si %xmm0, %rax
; X64-SSE-LIN-NEXT:    andq %rdx, %rax
; X64-SSE-LIN-NEXT:    orq %rcx, %rax
; X64-SSE-LIN-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: d_to_u64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-8, %esp
; X86-SSE2-WIN-NEXT:    subl $16, %esp
; X86-SSE2-WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-WIN-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-SSE2-WIN-NEXT:    ucomisd %xmm0, %xmm1
; X86-SSE2-WIN-NEXT:    jbe LBB2_2
; X86-SSE2-WIN-NEXT:  # %bb.1:
; X86-SSE2-WIN-NEXT:    xorpd %xmm1, %xmm1
; X86-SSE2-WIN-NEXT:  LBB2_2:
; X86-SSE2-WIN-NEXT:    subsd %xmm1, %xmm0
; X86-SSE2-WIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    setbe %al
; X86-SSE2-WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzbl %al, %edx
; X86-SSE2-WIN-NEXT:    shll $31, %edx
; X86-SSE2-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: d_to_u64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-LIN-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; X86-SSE2-LIN-NEXT:    ucomisd %xmm0, %xmm1
; X86-SSE2-LIN-NEXT:    jbe .LBB2_2
; X86-SSE2-LIN-NEXT:  # %bb.1:
; X86-SSE2-LIN-NEXT:    xorpd %xmm1, %xmm1
; X86-SSE2-LIN-NEXT:  .LBB2_2:
; X86-SSE2-LIN-NEXT:    subsd %xmm1, %xmm0
; X86-SSE2-LIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    setbe %al
; X86-SSE2-LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzbl %al, %edx
; X86-SSE2-LIN-NEXT:    shll $31, %edx
; X86-SSE2-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X87-WIN-LABEL: d_to_u64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-8, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    fldl 8(%ebp)
; X87-WIN-NEXT:    flds __real@5f000000
; X87-WIN-NEXT:    fucom %st(1)
; X87-WIN-NEXT:    fnstsw %ax
; X87-WIN-NEXT:    xorl %edx, %edx
; X87-WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-WIN-NEXT:    sahf
; X87-WIN-NEXT:    setbe %al
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:    jbe LBB2_2
; X87-WIN-NEXT:  # %bb.1:
; X87-WIN-NEXT:    fstp %st(1)
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:  LBB2_2:
; X87-WIN-NEXT:    fstp %st(0)
; X87-WIN-NEXT:    fsubrp %st, %st(1)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-WIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movb %al, %dl
; X87-WIN-NEXT:    shll $31, %edx
; X87-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: d_to_u64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X87-LIN-NEXT:    fucom %st(1)
; X87-LIN-NEXT:    fnstsw %ax
; X87-LIN-NEXT:    xorl %edx, %edx
; X87-LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-LIN-NEXT:    sahf
; X87-LIN-NEXT:    setbe %al
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:    jbe .LBB2_2
; X87-LIN-NEXT:  # %bb.1:
; X87-LIN-NEXT:    fstp %st(1)
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:  .LBB2_2:
; X87-LIN-NEXT:    fstp %st(0)
; X87-LIN-NEXT:    fsubrp %st, %st(1)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-LIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movb %al, %dl
; X87-LIN-NEXT:    shll $31, %edx
; X87-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptoui double %a to i64
  ret i64 %r
}

define i64 @d_to_s64(double %a) nounwind {
; X86-AVX512DQVL-LABEL: d_to_s64:
; X86-AVX512DQVL:       # %bb.0:
; X86-AVX512DQVL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512DQVL-NEXT:    vcvttpd2qq %xmm0, %xmm0
; X86-AVX512DQVL-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQVL-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQVL-NEXT:    retl
;
; X64-AVX512-LABEL: d_to_s64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vcvttsd2si %xmm0, %rax
; X64-AVX512-NEXT:    retq
;
; X86-AVX512DQ-LABEL: d_to_s64:
; X86-AVX512DQ:       # %bb.0:
; X86-AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512DQ-NEXT:    vcvttpd2qq %zmm0, %zmm0
; X86-AVX512DQ-NEXT:    vmovd %xmm0, %eax
; X86-AVX512DQ-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX512DQ-NEXT:    vzeroupper
; X86-AVX512DQ-NEXT:    retl
;
; X86-AVX512F-WIN-LABEL: d_to_s64:
; X86-AVX512F-WIN:       # %bb.0:
; X86-AVX512F-WIN-NEXT:    pushl %ebp
; X86-AVX512F-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512F-WIN-NEXT:    andl $-8, %esp
; X86-AVX512F-WIN-NEXT:    subl $8, %esp
; X86-AVX512F-WIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512F-WIN-NEXT:    vmovsd %xmm0, (%esp)
; X86-AVX512F-WIN-NEXT:    fldl (%esp)
; X86-AVX512F-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512F-WIN-NEXT:    popl %ebp
; X86-AVX512F-WIN-NEXT:    retl
;
; X86-AVX512F-LIN-LABEL: d_to_s64:
; X86-AVX512F-LIN:       # %bb.0:
; X86-AVX512F-LIN-NEXT:    subl $12, %esp
; X86-AVX512F-LIN-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX512F-LIN-NEXT:    vmovsd %xmm0, (%esp)
; X86-AVX512F-LIN-NEXT:    fldl (%esp)
; X86-AVX512F-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512F-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512F-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512F-LIN-NEXT:    addl $12, %esp
; X86-AVX512F-LIN-NEXT:    retl
;
; X86-SSE3-WIN-LABEL: d_to_s64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-8, %esp
; X86-SSE3-WIN-NEXT:    subl $8, %esp
; X86-SSE3-WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE3-WIN-NEXT:    movsd %xmm0, (%esp)
; X86-SSE3-WIN-NEXT:    fldl (%esp)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: d_to_s64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE3-LIN-NEXT:    movsd %xmm0, (%esp)
; X86-SSE3-LIN-NEXT:    fldl (%esp)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE-LABEL: d_to_s64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    cvttsd2si %xmm0, %rax
; X64-SSE-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: d_to_s64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-8, %esp
; X86-SSE2-WIN-NEXT:    subl $16, %esp
; X86-SSE2-WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-WIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: d_to_s64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-LIN-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X87-WIN-LABEL: d_to_s64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-8, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    fldl 8(%ebp)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: d_to_s64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptosi double %a to i64
  ret i64 %r
}

define i64 @x_to_u64(x86_fp80 %a) nounwind {
; X86-AVX512-WIN-LABEL: x_to_u64:
; X86-AVX512-WIN:       # %bb.0:
; X86-AVX512-WIN-NEXT:    pushl %ebp
; X86-AVX512-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512-WIN-NEXT:    andl $-16, %esp
; X86-AVX512-WIN-NEXT:    subl $16, %esp
; X86-AVX512-WIN-NEXT:    fldt 8(%ebp)
; X86-AVX512-WIN-NEXT:    flds __real@5f000000
; X86-AVX512-WIN-NEXT:    xorl %edx, %edx
; X86-AVX512-WIN-NEXT:    fucomi %st(1), %st
; X86-AVX512-WIN-NEXT:    fldz
; X86-AVX512-WIN-NEXT:    fcmovbe %st(1), %st
; X86-AVX512-WIN-NEXT:    fstp %st(1)
; X86-AVX512-WIN-NEXT:    fsubrp %st, %st(1)
; X86-AVX512-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512-WIN-NEXT:    setbe %dl
; X86-AVX512-WIN-NEXT:    shll $31, %edx
; X86-AVX512-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512-WIN-NEXT:    popl %ebp
; X86-AVX512-WIN-NEXT:    retl
;
; X86-AVX512-LIN-LABEL: x_to_u64:
; X86-AVX512-LIN:       # %bb.0:
; X86-AVX512-LIN-NEXT:    subl $12, %esp
; X86-AVX512-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-AVX512-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-AVX512-LIN-NEXT:    xorl %edx, %edx
; X86-AVX512-LIN-NEXT:    fucomi %st(1), %st
; X86-AVX512-LIN-NEXT:    fldz
; X86-AVX512-LIN-NEXT:    fcmovbe %st(1), %st
; X86-AVX512-LIN-NEXT:    fstp %st(1)
; X86-AVX512-LIN-NEXT:    fsubrp %st, %st(1)
; X86-AVX512-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512-LIN-NEXT:    setbe %dl
; X86-AVX512-LIN-NEXT:    shll $31, %edx
; X86-AVX512-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-AVX512-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512-LIN-NEXT:    addl $12, %esp
; X86-AVX512-LIN-NEXT:    retl
;
; X64-AVX512-WIN-LABEL: x_to_u64:
; X64-AVX512-WIN:       # %bb.0:
; X64-AVX512-WIN-NEXT:    pushq %rax
; X64-AVX512-WIN-NEXT:    fldt (%rcx)
; X64-AVX512-WIN-NEXT:    flds __real@5f000000(%rip)
; X64-AVX512-WIN-NEXT:    xorl %eax, %eax
; X64-AVX512-WIN-NEXT:    fucomi %st(1), %st
; X64-AVX512-WIN-NEXT:    fldz
; X64-AVX512-WIN-NEXT:    fcmovbe %st(1), %st
; X64-AVX512-WIN-NEXT:    fstp %st(1)
; X64-AVX512-WIN-NEXT:    fsubrp %st, %st(1)
; X64-AVX512-WIN-NEXT:    fisttpll (%rsp)
; X64-AVX512-WIN-NEXT:    setbe %al
; X64-AVX512-WIN-NEXT:    shlq $63, %rax
; X64-AVX512-WIN-NEXT:    xorq (%rsp), %rax
; X64-AVX512-WIN-NEXT:    popq %rcx
; X64-AVX512-WIN-NEXT:    retq
;
; X64-AVX512-LIN-LABEL: x_to_u64:
; X64-AVX512-LIN:       # %bb.0:
; X64-AVX512-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-AVX512-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; X64-AVX512-LIN-NEXT:    xorl %eax, %eax
; X64-AVX512-LIN-NEXT:    fucomi %st(1), %st
; X64-AVX512-LIN-NEXT:    fldz
; X64-AVX512-LIN-NEXT:    fcmovbe %st(1), %st
; X64-AVX512-LIN-NEXT:    fstp %st(1)
; X64-AVX512-LIN-NEXT:    fsubrp %st, %st(1)
; X64-AVX512-LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; X64-AVX512-LIN-NEXT:    setbe %al
; X64-AVX512-LIN-NEXT:    shlq $63, %rax
; X64-AVX512-LIN-NEXT:    xorq -{{[0-9]+}}(%rsp), %rax
; X64-AVX512-LIN-NEXT:    retq
;
; X86-SSE3-WIN-LABEL: x_to_u64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-16, %esp
; X86-SSE3-WIN-NEXT:    subl $16, %esp
; X86-SSE3-WIN-NEXT:    fldt 8(%ebp)
; X86-SSE3-WIN-NEXT:    flds __real@5f000000
; X86-SSE3-WIN-NEXT:    xorl %edx, %edx
; X86-SSE3-WIN-NEXT:    fucomi %st(1), %st
; X86-SSE3-WIN-NEXT:    fldz
; X86-SSE3-WIN-NEXT:    fcmovbe %st(1), %st
; X86-SSE3-WIN-NEXT:    fstp %st(1)
; X86-SSE3-WIN-NEXT:    fsubrp %st, %st(1)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    setbe %dl
; X86-SSE3-WIN-NEXT:    shll $31, %edx
; X86-SSE3-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: x_to_u64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-SSE3-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-SSE3-LIN-NEXT:    xorl %edx, %edx
; X86-SSE3-LIN-NEXT:    fucomi %st(1), %st
; X86-SSE3-LIN-NEXT:    fldz
; X86-SSE3-LIN-NEXT:    fcmovbe %st(1), %st
; X86-SSE3-LIN-NEXT:    fstp %st(1)
; X86-SSE3-LIN-NEXT:    fsubrp %st, %st(1)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    setbe %dl
; X86-SSE3-LIN-NEXT:    shll $31, %edx
; X86-SSE3-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE3-WIN-LABEL: x_to_u64:
; X64-SSE3-WIN:       # %bb.0:
; X64-SSE3-WIN-NEXT:    pushq %rax
; X64-SSE3-WIN-NEXT:    fldt (%rcx)
; X64-SSE3-WIN-NEXT:    flds __real@5f000000(%rip)
; X64-SSE3-WIN-NEXT:    xorl %eax, %eax
; X64-SSE3-WIN-NEXT:    fucomi %st(1), %st
; X64-SSE3-WIN-NEXT:    fldz
; X64-SSE3-WIN-NEXT:    fcmovbe %st(1), %st
; X64-SSE3-WIN-NEXT:    fstp %st(1)
; X64-SSE3-WIN-NEXT:    fsubrp %st, %st(1)
; X64-SSE3-WIN-NEXT:    fisttpll (%rsp)
; X64-SSE3-WIN-NEXT:    setbe %al
; X64-SSE3-WIN-NEXT:    shlq $63, %rax
; X64-SSE3-WIN-NEXT:    xorq (%rsp), %rax
; X64-SSE3-WIN-NEXT:    popq %rcx
; X64-SSE3-WIN-NEXT:    retq
;
; X64-SSE3-LIN-LABEL: x_to_u64:
; X64-SSE3-LIN:       # %bb.0:
; X64-SSE3-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-SSE3-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; X64-SSE3-LIN-NEXT:    xorl %eax, %eax
; X64-SSE3-LIN-NEXT:    fucomi %st(1), %st
; X64-SSE3-LIN-NEXT:    fldz
; X64-SSE3-LIN-NEXT:    fcmovbe %st(1), %st
; X64-SSE3-LIN-NEXT:    fstp %st(1)
; X64-SSE3-LIN-NEXT:    fsubrp %st, %st(1)
; X64-SSE3-LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; X64-SSE3-LIN-NEXT:    setbe %al
; X64-SSE3-LIN-NEXT:    shlq $63, %rax
; X64-SSE3-LIN-NEXT:    xorq -{{[0-9]+}}(%rsp), %rax
; X64-SSE3-LIN-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: x_to_u64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-16, %esp
; X86-SSE2-WIN-NEXT:    subl $32, %esp
; X86-SSE2-WIN-NEXT:    fldt 8(%ebp)
; X86-SSE2-WIN-NEXT:    flds __real@5f000000
; X86-SSE2-WIN-NEXT:    xorl %edx, %edx
; X86-SSE2-WIN-NEXT:    fucomi %st(1), %st
; X86-SSE2-WIN-NEXT:    setbe %dl
; X86-SSE2-WIN-NEXT:    fldz
; X86-SSE2-WIN-NEXT:    fcmovbe %st(1), %st
; X86-SSE2-WIN-NEXT:    fstp %st(1)
; X86-SSE2-WIN-NEXT:    fsubrp %st, %st(1)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    shll $31, %edx
; X86-SSE2-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: x_to_u64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-SSE2-LIN-NEXT:    xorl %edx, %edx
; X86-SSE2-LIN-NEXT:    fucomi %st(1), %st
; X86-SSE2-LIN-NEXT:    setbe %dl
; X86-SSE2-LIN-NEXT:    fldz
; X86-SSE2-LIN-NEXT:    fcmovbe %st(1), %st
; X86-SSE2-LIN-NEXT:    fstp %st(1)
; X86-SSE2-LIN-NEXT:    fsubrp %st, %st(1)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    shll $31, %edx
; X86-SSE2-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X64-SSE2-WIN-LABEL: x_to_u64:
; X64-SSE2-WIN:       # %bb.0:
; X64-SSE2-WIN-NEXT:    subq $16, %rsp
; X64-SSE2-WIN-NEXT:    fldt (%rcx)
; X64-SSE2-WIN-NEXT:    flds __real@5f000000(%rip)
; X64-SSE2-WIN-NEXT:    xorl %eax, %eax
; X64-SSE2-WIN-NEXT:    fucomi %st(1), %st
; X64-SSE2-WIN-NEXT:    setbe %al
; X64-SSE2-WIN-NEXT:    fldz
; X64-SSE2-WIN-NEXT:    fcmovbe %st(1), %st
; X64-SSE2-WIN-NEXT:    fstp %st(1)
; X64-SSE2-WIN-NEXT:    fsubrp %st, %st(1)
; X64-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; X64-SSE2-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X64-SSE2-WIN-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    shlq $63, %rax
; X64-SSE2-WIN-NEXT:    xorq {{[0-9]+}}(%rsp), %rax
; X64-SSE2-WIN-NEXT:    addq $16, %rsp
; X64-SSE2-WIN-NEXT:    retq
;
; X64-SSE2-LIN-LABEL: x_to_u64:
; X64-SSE2-LIN:       # %bb.0:
; X64-SSE2-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; X64-SSE2-LIN-NEXT:    xorl %eax, %eax
; X64-SSE2-LIN-NEXT:    fucomi %st(1), %st
; X64-SSE2-LIN-NEXT:    setbe %al
; X64-SSE2-LIN-NEXT:    fldz
; X64-SSE2-LIN-NEXT:    fcmovbe %st(1), %st
; X64-SSE2-LIN-NEXT:    fstp %st(1)
; X64-SSE2-LIN-NEXT:    fsubrp %st, %st(1)
; X64-SSE2-LIN-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    movzwl -{{[0-9]+}}(%rsp), %ecx
; X64-SSE2-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X64-SSE2-LIN-NEXT:    movw %cx, -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    shlq $63, %rax
; X64-SSE2-LIN-NEXT:    xorq -{{[0-9]+}}(%rsp), %rax
; X64-SSE2-LIN-NEXT:    retq
;
; X87-WIN-LABEL: x_to_u64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-16, %esp
; X87-WIN-NEXT:    subl $32, %esp
; X87-WIN-NEXT:    fldt 8(%ebp)
; X87-WIN-NEXT:    flds __real@5f000000
; X87-WIN-NEXT:    fucom %st(1)
; X87-WIN-NEXT:    fnstsw %ax
; X87-WIN-NEXT:    xorl %edx, %edx
; X87-WIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-WIN-NEXT:    sahf
; X87-WIN-NEXT:    setbe %al
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:    jbe LBB4_2
; X87-WIN-NEXT:  # %bb.1:
; X87-WIN-NEXT:    fstp %st(1)
; X87-WIN-NEXT:    fldz
; X87-WIN-NEXT:  LBB4_2:
; X87-WIN-NEXT:    fstp %st(0)
; X87-WIN-NEXT:    fsubrp %st, %st(1)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-WIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-WIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movb %al, %dl
; X87-WIN-NEXT:    shll $31, %edx
; X87-WIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: x_to_u64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X87-LIN-NEXT:    fucom %st(1)
; X87-LIN-NEXT:    fnstsw %ax
; X87-LIN-NEXT:    xorl %edx, %edx
; X87-LIN-NEXT:    # kill: def $ah killed $ah killed $ax
; X87-LIN-NEXT:    sahf
; X87-LIN-NEXT:    setbe %al
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:    jbe .LBB4_2
; X87-LIN-NEXT:  # %bb.1:
; X87-LIN-NEXT:    fstp %st(1)
; X87-LIN-NEXT:    fldz
; X87-LIN-NEXT:  .LBB4_2:
; X87-LIN-NEXT:    fstp %st(0)
; X87-LIN-NEXT:    fsubrp %st, %st(1)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X87-LIN-NEXT:    orl $3072, %ecx # imm = 0xC00
; X87-LIN-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movb %al, %dl
; X87-LIN-NEXT:    shll $31, %edx
; X87-LIN-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptoui x86_fp80 %a to i64
  ret i64 %r
}

define i64 @x_to_s64(x86_fp80 %a) nounwind {
; X86-AVX512-WIN-LABEL: x_to_s64:
; X86-AVX512-WIN:       # %bb.0:
; X86-AVX512-WIN-NEXT:    pushl %ebp
; X86-AVX512-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512-WIN-NEXT:    andl $-16, %esp
; X86-AVX512-WIN-NEXT:    subl $16, %esp
; X86-AVX512-WIN-NEXT:    fldt 8(%ebp)
; X86-AVX512-WIN-NEXT:    fisttpll (%esp)
; X86-AVX512-WIN-NEXT:    movl (%esp), %eax
; X86-AVX512-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512-WIN-NEXT:    popl %ebp
; X86-AVX512-WIN-NEXT:    retl
;
; X86-AVX512-LIN-LABEL: x_to_s64:
; X86-AVX512-LIN:       # %bb.0:
; X86-AVX512-LIN-NEXT:    subl $12, %esp
; X86-AVX512-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-AVX512-LIN-NEXT:    fisttpll (%esp)
; X86-AVX512-LIN-NEXT:    movl (%esp), %eax
; X86-AVX512-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-AVX512-LIN-NEXT:    addl $12, %esp
; X86-AVX512-LIN-NEXT:    retl
;
; X64-AVX512-WIN-LABEL: x_to_s64:
; X64-AVX512-WIN:       # %bb.0:
; X64-AVX512-WIN-NEXT:    pushq %rax
; X64-AVX512-WIN-NEXT:    fldt (%rcx)
; X64-AVX512-WIN-NEXT:    fisttpll (%rsp)
; X64-AVX512-WIN-NEXT:    movq (%rsp), %rax
; X64-AVX512-WIN-NEXT:    popq %rcx
; X64-AVX512-WIN-NEXT:    retq
;
; X64-AVX512-LIN-LABEL: x_to_s64:
; X64-AVX512-LIN:       # %bb.0:
; X64-AVX512-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-AVX512-LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; X64-AVX512-LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; X64-AVX512-LIN-NEXT:    retq
;
; X86-SSE3-WIN-LABEL: x_to_s64:
; X86-SSE3-WIN:       # %bb.0:
; X86-SSE3-WIN-NEXT:    pushl %ebp
; X86-SSE3-WIN-NEXT:    movl %esp, %ebp
; X86-SSE3-WIN-NEXT:    andl $-16, %esp
; X86-SSE3-WIN-NEXT:    subl $16, %esp
; X86-SSE3-WIN-NEXT:    fldt 8(%ebp)
; X86-SSE3-WIN-NEXT:    fisttpll (%esp)
; X86-SSE3-WIN-NEXT:    movl (%esp), %eax
; X86-SSE3-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-WIN-NEXT:    movl %ebp, %esp
; X86-SSE3-WIN-NEXT:    popl %ebp
; X86-SSE3-WIN-NEXT:    retl
;
; X86-SSE3-LIN-LABEL: x_to_s64:
; X86-SSE3-LIN:       # %bb.0:
; X86-SSE3-LIN-NEXT:    subl $12, %esp
; X86-SSE3-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-SSE3-LIN-NEXT:    fisttpll (%esp)
; X86-SSE3-LIN-NEXT:    movl (%esp), %eax
; X86-SSE3-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE3-LIN-NEXT:    addl $12, %esp
; X86-SSE3-LIN-NEXT:    retl
;
; X64-SSE3-WIN-LABEL: x_to_s64:
; X64-SSE3-WIN:       # %bb.0:
; X64-SSE3-WIN-NEXT:    pushq %rax
; X64-SSE3-WIN-NEXT:    fldt (%rcx)
; X64-SSE3-WIN-NEXT:    fisttpll (%rsp)
; X64-SSE3-WIN-NEXT:    movq (%rsp), %rax
; X64-SSE3-WIN-NEXT:    popq %rcx
; X64-SSE3-WIN-NEXT:    retq
;
; X64-SSE3-LIN-LABEL: x_to_s64:
; X64-SSE3-LIN:       # %bb.0:
; X64-SSE3-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-SSE3-LIN-NEXT:    fisttpll -{{[0-9]+}}(%rsp)
; X64-SSE3-LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; X64-SSE3-LIN-NEXT:    retq
;
; X86-SSE2-WIN-LABEL: x_to_s64:
; X86-SSE2-WIN:       # %bb.0:
; X86-SSE2-WIN-NEXT:    pushl %ebp
; X86-SSE2-WIN-NEXT:    movl %esp, %ebp
; X86-SSE2-WIN-NEXT:    andl $-16, %esp
; X86-SSE2-WIN-NEXT:    subl $32, %esp
; X86-SSE2-WIN-NEXT:    fldt 8(%ebp)
; X86-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-WIN-NEXT:    movl %ebp, %esp
; X86-SSE2-WIN-NEXT:    popl %ebp
; X86-SSE2-WIN-NEXT:    retl
;
; X86-SSE2-LIN-LABEL: x_to_s64:
; X86-SSE2-LIN:       # %bb.0:
; X86-SSE2-LIN-NEXT:    subl $20, %esp
; X86-SSE2-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X86-SSE2-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-LIN-NEXT:    addl $20, %esp
; X86-SSE2-LIN-NEXT:    retl
;
; X64-SSE2-WIN-LABEL: x_to_s64:
; X64-SSE2-WIN:       # %bb.0:
; X64-SSE2-WIN-NEXT:    subq $16, %rsp
; X64-SSE2-WIN-NEXT:    fldt (%rcx)
; X64-SSE2-WIN-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; X64-SSE2-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X64-SSE2-WIN-NEXT:    movw %ax, {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fistpll {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    fldcw {{[0-9]+}}(%rsp)
; X64-SSE2-WIN-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-SSE2-WIN-NEXT:    addq $16, %rsp
; X64-SSE2-WIN-NEXT:    retq
;
; X64-SSE2-LIN-LABEL: x_to_s64:
; X64-SSE2-LIN:       # %bb.0:
; X64-SSE2-LIN-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    movzwl -{{[0-9]+}}(%rsp), %eax
; X64-SSE2-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X64-SSE2-LIN-NEXT:    movw %ax, -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fistpll -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    fldcw -{{[0-9]+}}(%rsp)
; X64-SSE2-LIN-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; X64-SSE2-LIN-NEXT:    retq
;
; X87-WIN-LABEL: x_to_s64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-16, %esp
; X87-WIN-NEXT:    subl $32, %esp
; X87-WIN-NEXT:    fldt 8(%ebp)
; X87-WIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-WIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-WIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: x_to_s64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $20, %esp
; X87-LIN-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fnstcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-LIN-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fistpll {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-LIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X87-LIN-NEXT:    addl $20, %esp
; X87-LIN-NEXT:    retl
  %r = fptosi x86_fp80 %a to i64
  ret i64 %r
}

define i64 @t_to_u64(fp128 %a) nounwind {
; X86-AVX512-WIN-LABEL: t_to_u64:
; X86-AVX512-WIN:       # %bb.0:
; X86-AVX512-WIN-NEXT:    pushl %ebp
; X86-AVX512-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512-WIN-NEXT:    andl $-16, %esp
; X86-AVX512-WIN-NEXT:    subl $32, %esp
; X86-AVX512-WIN-NEXT:    vmovups 8(%ebp), %xmm0
; X86-AVX512-WIN-NEXT:    vmovups %xmm0, (%esp)
; X86-AVX512-WIN-NEXT:    calll ___fixunstfdi
; X86-AVX512-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512-WIN-NEXT:    popl %ebp
; X86-AVX512-WIN-NEXT:    retl
;
; X86-AVX512-LIN-LABEL: t_to_u64:
; X86-AVX512-LIN:       # %bb.0:
; X86-AVX512-LIN-NEXT:    subl $28, %esp
; X86-AVX512-LIN-NEXT:    vmovaps {{[0-9]+}}(%esp), %xmm0
; X86-AVX512-LIN-NEXT:    vmovups %xmm0, (%esp)
; X86-AVX512-LIN-NEXT:    calll __fixunstfdi
; X86-AVX512-LIN-NEXT:    addl $28, %esp
; X86-AVX512-LIN-NEXT:    retl
;
; X64-AVX512-WIN-LABEL: t_to_u64:
; X64-AVX512-WIN:       # %bb.0:
; X64-AVX512-WIN-NEXT:    subq $56, %rsp
; X64-AVX512-WIN-NEXT:    vmovaps (%rcx), %xmm0
; X64-AVX512-WIN-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp)
; X64-AVX512-WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-AVX512-WIN-NEXT:    callq __fixunstfdi
; X64-AVX512-WIN-NEXT:    addq $56, %rsp
; X64-AVX512-WIN-NEXT:    retq
;
; X64-AVX512-LIN-LABEL: t_to_u64:
; X64-AVX512-LIN:       # %bb.0:
; X64-AVX512-LIN-NEXT:    pushq %rax
; X64-AVX512-LIN-NEXT:    callq __fixunstfdi@PLT
; X64-AVX512-LIN-NEXT:    popq %rcx
; X64-AVX512-LIN-NEXT:    retq
;
; X86-SSE-WIN-LABEL: t_to_u64:
; X86-SSE-WIN:       # %bb.0:
; X86-SSE-WIN-NEXT:    pushl %ebp
; X86-SSE-WIN-NEXT:    movl %esp, %ebp
; X86-SSE-WIN-NEXT:    andl $-16, %esp
; X86-SSE-WIN-NEXT:    subl $16, %esp
; X86-SSE-WIN-NEXT:    pushl 20(%ebp)
; X86-SSE-WIN-NEXT:    pushl 16(%ebp)
; X86-SSE-WIN-NEXT:    pushl 12(%ebp)
; X86-SSE-WIN-NEXT:    pushl 8(%ebp)
; X86-SSE-WIN-NEXT:    calll ___fixunstfdi
; X86-SSE-WIN-NEXT:    addl $16, %esp
; X86-SSE-WIN-NEXT:    movl %ebp, %esp
; X86-SSE-WIN-NEXT:    popl %ebp
; X86-SSE-WIN-NEXT:    retl
;
; X86-SSE-LIN-LABEL: t_to_u64:
; X86-SSE-LIN:       # %bb.0:
; X86-SSE-LIN-NEXT:    subl $12, %esp
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    calll __fixunstfdi
; X86-SSE-LIN-NEXT:    addl $28, %esp
; X86-SSE-LIN-NEXT:    retl
;
; X64-SSE-WIN-LABEL: t_to_u64:
; X64-SSE-WIN:       # %bb.0:
; X64-SSE-WIN-NEXT:    subq $56, %rsp
; X64-SSE-WIN-NEXT:    movaps (%rcx), %xmm0
; X64-SSE-WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; X64-SSE-WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-SSE-WIN-NEXT:    callq __fixunstfdi
; X64-SSE-WIN-NEXT:    addq $56, %rsp
; X64-SSE-WIN-NEXT:    retq
;
; X64-SSE-LIN-LABEL: t_to_u64:
; X64-SSE-LIN:       # %bb.0:
; X64-SSE-LIN-NEXT:    pushq %rax
; X64-SSE-LIN-NEXT:    callq __fixunstfdi@PLT
; X64-SSE-LIN-NEXT:    popq %rcx
; X64-SSE-LIN-NEXT:    retq
;
; X87-WIN-LABEL: t_to_u64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-16, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    pushl 20(%ebp)
; X87-WIN-NEXT:    pushl 16(%ebp)
; X87-WIN-NEXT:    pushl 12(%ebp)
; X87-WIN-NEXT:    pushl 8(%ebp)
; X87-WIN-NEXT:    calll ___fixunstfdi
; X87-WIN-NEXT:    addl $16, %esp
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: t_to_u64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $12, %esp
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    calll __fixunstfdi
; X87-LIN-NEXT:    addl $28, %esp
; X87-LIN-NEXT:    retl
  %r = fptoui fp128 %a to i64
  ret i64 %r
}

define i64 @t_to_s64(fp128 %a) nounwind {
; X86-AVX512-WIN-LABEL: t_to_s64:
; X86-AVX512-WIN:       # %bb.0:
; X86-AVX512-WIN-NEXT:    pushl %ebp
; X86-AVX512-WIN-NEXT:    movl %esp, %ebp
; X86-AVX512-WIN-NEXT:    andl $-16, %esp
; X86-AVX512-WIN-NEXT:    subl $32, %esp
; X86-AVX512-WIN-NEXT:    vmovups 8(%ebp), %xmm0
; X86-AVX512-WIN-NEXT:    vmovups %xmm0, (%esp)
; X86-AVX512-WIN-NEXT:    calll ___fixtfdi
; X86-AVX512-WIN-NEXT:    movl %ebp, %esp
; X86-AVX512-WIN-NEXT:    popl %ebp
; X86-AVX512-WIN-NEXT:    retl
;
; X86-AVX512-LIN-LABEL: t_to_s64:
; X86-AVX512-LIN:       # %bb.0:
; X86-AVX512-LIN-NEXT:    subl $28, %esp
; X86-AVX512-LIN-NEXT:    vmovaps {{[0-9]+}}(%esp), %xmm0
; X86-AVX512-LIN-NEXT:    vmovups %xmm0, (%esp)
; X86-AVX512-LIN-NEXT:    calll __fixtfdi
; X86-AVX512-LIN-NEXT:    addl $28, %esp
; X86-AVX512-LIN-NEXT:    retl
;
; X64-AVX512-WIN-LABEL: t_to_s64:
; X64-AVX512-WIN:       # %bb.0:
; X64-AVX512-WIN-NEXT:    subq $56, %rsp
; X64-AVX512-WIN-NEXT:    vmovaps (%rcx), %xmm0
; X64-AVX512-WIN-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp)
; X64-AVX512-WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-AVX512-WIN-NEXT:    callq __fixtfdi
; X64-AVX512-WIN-NEXT:    addq $56, %rsp
; X64-AVX512-WIN-NEXT:    retq
;
; X64-AVX512-LIN-LABEL: t_to_s64:
; X64-AVX512-LIN:       # %bb.0:
; X64-AVX512-LIN-NEXT:    pushq %rax
; X64-AVX512-LIN-NEXT:    callq __fixtfdi@PLT
; X64-AVX512-LIN-NEXT:    popq %rcx
; X64-AVX512-LIN-NEXT:    retq
;
; X86-SSE-WIN-LABEL: t_to_s64:
; X86-SSE-WIN:       # %bb.0:
; X86-SSE-WIN-NEXT:    pushl %ebp
; X86-SSE-WIN-NEXT:    movl %esp, %ebp
; X86-SSE-WIN-NEXT:    andl $-16, %esp
; X86-SSE-WIN-NEXT:    subl $16, %esp
; X86-SSE-WIN-NEXT:    pushl 20(%ebp)
; X86-SSE-WIN-NEXT:    pushl 16(%ebp)
; X86-SSE-WIN-NEXT:    pushl 12(%ebp)
; X86-SSE-WIN-NEXT:    pushl 8(%ebp)
; X86-SSE-WIN-NEXT:    calll ___fixtfdi
; X86-SSE-WIN-NEXT:    addl $16, %esp
; X86-SSE-WIN-NEXT:    movl %ebp, %esp
; X86-SSE-WIN-NEXT:    popl %ebp
; X86-SSE-WIN-NEXT:    retl
;
; X86-SSE-LIN-LABEL: t_to_s64:
; X86-SSE-LIN:       # %bb.0:
; X86-SSE-LIN-NEXT:    subl $12, %esp
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE-LIN-NEXT:    calll __fixtfdi
; X86-SSE-LIN-NEXT:    addl $28, %esp
; X86-SSE-LIN-NEXT:    retl
;
; X64-SSE-WIN-LABEL: t_to_s64:
; X64-SSE-WIN:       # %bb.0:
; X64-SSE-WIN-NEXT:    subq $56, %rsp
; X64-SSE-WIN-NEXT:    movaps (%rcx), %xmm0
; X64-SSE-WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; X64-SSE-WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-SSE-WIN-NEXT:    callq __fixtfdi
; X64-SSE-WIN-NEXT:    addq $56, %rsp
; X64-SSE-WIN-NEXT:    retq
;
; X64-SSE-LIN-LABEL: t_to_s64:
; X64-SSE-LIN:       # %bb.0:
; X64-SSE-LIN-NEXT:    pushq %rax
; X64-SSE-LIN-NEXT:    callq __fixtfdi@PLT
; X64-SSE-LIN-NEXT:    popq %rcx
; X64-SSE-LIN-NEXT:    retq
;
; X87-WIN-LABEL: t_to_s64:
; X87-WIN:       # %bb.0:
; X87-WIN-NEXT:    pushl %ebp
; X87-WIN-NEXT:    movl %esp, %ebp
; X87-WIN-NEXT:    andl $-16, %esp
; X87-WIN-NEXT:    subl $16, %esp
; X87-WIN-NEXT:    pushl 20(%ebp)
; X87-WIN-NEXT:    pushl 16(%ebp)
; X87-WIN-NEXT:    pushl 12(%ebp)
; X87-WIN-NEXT:    pushl 8(%ebp)
; X87-WIN-NEXT:    calll ___fixtfdi
; X87-WIN-NEXT:    addl $16, %esp
; X87-WIN-NEXT:    movl %ebp, %esp
; X87-WIN-NEXT:    popl %ebp
; X87-WIN-NEXT:    retl
;
; X87-LIN-LABEL: t_to_s64:
; X87-LIN:       # %bb.0:
; X87-LIN-NEXT:    subl $12, %esp
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    pushl {{[0-9]+}}(%esp)
; X87-LIN-NEXT:    calll __fixtfdi
; X87-LIN-NEXT:    addl $28, %esp
; X87-LIN-NEXT:    retl
  %r = fptosi fp128 %a to i64
  ret i64 %r
}
