; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -verify-machineinstrs -mtriple=riscv64 -mattr=+v,+d,+m,+zbb %s -o - | FileCheck %s --check-prefix=RV64
; RUN: llc -verify-machineinstrs -mtriple=riscv32 -mattr=+v,+d,+m,+zbb %s -o - | FileCheck %s --check-prefix=RV32

; Compress + store for i8 type

define void @test_compresstore_v1i8(ptr %p, <1 x i1> %mask, <1 x i8> %data) {
; RV64-LABEL: test_compresstore_v1i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; RV64-NEXT:    vse8.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v1i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; RV32-NEXT:    vse8.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v1i8(<1 x i8> %data, ptr align 1 %p, <1 x i1> %mask)
  ret void
}

define void @test_compresstore_v2i8(ptr %p, <2 x i1> %mask, <2 x i8> %data) {
; RV64-LABEL: test_compresstore_v2i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; RV64-NEXT:    vse8.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v2i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; RV32-NEXT:    vse8.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v2i8(<2 x i8> %data, ptr align 1 %p, <2 x i1> %mask)
  ret void
}

define void @test_compresstore_v4i8(ptr %p, <4 x i1> %mask, <4 x i8> %data) {
; RV64-LABEL: test_compresstore_v4i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; RV64-NEXT:    vse8.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v4i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; RV32-NEXT:    vse8.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v4i8(<4 x i8> %data, ptr align 1 %p, <4 x i1> %mask)
  ret void
}

define void @test_compresstore_v8i8(ptr %p, <8 x i1> %mask, <8 x i8> %data) {
; RV64-LABEL: test_compresstore_v8i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; RV64-NEXT:    vse8.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v8i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; RV32-NEXT:    vse8.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v8i8(<8 x i8> %data, ptr align 1 %p, <8 x i1> %mask)
  ret void
}

define void @test_compresstore_v16i8(ptr %p, <16 x i1> %mask, <16 x i8> %data) {
; RV64-LABEL: test_compresstore_v16i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; RV64-NEXT:    vse8.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v16i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; RV32-NEXT:    vse8.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v16i8(<16 x i8> %data, ptr align 1 %p, <16 x i1> %mask)
  ret void
}

define void @test_compresstore_v32i8(ptr %p, <32 x i1> %mask, <32 x i8> %data) {
; RV64-LABEL: test_compresstore_v32i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 32
; RV64-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; RV64-NEXT:    vcompress.vm v10, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; RV64-NEXT:    vse8.v v10, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v32i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; RV32-NEXT:    vcompress.vm v10, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; RV32-NEXT:    vse8.v v10, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v32i8(<32 x i8> %data, ptr align 1 %p, <32 x i1> %mask)
  ret void
}

define void @test_compresstore_v64i8(ptr %p, <64 x i1> %mask, <64 x i8> %data) {
; RV64-LABEL: test_compresstore_v64i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 64
; RV64-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; RV64-NEXT:    vcompress.vm v12, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; RV64-NEXT:    vse8.v v12, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v64i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 64
; RV32-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; RV32-NEXT:    vcompress.vm v12, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; RV32-NEXT:    vse8.v v12, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v64i8(<64 x i8> %data, ptr align 1 %p, <64 x i1> %mask)
  ret void
}

define void @test_compresstore_v128i8(ptr %p, <128 x i1> %mask, <128 x i8> %data) {
; RV64-LABEL: test_compresstore_v128i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 128
; RV64-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; RV64-NEXT:    vcompress.vm v16, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; RV64-NEXT:    vse8.v v16, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v128i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 128
; RV32-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; RV32-NEXT:    vcompress.vm v16, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; RV32-NEXT:    vse8.v v16, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v128i8(<128 x i8> %data, ptr align 1 %p, <128 x i1> %mask)
  ret void
}

define void @test_compresstore_v256i8(ptr %p, <256 x i1> %mask, <256 x i8> %data) {
; RV64-LABEL: test_compresstore_v256i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV64-NEXT:    vmv1r.v v7, v8
; RV64-NEXT:    li a2, 128
; RV64-NEXT:    vslidedown.vi v8, v0, 1
; RV64-NEXT:    vmv.x.s a3, v0
; RV64-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV64-NEXT:    vle8.v v24, (a1)
; RV64-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV64-NEXT:    vmv.x.s a1, v8
; RV64-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV64-NEXT:    vcompress.vm v8, v16, v0
; RV64-NEXT:    vcpop.m a4, v0
; RV64-NEXT:    vsetvli zero, a4, e8, m8, ta, ma
; RV64-NEXT:    vse8.v v8, (a0)
; RV64-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV64-NEXT:    vcpop.m a2, v7
; RV64-NEXT:    cpop a3, a3
; RV64-NEXT:    cpop a1, a1
; RV64-NEXT:    add a0, a0, a3
; RV64-NEXT:    vcompress.vm v8, v24, v7
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV64-NEXT:    vse8.v v8, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v256i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vmv1r.v v7, v8
; RV32-NEXT:    li a2, 128
; RV32-NEXT:    vslidedown.vi v8, v0, 1
; RV32-NEXT:    li a3, 32
; RV32-NEXT:    vmv.x.s a4, v0
; RV32-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV32-NEXT:    vle8.v v24, (a1)
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v6, v8, a3
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    vsrl.vx v5, v0, a3
; RV32-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV32-NEXT:    vcompress.vm v8, v16, v0
; RV32-NEXT:    vcpop.m a3, v0
; RV32-NEXT:    cpop a4, a4
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a5, v6
; RV32-NEXT:    vmv.x.s a6, v5
; RV32-NEXT:    vsetvli zero, a3, e8, m8, ta, ma
; RV32-NEXT:    vse8.v v8, (a0)
; RV32-NEXT:    cpop a1, a1
; RV32-NEXT:    cpop a3, a6
; RV32-NEXT:    cpop a5, a5
; RV32-NEXT:    add a3, a4, a3
; RV32-NEXT:    add a1, a1, a5
; RV32-NEXT:    add a1, a3, a1
; RV32-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; RV32-NEXT:    vcompress.vm v8, v24, v7
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vcpop.m a1, v7
; RV32-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; RV32-NEXT:    vse8.v v8, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v256i8(<256 x i8> %data, ptr align 1 %p, <256 x i1> %mask)
  ret void
}

; Compress + store for i16 type

define void @test_compresstore_v1i16(ptr %p, <1 x i1> %mask, <1 x i16> %data) {
; RV64-LABEL: test_compresstore_v1i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; RV64-NEXT:    vse16.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v1i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; RV32-NEXT:    vse16.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v1i16(<1 x i16> %data, ptr align 2 %p, <1 x i1> %mask)
  ret void
}

define void @test_compresstore_v2i16(ptr %p, <2 x i1> %mask, <2 x i16> %data) {
; RV64-LABEL: test_compresstore_v2i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; RV64-NEXT:    vse16.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v2i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; RV32-NEXT:    vse16.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v2i16(<2 x i16> %data, ptr align 2 %p, <2 x i1> %mask)
  ret void
}

define void @test_compresstore_v4i16(ptr %p, <4 x i1> %mask, <4 x i16> %data) {
; RV64-LABEL: test_compresstore_v4i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; RV64-NEXT:    vse16.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v4i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; RV32-NEXT:    vse16.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v4i16(<4 x i16> %data, ptr align 2 %p, <4 x i1> %mask)
  ret void
}

define void @test_compresstore_v8i16(ptr %p, <8 x i1> %mask, <8 x i16> %data) {
; RV64-LABEL: test_compresstore_v8i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vse16.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v8i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vse16.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v8i16(<8 x i16> %data, ptr align 2 %p, <8 x i1> %mask)
  ret void
}

define void @test_compresstore_v16i16(ptr %p, <16 x i1> %mask, <16 x i16> %data) {
; RV64-LABEL: test_compresstore_v16i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-NEXT:    vcompress.vm v10, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; RV64-NEXT:    vse16.v v10, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v16i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vcompress.vm v10, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; RV32-NEXT:    vse16.v v10, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v16i16(<16 x i16> %data, ptr align 2 %p, <16 x i1> %mask)
  ret void
}

define void @test_compresstore_v32i16(ptr %p, <32 x i1> %mask, <32 x i16> %data) {
; RV64-LABEL: test_compresstore_v32i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 32
; RV64-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; RV64-NEXT:    vcompress.vm v12, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; RV64-NEXT:    vse16.v v12, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v32i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; RV32-NEXT:    vcompress.vm v12, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; RV32-NEXT:    vse16.v v12, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v32i16(<32 x i16> %data, ptr align 2 %p, <32 x i1> %mask)
  ret void
}

define void @test_compresstore_v64i16(ptr %p, <64 x i1> %mask, <64 x i16> %data) {
; RV64-LABEL: test_compresstore_v64i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 64
; RV64-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV64-NEXT:    vcompress.vm v16, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV64-NEXT:    vse16.v v16, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v64i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 64
; RV32-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV32-NEXT:    vcompress.vm v16, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV32-NEXT:    vse16.v v16, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v64i16(<64 x i16> %data, ptr align 2 %p, <64 x i1> %mask)
  ret void
}

define void @test_compresstore_v128i16(ptr %p, <128 x i1> %mask, <128 x i16> %data) {
; RV64-LABEL: test_compresstore_v128i16:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 64
; RV64-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV64-NEXT:    vcompress.vm v24, v8, v0
; RV64-NEXT:    vcpop.m a2, v0
; RV64-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; RV64-NEXT:    vslidedown.vi v7, v0, 8
; RV64-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV64-NEXT:    vcompress.vm v8, v16, v7
; RV64-NEXT:    vcpop.m a1, v7
; RV64-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; RV64-NEXT:    vse16.v v24, (a0)
; RV64-NEXT:    slli a2, a2, 1
; RV64-NEXT:    add a0, a0, a2
; RV64-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV64-NEXT:    vse16.v v8, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v128i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 64
; RV32-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; RV32-NEXT:    vslidedown.vi v7, v0, 8
; RV32-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV32-NEXT:    vcompress.vm v24, v16, v7
; RV32-NEXT:    vcpop.m a2, v7
; RV32-NEXT:    li a3, 32
; RV32-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a4, v0
; RV32-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV32-NEXT:    vcompress.vm v16, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v0, a3
; RV32-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; RV32-NEXT:    vse16.v v16, (a0)
; RV32-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    cpop a1, a1
; RV32-NEXT:    cpop a3, a4
; RV32-NEXT:    add a1, a3, a1
; RV32-NEXT:    slli a1, a1, 1
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; RV32-NEXT:    vse16.v v24, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v128i16(<128 x i16> %data, ptr align 2 %p, <128 x i1> %mask)
  ret void
}

; Compress + store for i32 type

define void @test_compresstore_v1i32(ptr %p, <1 x i1> %mask, <1 x i32> %data) {
; RV64-LABEL: test_compresstore_v1i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; RV64-NEXT:    vse32.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v1i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; RV32-NEXT:    vse32.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v1i32(<1 x i32> %data, ptr align 4 %p, <1 x i1> %mask)
  ret void
}

define void @test_compresstore_v2i32(ptr %p, <2 x i1> %mask, <2 x i32> %data) {
; RV64-LABEL: test_compresstore_v2i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; RV64-NEXT:    vse32.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v2i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; RV32-NEXT:    vse32.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v2i32(<2 x i32> %data, ptr align 4 %p, <2 x i1> %mask)
  ret void
}

define void @test_compresstore_v4i32(ptr %p, <4 x i1> %mask, <4 x i32> %data) {
; RV64-LABEL: test_compresstore_v4i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; RV64-NEXT:    vse32.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v4i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; RV32-NEXT:    vse32.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v4i32(<4 x i32> %data, ptr align 4 %p, <4 x i1> %mask)
  ret void
}

define void @test_compresstore_v8i32(ptr %p, <8 x i1> %mask, <8 x i32> %data) {
; RV64-LABEL: test_compresstore_v8i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vcompress.vm v10, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vse32.v v10, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v8i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vcompress.vm v10, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vse32.v v10, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v8i32(<8 x i32> %data, ptr align 4 %p, <8 x i1> %mask)
  ret void
}

define void @test_compresstore_v16i32(ptr %p, <16 x i1> %mask, <16 x i32> %data) {
; RV64-LABEL: test_compresstore_v16i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV64-NEXT:    vcompress.vm v12, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; RV64-NEXT:    vse32.v v12, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v16i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vcompress.vm v12, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; RV32-NEXT:    vse32.v v12, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v16i32(<16 x i32> %data, ptr align 4 %p, <16 x i1> %mask)
  ret void
}

define void @test_compresstore_v32i32(ptr %p, <32 x i1> %mask, <32 x i32> %data) {
; RV64-LABEL: test_compresstore_v32i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 32
; RV64-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV64-NEXT:    vcompress.vm v16, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV64-NEXT:    vse32.v v16, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v32i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV32-NEXT:    vcompress.vm v16, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV32-NEXT:    vse32.v v16, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v32i32(<32 x i32> %data, ptr align 4 %p, <32 x i1> %mask)
  ret void
}

define void @test_compresstore_v64i32(ptr %p, <64 x i1> %mask, <64 x i32> %data) {
; RV64-LABEL: test_compresstore_v64i32:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    li a1, 32
; RV64-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV64-NEXT:    vcompress.vm v24, v8, v0
; RV64-NEXT:    vcpop.m a2, v0
; RV64-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV64-NEXT:    vse32.v v24, (a0)
; RV64-NEXT:    vsetivli zero, 4, e8, mf2, ta, ma
; RV64-NEXT:    vslidedown.vi v24, v0, 4
; RV64-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV64-NEXT:    vmv.x.s a1, v0
; RV64-NEXT:    vcompress.vm v8, v16, v24
; RV64-NEXT:    vcpop.m a2, v24
; RV64-NEXT:    cpopw a1, a1
; RV64-NEXT:    slli a1, a1, 2
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV64-NEXT:    vse32.v v8, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v64i32:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV32-NEXT:    vcompress.vm v24, v8, v0
; RV32-NEXT:    vcpop.m a2, v0
; RV32-NEXT:    vsetivli zero, 4, e8, mf2, ta, ma
; RV32-NEXT:    vslidedown.vi v7, v0, 4
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV32-NEXT:    vcompress.vm v8, v16, v7
; RV32-NEXT:    vcpop.m a1, v7
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vse32.v v24, (a0)
; RV32-NEXT:    slli a2, a2, 2
; RV32-NEXT:    add a0, a0, a2
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; RV32-NEXT:    vse32.v v8, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v64i32(<64 x i32> %data, ptr align 4 %p, <64 x i1> %mask)
  ret void
}

; Compress + store for i64 type

define void @test_compresstore_v1i64(ptr %p, <1 x i1> %mask, <1 x i64> %data) {
; RV64-LABEL: test_compresstore_v1i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vse64.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v1i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV32-NEXT:    vse64.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v1i64(<1 x i64> %data, ptr align 8 %p, <1 x i1> %mask)
  ret void
}

define void @test_compresstore_v2i64(ptr %p, <2 x i1> %mask, <2 x i64> %data) {
; RV64-LABEL: test_compresstore_v2i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vcompress.vm v9, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vse64.v v9, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v2i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vcompress.vm v9, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV32-NEXT:    vse64.v v9, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v2i64(<2 x i64> %data, ptr align 8 %p, <2 x i1> %mask)
  ret void
}

define void @test_compresstore_v4i64(ptr %p, <4 x i1> %mask, <4 x i64> %data) {
; RV64-LABEL: test_compresstore_v4i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-NEXT:    vcompress.vm v10, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; RV64-NEXT:    vse64.v v10, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v4i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vcompress.vm v10, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; RV32-NEXT:    vse64.v v10, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v4i64(<4 x i64> %data, ptr align 8 %p, <4 x i1> %mask)
  ret void
}

define void @test_compresstore_v8i64(ptr %p, <8 x i1> %mask, <8 x i64> %data) {
; RV64-LABEL: test_compresstore_v8i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vcompress.vm v12, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vse64.v v12, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v8i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vcompress.vm v12, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vse64.v v12, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v8i64(<8 x i64> %data, ptr align 8 %p, <8 x i1> %mask)
  ret void
}

define void @test_compresstore_v16i64(ptr %p, <16 x i1> %mask, <16 x i64> %data) {
; RV64-LABEL: test_compresstore_v16i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vcompress.vm v16, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vse64.v v16, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v16i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vcompress.vm v16, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vse64.v v16, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v16i64(<16 x i64> %data, ptr align 8 %p, <16 x i1> %mask)
  ret void
}

define void @test_compresstore_v32i64(ptr %p, <32 x i1> %mask, <32 x i64> %data) {
; RV64-LABEL: test_compresstore_v32i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vcompress.vm v24, v8, v0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vse64.v v24, (a0)
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV64-NEXT:    vslidedown.vi v24, v0, 2
; RV64-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; RV64-NEXT:    vmv.x.s a1, v0
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vcompress.vm v8, v16, v24
; RV64-NEXT:    zext.h a1, a1
; RV64-NEXT:    cpopw a1, a1
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vcpop.m a1, v24
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
;
; RV32-LABEL: test_compresstore_v32i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vcompress.vm v24, v8, v0
; RV32-NEXT:    vcpop.m a1, v0
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vse64.v v24, (a0)
; RV32-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV32-NEXT:    vslidedown.vi v24, v0, 2
; RV32-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; RV32-NEXT:    vmv.x.s a1, v0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vcompress.vm v8, v16, v24
; RV32-NEXT:    zext.h a1, a1
; RV32-NEXT:    cpop a1, a1
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vcpop.m a1, v24
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    ret
entry:
  tail call void @llvm.masked.compressstore.v32i64(<32 x i64> %data, ptr align 8 %p, <32 x i1> %mask)
  ret void
}

declare void @llvm.masked.compressstore.v1i8(<1 x i8>, ptr, <1 x i1>)
declare void @llvm.masked.compressstore.v2i8(<2 x i8>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4i8(<4 x i8>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8i8(<8 x i8>, ptr, <8 x i1>)
declare void @llvm.masked.compressstore.v16i8(<16 x i8>, ptr, <16 x i1>)
declare void @llvm.masked.compressstore.v32i8(<32 x i8>, ptr, <32 x i1>)
declare void @llvm.masked.compressstore.v64i8(<64 x i8>, ptr, <64 x i1>)
declare void @llvm.masked.compressstore.v128i8(<128 x i8>, ptr, <128 x i1>)
declare void @llvm.masked.compressstore.v256i8(<256 x i8>, ptr, <256 x i1>)

declare void @llvm.masked.compressstore.v1i16(<1 x i16>, ptr, <1 x i1>)
declare void @llvm.masked.compressstore.v2i16(<2 x i16>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4i16(<4 x i16>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8i16(<8 x i16>, ptr, <8 x i1>)
declare void @llvm.masked.compressstore.v16i16(<16 x i16>, ptr, <16 x i1>)
declare void @llvm.masked.compressstore.v32i16(<32 x i16>, ptr, <32 x i1>)
declare void @llvm.masked.compressstore.v64i16(<64 x i16>, ptr, <64 x i1>)
declare void @llvm.masked.compressstore.v128i16(<128 x i16>, ptr, <128 x i1>)

declare void @llvm.masked.compressstore.v1i32(<1 x i32>, ptr, <1 x i1>)
declare void @llvm.masked.compressstore.v2i32(<2 x i32>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4i32(<4 x i32>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8i32(<8 x i32>, ptr, <8 x i1>)
declare void @llvm.masked.compressstore.v16i32(<16 x i32>, ptr, <16 x i1>)
declare void @llvm.masked.compressstore.v32i32(<32 x i32>, ptr, <32 x i1>)
declare void @llvm.masked.compressstore.v64i32(<64 x i32>, ptr, <64 x i1>)

declare void @llvm.masked.compressstore.v1i64(<1 x i64>, ptr, <1 x i1>)
declare void @llvm.masked.compressstore.v2i64(<2 x i64>, ptr, <2 x i1>)
declare void @llvm.masked.compressstore.v4i64(<4 x i64>, ptr, <4 x i1>)
declare void @llvm.masked.compressstore.v8i64(<8 x i64>, ptr, <8 x i1>)
declare void @llvm.masked.compressstore.v16i64(<16 x i64>, ptr, <16 x i1>)
declare void @llvm.masked.compressstore.v32i64(<32 x i64>, ptr, <32 x i1>)
