; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -global-isel -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32

define i16 @constant_fold_barrier_i16(i16 %x, i16 %y) {
; RV32-LABEL: constant_fold_barrier_i16:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 1
; RV32-NEXT:    slli a1, a1, 11
; RV32-NEXT:    and a0, a0, a1
; RV32-NEXT:    addi a1, a1, 289
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    ret
entry:
  %and = and i16 %x, 2048
  %or = or i16 %and, 2337
  ret i16 %or
}

define void @constant_fold_barrier_i128(ptr %p) {
; RV32-LABEL: constant_fold_barrier_i128:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    li a1, 1
; RV32-NEXT:    lw a2, 0(a0)
; RV32-NEXT:    lw a3, 4(a0)
; RV32-NEXT:    lw a4, 8(a0)
; RV32-NEXT:    lw a5, 12(a0)
; RV32-NEXT:    slli a1, a1, 11
; RV32-NEXT:    and a2, a2, a1
; RV32-NEXT:    add a2, a2, a1
; RV32-NEXT:    sltu a1, a2, a1
; RV32-NEXT:    mv a6, a1
; RV32-NEXT:    seqz a7, a1
; RV32-NEXT:    and a1, a7, a1
; RV32-NEXT:    mv a7, a1
; RV32-NEXT:    seqz a3, a1
; RV32-NEXT:    and a1, a3, a1
; RV32-NEXT:    sw a2, 0(a0)
; RV32-NEXT:    sw a6, 4(a0)
; RV32-NEXT:    sw a7, 8(a0)
; RV32-NEXT:    sw a1, 12(a0)
; RV32-NEXT:    ret
entry:
  %x = load i128, ptr %p
  %and = and i128 %x, 2048
  %add = add i128 %and, 2048
  store i128 %add, ptr %p
  ret void
}
