; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_35 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 | %ptxas-verify %}

declare i64 @llvm.nvvm.rotate.b64(i64, i32)
declare i64 @llvm.nvvm.rotate.right.b64(i64, i32)

define i64 @rotate64(i64 %a, i32 %b) {
; CHECK-LABEL: rotate64(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [rotate64_param_0];
; CHECK-NEXT:    mov.b64 {%r1, %r2}, %rd1;
; CHECK-NEXT:    shf.l.wrap.b32 %r3, %r1, %r2, 3;
; CHECK-NEXT:    shf.l.wrap.b32 %r4, %r2, %r1, 3;
; CHECK-NEXT:    mov.b64 %rd2, {%r4, %r3};
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = tail call i64 @llvm.nvvm.rotate.b64(i64 %a, i32 3)
  ret i64 %val
}

define i64 @rotateright64(i64 %a, i32 %b) {
; CHECK-LABEL: rotateright64(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [rotateright64_param_0];
; CHECK-NEXT:    mov.b64 {%r1, %r2}, %rd1;
; CHECK-NEXT:    shf.r.wrap.b32 %r3, %r2, %r1, 3;
; CHECK-NEXT:    shf.r.wrap.b32 %r4, %r1, %r2, 3;
; CHECK-NEXT:    mov.b64 %rd2, {%r4, %r3};
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = tail call i64 @llvm.nvvm.rotate.right.b64(i64 %a, i32 3)
  ret i64 %val
}
