; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lasx,-frecipe < %s | FileCheck %s --check-prefix=FAULT
; RUN: llc --mtriple=loongarch64 --mattr=+lasx,+frecipe < %s | FileCheck %s

;; 1.0 / (fsqrt vec)
define void @one_div_sqrt_v8f32(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_div_sqrt_v8f32:
; FAULT:       # %bb.0: # %entry
; FAULT-NEXT:    xvld $xr0, $a1, 0
; FAULT-NEXT:    xvfrsqrt.s $xr0, $xr0
; FAULT-NEXT:    xvst $xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: one_div_sqrt_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a1, 0
; CHECK-NEXT:    xvfrsqrte.s	$xr1, $xr0
; CHECK-NEXT:    xvfmul.s	$xr1, $xr0, $xr1
; CHECK-NEXT:    xvfmul.s	$xr0, $xr0, $xr1
; CHECK-NEXT:    lu12i.w	$a1, -261120
; CHECK-NEXT:    xvreplgr2vr.w	$xr2, $a1
; CHECK-NEXT:    xvfmadd.s	$xr0, $xr0, $xr1, $xr2
; CHECK-NEXT:    lu12i.w	$a1, -266240
; CHECK-NEXT:    xvreplgr2vr.w	$xr2, $a1
; CHECK-NEXT:    xvfmul.s	$xr1, $xr1, $xr2
; CHECK-NEXT:    xvfmul.s	$xr0, $xr1, $xr0
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x float>, ptr %a0, align 16
  %sqrt = call fast <8 x float> @llvm.sqrt.v8f32 (<8 x float> %v0)
  %div = fdiv fast <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, %sqrt
  store <8 x float> %div, ptr %res, align 16
  ret void
}

define void @one_div_sqrt_v4f64(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_div_sqrt_v4f64:
; FAULT:       # %bb.0: # %entry
; FAULT-NEXT:    xvld $xr0, $a1, 0
; FAULT-NEXT:    xvfrsqrt.d $xr0, $xr0
; FAULT-NEXT:    xvst $xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: one_div_sqrt_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a1, 0
; CHECK-NEXT:    xvfrsqrte.d	$xr1, $xr0
; CHECK-NEXT:    xvfmul.d	$xr1, $xr0, $xr1
; CHECK-NEXT:    xvfmul.d	$xr2, $xr0, $xr1
; CHECK-NEXT:    ori	$a1, $zero, 0
; CHECK-NEXT:    lu32i.d	$a1, -524288
; CHECK-NEXT:    lu52i.d	$a1, $a1, -1024
; CHECK-NEXT:    xvreplgr2vr.d	$xr3, $a1
; CHECK-NEXT:    xvfmadd.d	$xr2, $xr2, $xr1, $xr3
; CHECK-NEXT:    lu52i.d	$a1, $zero, -1026
; CHECK-NEXT:    xvreplgr2vr.d	$xr4, $a1
; CHECK-NEXT:    xvfmul.d	$xr1, $xr1, $xr4
; CHECK-NEXT:    xvfmul.d	$xr1, $xr1, $xr2
; CHECK-NEXT:    xvfmul.d	$xr0, $xr0, $xr1
; CHECK-NEXT:    xvfmadd.d	$xr0, $xr0, $xr1, $xr3
; CHECK-NEXT:    xvfmul.d	$xr1, $xr1, $xr4
; CHECK-NEXT:    xvfmul.d	$xr0, $xr1, $xr0
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0, align 16
  %sqrt = call fast <4 x double> @llvm.sqrt.v4f64 (<4 x double> %v0)
  %div = fdiv fast <4 x double> <double 1.0, double 1.0, double 1.0, double 1.0>, %sqrt
  store <4 x double> %div, ptr %res, align 16
  ret void
}

declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)
