; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=tahiti %s -o - | FileCheck %s

; After dead code elimination, that buffer load should be eliminated finally
; after dead lane detection.
define amdgpu_kernel void @foo() {
; CHECK-LABEL: foo:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:   ; %bb.1:                                ; %LeafBlock1
; CHECK-NEXT:    s_cmp_eq_u32 s0, 10
; CHECK-NEXT:    s_cbranch_scc1 .LBB0_3
; CHECK-NEXT:  ; %bb.2:
; CHECK-NEXT:    s_mov_b32 s3, 0xf000
; CHECK-NEXT:    s_mov_b32 s2, -1
; CHECK-NEXT:    v_mov_b32_e32 v0, 0
; CHECK-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CHECK-NEXT:    s_endpgm
; CHECK-NEXT: .LBB0_3:
entry:
  switch i8 poison, label %foo.exit [
    i8 4, label %sw.bb4
    i8 10, label %sw.bb10
  ]

sw.bb4:
  %x = load i64, ptr addrspace(1) poison, align 8
  %c = sitofp i64 %x to float
  %v = insertelement <2 x float> <float poison, float 0.000000e+00>, float %c, i32 0
  br label %foo.exit

sw.bb10:
  unreachable

foo.exit:
  %agg = phi <2 x float> [ %v, %sw.bb4 ], [ zeroinitializer, %entry ]
  %s = extractelement <2 x float> %agg, i32 1
  store float %s, ptr addrspace(1) poison, align 4
  ret void
}
