; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

; ScalarEvolution should be able to use nsw information to prove that
; this loop has a finite trip count.

define void @le(i64 %n, ptr nocapture %p) nounwind {
; CHECK-LABEL: 'le'
; CHECK-NEXT:  Determining loop execution counts for: @le
; CHECK-NEXT:  Loop %for.body: backedge-taken count is %n
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i64 9223372036854775807
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is %n
; CHECK-NEXT:  Loop %for.body: Trip multiple is 1
;
entry:
  %cmp6 = icmp slt i64 %n, 0                      ; <i1> [#uses=1]
  br i1 %cmp6, label %for.end, label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i = phi i64 [ %i.next, %for.body ], [ 0, %entry ] ; <i64> [#uses=2]
  %arrayidx = getelementptr double, ptr %p, i64 %i    ; <ptr> [#uses=2]
  %t4 = load double, ptr %arrayidx                    ; <double> [#uses=1]
  %mul = fmul double %t4, 2.200000e+00            ; <double> [#uses=1]
  store double %mul, ptr %arrayidx
  %i.next = add nsw i64 %i, 1                     ; <i64> [#uses=2]
  %cmp = icmp sgt i64 %i.next, %n                 ; <i1> [#uses=1]
  br i1 %cmp, label %for.end, label %for.body

for.end:                                          ; preds = %for.body, %entry
  ret void
}
