; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"

define void @runtime_checks_with_symbolic_max_btc_neg_1(ptr %P, ptr %S, i32 %x, i32 %y) {
; CHECK-LABEL: 'runtime_checks_with_symbolic_max_btc_neg_1'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.iv = getelementptr inbounds i32, ptr %P, i32 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:        ptr %S
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: ((4 * %y) + %P) High: inttoptr (i32 -1 to ptr))
; CHECK-NEXT:            Member: {((4 * %y) + %P),+,4}<%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %S High: (4 + %S))
; CHECK-NEXT:            Member: %S
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop ]
  %gep.iv = getelementptr inbounds i32, ptr %P, i32 %iv
  %l = load i32, ptr %S
  store i32 %l, ptr %gep.iv, align 4
  %iv.next = add nsw i32 %iv, 1
  %c.2 = icmp slt i32 %iv.next, %l
  br i1 %c.2, label %loop, label %exit

exit:
  ret void
}

define void @runtime_check_with_symbolic_max_btc_neg_2(ptr %P, ptr %S, i32 %x, i32 %y) {
; CHECK-LABEL: 'runtime_check_with_symbolic_max_btc_neg_2'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.iv = getelementptr inbounds i32, ptr %P, i32 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:        ptr %S
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: ((4 * %y) + %P) High: inttoptr (i32 -1 to ptr))
; CHECK-NEXT:            Member: {((4 * %y) + %P),+,4}<%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %S High: (4 + %S))
; CHECK-NEXT:            Member: %S
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop ]
  %gep.iv = getelementptr inbounds i32, ptr %P, i32 %iv
  %l = load i32, ptr %S
  store i32 %l, ptr %gep.iv, align 4
  %iv.next = add nsw i32 %iv, 1
  %a = and i32 %l, -2
  %c.2 = icmp slt i32 %iv.next, %a
  br i1 %c.2, label %loop, label %exit

exit:
  ret void
}

define i32 @check_no_dep_via_bounds_compare_symbolic_max_btc_neg_1(ptr %P, i32 %x, i32 %y) {
; CHECK-LABEL: 'check_no_dep_via_bounds_compare_symbolic_max_btc_neg_1'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Report: unsafe dependent memory operations in loop. Use #pragma clang loop distribute(enable) to allow loop distribution to attempt to isolate the offending operations into a separate loop
; CHECK-NEXT:  Unknown data dependence.
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:        Unknown:
; CHECK-NEXT:            store i64 0, ptr %gep.iv, align 4 ->
; CHECK-NEXT:            %l.2 = load i32, ptr %gep.P.4, align 4
; CHECK-EMPTY:
; CHECK-NEXT:        Unknown:
; CHECK-NEXT:            %l = load i32, ptr %gep.iv, align 4 ->
; CHECK-NEXT:            store i64 0, ptr %gep.iv, align 4
; CHECK-EMPTY:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  %gep.P.4 = getelementptr inbounds nuw i8, ptr %P, i32 4
  %gep.P.8 = getelementptr inbounds nuw i8, ptr %P, i32 8
  br label %loop

loop:
  %1 = phi i32 [ %x, %entry ], [ %sel, %loop.latch ]
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop.latch ]
  %gep.iv = getelementptr inbounds i64, ptr %gep.P.8, i32 %iv
  %l = load i32, ptr %gep.iv, align 4
  %c.1 = icmp eq i32 %l, 3
  br i1 %c.1, label %loop.latch, label %if.then

if.then:                                          ; preds = %for.body
  store i64 0, ptr %gep.iv, align 4
  %l.2 = load i32, ptr %gep.P.4
  br label %loop.latch

loop.latch:
  %sel = phi i32 [ %l.2, %if.then ], [ %1, %loop ]
  %iv.next = add nsw i32 %iv, 1
  %c.2 = icmp slt i32 %iv.next, %sel
  br i1 %c.2, label %loop, label %exit

exit:
  %res = phi i32 [ %iv.next, %loop.latch ]
  ret i32 %res
}

; Evaluating at symbolic max BTC wraps around to a positive
; offset: (2 + (2 * %y) + %P).
define void @runtime_check_with_symbolic_max_wraps_to_positive_offset(ptr %P, ptr %S, i32 %x, i32 %y) {
; CHECK-LABEL: 'runtime_check_with_symbolic_max_wraps_to_positive_offset'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.iv = getelementptr inbounds i16, ptr %P, i32 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:        ptr %S
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: ((2 * %y) + %P) High: inttoptr (i32 -1 to ptr))
; CHECK-NEXT:            Member: {((2 * %y) + %P),+,2}<%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %S High: (4 + %S))
; CHECK-NEXT:            Member: %S
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop ]
  %gep.iv = getelementptr inbounds i16 , ptr %P, i32 %iv
  %l = load i32, ptr %S
  store i16 0, ptr %gep.iv, align 4
  %iv.next = add nsw i32 %iv, 1
  %a = and i32 %l, 2147483648
  %c.2 = icmp slt i32 %iv.next, %a
  br i1 %c.2, label %loop, label %exit

exit:
  ret void
}
