# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x280 -mattr='+xsfvfnrclipxfqf' -iterations=1 -instruction-tables=full %s | \
# RUN:   FileCheck %s

vsetvli a0, zero, e8, mf8, ta, ma
sf.vfnrclip.xu.f.qf v4, v8, fa2

vsetvli a0, zero, e8, mf4, ta, ma
sf.vfnrclip.xu.f.qf v4, v8, fa2

vsetvli a0, zero, e8, mf2, ta, ma
sf.vfnrclip.xu.f.qf v4, v8, fa2

vsetvli a0, zero, e8, m1, ta, ma
sf.vfnrclip.xu.f.qf v4, v8, fa2

vsetvli a0, zero, e8, m2, ta, ma
sf.vfnrclip.xu.f.qf v4, v8, fa2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN512SiFive7FDiv:1
# CHECK-NEXT: [1]   - VLEN512SiFive7IDiv:1
# CHECK-NEXT: [2]   - VLEN512SiFive7PipeA:1
# CHECK-NEXT: [3]   - VLEN512SiFive7PipeAB:2 VLEN512SiFive7PipeA, VLEN512SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN512SiFive7PipeB:1
# CHECK-NEXT: [5]   - VLEN512SiFive7VA:1
# CHECK-NEXT: [6]   - VLEN512SiFive7VCQ:1
# CHECK-NEXT: [7]   - VLEN512SiFive7VL:1
# CHECK-NEXT: [8]   - VLEN512SiFive7VS:1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a0, zero, e8, mf8, ta, ma
# CHECK-NEXT:  1      7     1.00                         7     VLEN512SiFive7VA[1,2],VLEN512SiFive7VCQ    SF_VFNRCLIP_XU_F_QF        sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a0, zero, e8, mf4, ta, ma
# CHECK-NEXT:  1      8     2.00                         8     VLEN512SiFive7VA[1,3],VLEN512SiFive7VCQ    SF_VFNRCLIP_XU_F_QF        sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a0, zero, e8, mf2, ta, ma
# CHECK-NEXT:  1      10    4.00                         10    VLEN512SiFive7VA[1,5],VLEN512SiFive7VCQ    SF_VFNRCLIP_XU_F_QF        sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a0, zero, e8, m1, ta, ma
# CHECK-NEXT:  1      13    8.00                         13    VLEN512SiFive7VA[1,9],VLEN512SiFive7VCQ    SF_VFNRCLIP_XU_F_QF        sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a0, zero, e8, m2, ta, ma
# CHECK-NEXT:  1      19    16.00                        19    VLEN512SiFive7VA[1,17],VLEN512SiFive7VCQ   SF_VFNRCLIP_XU_F_QF        sf.vfnrclip.xu.f.qf	v4, v8, fa2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN512SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN512SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN512SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN512SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN512SiFive7VA
# CHECK-NEXT: [5]   - VLEN512SiFive7VCQ
# CHECK-NEXT: [6]   - VLEN512SiFive7VL
# CHECK-NEXT: [7]   - VLEN512SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -     5.00    -     36.00  5.00    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	a0, zero, e8, mf8, ta, ma
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	a0, zero, e8, mf4, ta, ma
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	a0, zero, e8, mf2, ta, ma
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	a0, zero, e8, m1, ta, ma
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     sf.vfnrclip.xu.f.qf	v4, v8, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	a0, zero, e8, m2, ta, ma
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     sf.vfnrclip.xu.f.qf	v4, v8, fa2
