; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare i32 @llvm.cttz.i32(i32, i1)

define i32 @test_cttz_lshr(i32 %x) {
; CHECK-LABEL: define i32 @test_cttz_lshr(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[X]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr exact i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[SH]]
;
  %cttz = call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %sh = lshr i32 %x, %cttz
  ret i32 %sh
}

define i32 @test_cttz_ashr(i32 %x) {
; CHECK-LABEL: define i32 @test_cttz_ashr(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[X]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = ashr exact i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[SH]]
;
  %cttz = call i32 @llvm.cttz.i32(i32 %x, i1 true)
  %sh = ashr i32 %x, %cttz
  ret i32 %sh
}

define i32 @test_cttz_diff_operand(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @test_cttz_diff_operand(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[SH]]
;
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 true)
  %sh = lshr i32 %x, %cttz
  ret i32 %sh
}

