; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test 128-bit comparisons in vector registers on z13
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 -verify-machineinstrs | FileCheck %s

; Equality comparison.
define i64 @f1(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vceqgs %v0, %v1, %v0
; CHECK-NEXT:    locgrnhe %r4, %r5
; CHECK-NEXT:    lgr %r2, %r4
; CHECK-NEXT:    br %r14
  %cond = icmp eq i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Inequality comparison.
define i64 @f2(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vceqgs %v0, %v1, %v0
; CHECK-NEXT:    locgre %r4, %r5
; CHECK-NEXT:    lgr %r2, %r4
; CHECK-NEXT:    br %r14
  %cond = icmp ne i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Signed greater-than comparison.
define i64 @f3(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    jlh .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    locgrl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp sgt i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Signed less-than comparison.
define i64 @f4(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r2), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    jlh .LBB3_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB3_2:
; CHECK-NEXT:    locgrl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp slt i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Signed greater-or-equal comparison.
define i64 @f5(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r2), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    jlh .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    locgrnl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp sge i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Signed less-or-equal comparison.
define i64 @f6(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vecg %v0, %v1
; CHECK-NEXT:    jlh .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    locgrnl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp sle i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Unsigned greater-than comparison.
define i64 @f7(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    jlh .LBB6_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB6_2:
; CHECK-NEXT:    locgrl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp ugt i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Unsigned less-than comparison.
define i64 @f8(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r2), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    jlh .LBB7_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    locgrl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp ult i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Unsigned greater-or-equal comparison.
define i64 @f9(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r2), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    jlh .LBB8_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB8_2:
; CHECK-NEXT:    locgrnl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp uge i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Unsigned less-or-equal comparison.
define i64 @f10(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    veclg %v0, %v1
; CHECK-NEXT:    jlh .LBB9_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vchlgs %v0, %v1, %v0
; CHECK-NEXT:  .LBB9_2:
; CHECK-NEXT:    locgrnl %r5, %r4
; CHECK-NEXT:    lgr %r2, %r5
; CHECK-NEXT:    br %r14
  %cond = icmp ule i128 %value1, %value2
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Use VTM for "x & y == 0" comparison.
define i64 @f11(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vtm %v1, %v0
; CHECK-NEXT:    locgrnhe %r4, %r5
; CHECK-NEXT:    lgr %r2, %r4
; CHECK-NEXT:    br %r14
  %and = and i128 %value1, %value2
  %cond = icmp eq i128 %and, 0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Use VTM for "x & y != 0" comparison.
define i64 @f12(i128 %value1, i128 %value2, i64 %a, i64 %b) {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vtm %v1, %v0
; CHECK-NEXT:    locgre %r4, %r5
; CHECK-NEXT:    lgr %r2, %r4
; CHECK-NEXT:    br %r14
  %and = and i128 %value1, %value2
  %cond = icmp ne i128 %and, 0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

; Select between i128 values.
define i128 @f13(i64 %value1, i64 %value2, i128 %a, i128 %b) {
; CHECK-LABEL: f13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    cgrje %r3, %r4, .LBB12_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vl %v1, 0(%r6), 3
; CHECK-NEXT:    vaq %v0, %v0, %v1
; CHECK-NEXT:  .LBB12_2:
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cond = icmp eq i64 %value1, %value2
  %sum = add i128 %a, %b
  %res = select i1 %cond, i128 %a, i128 %sum
  ret i128 %res
}

