; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -target-abi ilp32e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IF-ILP32E

; Exercises the ILP32E calling convention code in the case that f32 is a legal
; type. As well as testing that lowering is correct, these tests also aim to
; check that floating point load/store or integer load/store is chosen
; optimally when floats are passed on the stack.

define float @onstack_f32_noop(i64 %a, i64 %b, i64 %c, i64 %d, float %e, float %f) nounwind {
; RV32IF-ILP32E-LABEL: onstack_f32_noop:
; RV32IF-ILP32E:       # %bb.0:
; RV32IF-ILP32E-NEXT:    lw a0, 12(sp)
; RV32IF-ILP32E-NEXT:    ret
  ret float %f
}

define float @onstack_f32_fadd(i64 %a, i64 %b, i64 %c, i64 %d, float %e, float %f) nounwind {
; RV32IF-ILP32E-LABEL: onstack_f32_fadd:
; RV32IF-ILP32E:       # %bb.0:
; RV32IF-ILP32E-NEXT:    flw fa5, 12(sp)
; RV32IF-ILP32E-NEXT:    flw fa4, 8(sp)
; RV32IF-ILP32E-NEXT:    fadd.s fa5, fa4, fa5
; RV32IF-ILP32E-NEXT:    fmv.x.w a0, fa5
; RV32IF-ILP32E-NEXT:    ret
  %1 = fadd float %e, %f
  ret float %1
}

define float @caller_onstack_f32_noop(float %a) nounwind {
; RV32IF-ILP32E-LABEL: caller_onstack_f32_noop:
; RV32IF-ILP32E:       # %bb.0:
; RV32IF-ILP32E-NEXT:    addi sp, sp, -20
; RV32IF-ILP32E-NEXT:    sw ra, 16(sp) # 4-byte Folded Spill
; RV32IF-ILP32E-NEXT:    mv a1, a0
; RV32IF-ILP32E-NEXT:    lui a3, 264704
; RV32IF-ILP32E-NEXT:    li a5, 4
; RV32IF-ILP32E-NEXT:    li a0, 1
; RV32IF-ILP32E-NEXT:    li a2, 2
; RV32IF-ILP32E-NEXT:    li a4, 3
; RV32IF-ILP32E-NEXT:    sw a5, 0(sp)
; RV32IF-ILP32E-NEXT:    sw zero, 4(sp)
; RV32IF-ILP32E-NEXT:    sw a3, 8(sp)
; RV32IF-ILP32E-NEXT:    sw a1, 12(sp)
; RV32IF-ILP32E-NEXT:    li a1, 0
; RV32IF-ILP32E-NEXT:    li a3, 0
; RV32IF-ILP32E-NEXT:    li a5, 0
; RV32IF-ILP32E-NEXT:    call onstack_f32_noop
; RV32IF-ILP32E-NEXT:    lw ra, 16(sp) # 4-byte Folded Reload
; RV32IF-ILP32E-NEXT:    addi sp, sp, 20
; RV32IF-ILP32E-NEXT:    ret
  %1 = call float @onstack_f32_noop(i64 1, i64 2, i64 3, i64 4, float 5.0, float %a)
  ret float %1
}

define float @caller_onstack_f32_fadd(float %a, float %b) nounwind {
; RV32IF-ILP32E-LABEL: caller_onstack_f32_fadd:
; RV32IF-ILP32E:       # %bb.0:
; RV32IF-ILP32E-NEXT:    addi sp, sp, -20
; RV32IF-ILP32E-NEXT:    sw ra, 16(sp) # 4-byte Folded Spill
; RV32IF-ILP32E-NEXT:    fmv.w.x fa5, a1
; RV32IF-ILP32E-NEXT:    fmv.w.x fa4, a0
; RV32IF-ILP32E-NEXT:    fadd.s fa3, fa4, fa5
; RV32IF-ILP32E-NEXT:    fsub.s fa5, fa5, fa4
; RV32IF-ILP32E-NEXT:    li a1, 4
; RV32IF-ILP32E-NEXT:    li a0, 1
; RV32IF-ILP32E-NEXT:    li a2, 2
; RV32IF-ILP32E-NEXT:    li a4, 3
; RV32IF-ILP32E-NEXT:    sw a1, 0(sp)
; RV32IF-ILP32E-NEXT:    sw zero, 4(sp)
; RV32IF-ILP32E-NEXT:    fsw fa3, 8(sp)
; RV32IF-ILP32E-NEXT:    fsw fa5, 12(sp)
; RV32IF-ILP32E-NEXT:    li a1, 0
; RV32IF-ILP32E-NEXT:    li a3, 0
; RV32IF-ILP32E-NEXT:    li a5, 0
; RV32IF-ILP32E-NEXT:    call onstack_f32_noop
; RV32IF-ILP32E-NEXT:    lw ra, 16(sp) # 4-byte Folded Reload
; RV32IF-ILP32E-NEXT:    addi sp, sp, 20
; RV32IF-ILP32E-NEXT:    ret
  %1 = fadd float %a, %b
  %2 = fsub float %b, %a
  %3 = call float @onstack_f32_noop(i64 1, i64 2, i64 3, i64 4, float %1, float %2)
  ret float %3
}
