; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=aarch64 -mattr=+neon |\
; RUN:   FileCheck %s --check-prefixes=CHECK-i32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=aarch64 -mattr=+neon |\
; RUN:   FileCheck %s --check-prefixes=CHECK-i64,CHECK-i64-SD
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=aarch64 -mattr=+neon \
; RUN:   -global-isel -global-isel-abort=2 2>&1 |\
; RUN:   FileCheck %s --check-prefixes=CHECK-i32,CHECK-i32-GI
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=aarch64 -mattr=+neon \
; RUN:   -global-isel -global-isel-abort=2 2>&1 |\
; RUN:   FileCheck %s --check-prefixes=CHECK-i64,CHECK-i64-GI

; CHECK-i32-GI:       warning: Instruction selection used fallback path for lrint_v1f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v2f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f16
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v1f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v2f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f32
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v1f64
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v2f64
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f64
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f64
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f64
; CHECK-i32-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f64

; CHECK-i64-GI:       warning: Instruction selection used fallback path for lrint_v2f16
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f16
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f16
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f16
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f16
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v2f32
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f32
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f32
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f32
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f32
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v2f64
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v4f64
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v8f64
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v16f64
; CHECK-i64-GI-NEXT:  warning: Instruction selection used fallback path for lrint_v32f64

define <1 x iXLen> @lrint_v1f16(<1 x half> %x) {
; CHECK-i32-LABEL: lrint_v1f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    fcvt s0, h0
; CHECK-i32-NEXT:    frintx s0, s0
; CHECK-i32-NEXT:    fcvtzs w8, s0
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v1f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    fcvtzs x8, s0
; CHECK-i64-NEXT:    fmov d0, x8
; CHECK-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f16(<1 x half> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f16(<1 x half>)

define <2 x iXLen> @lrint_v2f16(<2 x half> %x) {
; CHECK-i32-LABEL: lrint_v2f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-i32-NEXT:    mov h1, v0.h[1]
; CHECK-i32-NEXT:    fcvt s0, h0
; CHECK-i32-NEXT:    fcvt s1, h1
; CHECK-i32-NEXT:    frintx s0, s0
; CHECK-i32-NEXT:    frintx s1, s1
; CHECK-i32-NEXT:    fcvtzs w8, s0
; CHECK-i32-NEXT:    fcvtzs w9, s1
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    mov v0.s[1], w9
; CHECK-i32-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v2f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-i64-NEXT:    mov h1, v0.h[1]
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    fcvtzs x8, s0
; CHECK-i64-NEXT:    fcvtzs x9, s1
; CHECK-i64-NEXT:    fmov d0, x8
; CHECK-i64-NEXT:    mov v0.d[1], x9
; CHECK-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f16(<2 x half> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f16(<2 x half>)

define <4 x iXLen> @lrint_v4f16(<4 x half> %x) {
; CHECK-i32-LABEL: lrint_v4f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-i32-NEXT:    mov h1, v0.h[1]
; CHECK-i32-NEXT:    fcvt s2, h0
; CHECK-i32-NEXT:    mov h3, v0.h[2]
; CHECK-i32-NEXT:    mov h0, v0.h[3]
; CHECK-i32-NEXT:    fcvt s1, h1
; CHECK-i32-NEXT:    frintx s2, s2
; CHECK-i32-NEXT:    fcvt s3, h3
; CHECK-i32-NEXT:    frintx s1, s1
; CHECK-i32-NEXT:    fcvtzs w8, s2
; CHECK-i32-NEXT:    fcvt s2, h0
; CHECK-i32-NEXT:    fcvtzs w9, s1
; CHECK-i32-NEXT:    frintx s1, s3
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    mov v0.s[1], w9
; CHECK-i32-NEXT:    fcvtzs w8, s1
; CHECK-i32-NEXT:    frintx s1, s2
; CHECK-i32-NEXT:    mov v0.s[2], w8
; CHECK-i32-NEXT:    fcvtzs w8, s1
; CHECK-i32-NEXT:    mov v0.s[3], w8
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v4f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-i64-NEXT:    mov h1, v0.h[2]
; CHECK-i64-NEXT:    mov h2, v0.h[1]
; CHECK-i64-NEXT:    mov h3, v0.h[3]
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    fcvt s2, h2
; CHECK-i64-NEXT:    fcvt s3, h3
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    frintx s2, s2
; CHECK-i64-NEXT:    frintx s3, s3
; CHECK-i64-NEXT:    fcvtzs x8, s0
; CHECK-i64-NEXT:    fcvtzs x9, s1
; CHECK-i64-NEXT:    fcvtzs x10, s2
; CHECK-i64-NEXT:    fcvtzs x11, s3
; CHECK-i64-NEXT:    fmov d0, x8
; CHECK-i64-NEXT:    fmov d1, x9
; CHECK-i64-NEXT:    mov v0.d[1], x10
; CHECK-i64-NEXT:    mov v1.d[1], x11
; CHECK-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f16(<4 x half> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f16(<4 x half>)

define <8 x iXLen> @lrint_v8f16(<8 x half> %x) {
; CHECK-i32-LABEL: lrint_v8f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-i32-NEXT:    mov h3, v0.h[1]
; CHECK-i32-NEXT:    fcvt s6, h0
; CHECK-i32-NEXT:    mov h4, v0.h[2]
; CHECK-i32-NEXT:    mov h0, v0.h[3]
; CHECK-i32-NEXT:    mov h2, v1.h[1]
; CHECK-i32-NEXT:    fcvt s5, h1
; CHECK-i32-NEXT:    mov h7, v1.h[2]
; CHECK-i32-NEXT:    fcvt s3, h3
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    fcvt s4, h4
; CHECK-i32-NEXT:    mov h1, v1.h[3]
; CHECK-i32-NEXT:    fcvt s2, h2
; CHECK-i32-NEXT:    frintx s5, s5
; CHECK-i32-NEXT:    fcvt s7, h7
; CHECK-i32-NEXT:    frintx s3, s3
; CHECK-i32-NEXT:    fcvtzs w9, s6
; CHECK-i32-NEXT:    frintx s4, s4
; CHECK-i32-NEXT:    frintx s2, s2
; CHECK-i32-NEXT:    fcvtzs w8, s5
; CHECK-i32-NEXT:    fcvt s5, h1
; CHECK-i32-NEXT:    fcvtzs w11, s3
; CHECK-i32-NEXT:    fcvt s3, h0
; CHECK-i32-NEXT:    fmov s0, w9
; CHECK-i32-NEXT:    fcvtzs w12, s4
; CHECK-i32-NEXT:    fcvtzs w10, s2
; CHECK-i32-NEXT:    frintx s2, s7
; CHECK-i32-NEXT:    fmov s1, w8
; CHECK-i32-NEXT:    mov v0.s[1], w11
; CHECK-i32-NEXT:    fcvtzs w8, s2
; CHECK-i32-NEXT:    mov v1.s[1], w10
; CHECK-i32-NEXT:    frintx s2, s3
; CHECK-i32-NEXT:    frintx s3, s5
; CHECK-i32-NEXT:    mov v0.s[2], w12
; CHECK-i32-NEXT:    mov v1.s[2], w8
; CHECK-i32-NEXT:    fcvtzs w9, s2
; CHECK-i32-NEXT:    fcvtzs w8, s3
; CHECK-i32-NEXT:    mov v0.s[3], w9
; CHECK-i32-NEXT:    mov v1.s[3], w8
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v8f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    mov h4, v0.h[2]
; CHECK-i64-NEXT:    mov h3, v0.h[1]
; CHECK-i64-NEXT:    mov h7, v0.h[3]
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    mov h2, v1.h[2]
; CHECK-i64-NEXT:    mov h5, v1.h[1]
; CHECK-i64-NEXT:    mov h6, v1.h[3]
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    fcvt s4, h4
; CHECK-i64-NEXT:    fcvt s3, h3
; CHECK-i64-NEXT:    fcvt s7, h7
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    fcvt s2, h2
; CHECK-i64-NEXT:    fcvt s5, h5
; CHECK-i64-NEXT:    fcvt s6, h6
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    frintx s4, s4
; CHECK-i64-NEXT:    frintx s3, s3
; CHECK-i64-NEXT:    frintx s7, s7
; CHECK-i64-NEXT:    fcvtzs x9, s0
; CHECK-i64-NEXT:    frintx s2, s2
; CHECK-i64-NEXT:    frintx s5, s5
; CHECK-i64-NEXT:    frintx s6, s6
; CHECK-i64-NEXT:    fcvtzs x8, s1
; CHECK-i64-NEXT:    fcvtzs x12, s4
; CHECK-i64-NEXT:    fcvtzs x11, s3
; CHECK-i64-NEXT:    fcvtzs x15, s7
; CHECK-i64-NEXT:    fmov d0, x9
; CHECK-i64-NEXT:    fcvtzs x10, s2
; CHECK-i64-NEXT:    fcvtzs x13, s5
; CHECK-i64-NEXT:    fcvtzs x14, s6
; CHECK-i64-NEXT:    fmov d2, x8
; CHECK-i64-NEXT:    fmov d1, x12
; CHECK-i64-NEXT:    mov v0.d[1], x11
; CHECK-i64-NEXT:    fmov d3, x10
; CHECK-i64-NEXT:    mov v2.d[1], x13
; CHECK-i64-NEXT:    mov v1.d[1], x15
; CHECK-i64-NEXT:    mov v3.d[1], x14
; CHECK-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f16(<8 x half> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f16(<8 x half>)

define <16 x iXLen> @lrint_v16f16(<16 x half> %x) {
; CHECK-i32-LABEL: lrint_v16f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-i32-NEXT:    ext v3.16b, v1.16b, v1.16b, #8
; CHECK-i32-NEXT:    mov h18, v0.h[1]
; CHECK-i32-NEXT:    mov h19, v1.h[1]
; CHECK-i32-NEXT:    fcvt s20, h0
; CHECK-i32-NEXT:    mov h21, v0.h[2]
; CHECK-i32-NEXT:    mov h0, v0.h[3]
; CHECK-i32-NEXT:    mov h4, v2.h[1]
; CHECK-i32-NEXT:    mov h5, v2.h[2]
; CHECK-i32-NEXT:    fcvt s6, h2
; CHECK-i32-NEXT:    fcvt s7, h3
; CHECK-i32-NEXT:    mov h16, v3.h[1]
; CHECK-i32-NEXT:    mov h17, v3.h[2]
; CHECK-i32-NEXT:    fcvt s18, h18
; CHECK-i32-NEXT:    fcvt s19, h19
; CHECK-i32-NEXT:    mov h2, v2.h[3]
; CHECK-i32-NEXT:    fcvt s4, h4
; CHECK-i32-NEXT:    fcvt s5, h5
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    frintx s7, s7
; CHECK-i32-NEXT:    fcvt s16, h16
; CHECK-i32-NEXT:    fcvt s17, h17
; CHECK-i32-NEXT:    frintx s18, s18
; CHECK-i32-NEXT:    fcvt s2, h2
; CHECK-i32-NEXT:    frintx s4, s4
; CHECK-i32-NEXT:    frintx s5, s5
; CHECK-i32-NEXT:    fcvtzs w8, s6
; CHECK-i32-NEXT:    fcvt s6, h1
; CHECK-i32-NEXT:    fcvtzs w9, s7
; CHECK-i32-NEXT:    mov h7, v1.h[2]
; CHECK-i32-NEXT:    frintx s16, s16
; CHECK-i32-NEXT:    fcvtzs w15, s18
; CHECK-i32-NEXT:    fcvtzs w10, s4
; CHECK-i32-NEXT:    frintx s4, s17
; CHECK-i32-NEXT:    fcvtzs w11, s5
; CHECK-i32-NEXT:    frintx s5, s20
; CHECK-i32-NEXT:    fcvt s17, h21
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    fcvtzs w12, s16
; CHECK-i32-NEXT:    frintx s16, s19
; CHECK-i32-NEXT:    fcvt s7, h7
; CHECK-i32-NEXT:    mov h19, v1.h[3]
; CHECK-i32-NEXT:    fmov s1, w8
; CHECK-i32-NEXT:    fcvtzs w13, s4
; CHECK-i32-NEXT:    mov h4, v3.h[3]
; CHECK-i32-NEXT:    fmov s3, w9
; CHECK-i32-NEXT:    fcvtzs w14, s5
; CHECK-i32-NEXT:    frintx s5, s17
; CHECK-i32-NEXT:    fcvtzs w16, s6
; CHECK-i32-NEXT:    fcvt s17, h0
; CHECK-i32-NEXT:    fcvtzs w8, s16
; CHECK-i32-NEXT:    frintx s6, s7
; CHECK-i32-NEXT:    fcvt s7, h19
; CHECK-i32-NEXT:    mov v1.s[1], w10
; CHECK-i32-NEXT:    mov v3.s[1], w12
; CHECK-i32-NEXT:    fcvt s4, h4
; CHECK-i32-NEXT:    fcvtzs w9, s5
; CHECK-i32-NEXT:    fmov s0, w14
; CHECK-i32-NEXT:    frintx s5, s2
; CHECK-i32-NEXT:    fmov s2, w16
; CHECK-i32-NEXT:    frintx s16, s17
; CHECK-i32-NEXT:    fcvtzs w10, s6
; CHECK-i32-NEXT:    frintx s6, s7
; CHECK-i32-NEXT:    mov v1.s[2], w11
; CHECK-i32-NEXT:    mov v3.s[2], w13
; CHECK-i32-NEXT:    mov v0.s[1], w15
; CHECK-i32-NEXT:    frintx s4, s4
; CHECK-i32-NEXT:    mov v2.s[1], w8
; CHECK-i32-NEXT:    fcvtzs w8, s5
; CHECK-i32-NEXT:    fcvtzs w12, s16
; CHECK-i32-NEXT:    mov v0.s[2], w9
; CHECK-i32-NEXT:    fcvtzs w9, s4
; CHECK-i32-NEXT:    mov v2.s[2], w10
; CHECK-i32-NEXT:    fcvtzs w10, s6
; CHECK-i32-NEXT:    mov v1.s[3], w8
; CHECK-i32-NEXT:    mov v0.s[3], w12
; CHECK-i32-NEXT:    mov v3.s[3], w9
; CHECK-i32-NEXT:    mov v2.s[3], w10
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v16f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    ext v3.16b, v1.16b, v1.16b, #8
; CHECK-i64-NEXT:    mov h17, v0.h[1]
; CHECK-i64-NEXT:    mov h19, v0.h[2]
; CHECK-i64-NEXT:    fcvt s18, h0
; CHECK-i64-NEXT:    mov h0, v0.h[3]
; CHECK-i64-NEXT:    mov h4, v2.h[1]
; CHECK-i64-NEXT:    mov h5, v2.h[2]
; CHECK-i64-NEXT:    fcvt s7, h3
; CHECK-i64-NEXT:    fcvt s6, h2
; CHECK-i64-NEXT:    mov h16, v3.h[2]
; CHECK-i64-NEXT:    mov h2, v2.h[3]
; CHECK-i64-NEXT:    fcvt s17, h17
; CHECK-i64-NEXT:    fcvt s19, h19
; CHECK-i64-NEXT:    frintx s18, s18
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    fcvt s4, h4
; CHECK-i64-NEXT:    fcvt s5, h5
; CHECK-i64-NEXT:    frintx s7, s7
; CHECK-i64-NEXT:    frintx s6, s6
; CHECK-i64-NEXT:    fcvt s16, h16
; CHECK-i64-NEXT:    fcvt s2, h2
; CHECK-i64-NEXT:    frintx s17, s17
; CHECK-i64-NEXT:    frintx s19, s19
; CHECK-i64-NEXT:    fcvtzs x13, s18
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    frintx s4, s4
; CHECK-i64-NEXT:    frintx s5, s5
; CHECK-i64-NEXT:    fcvtzs x9, s7
; CHECK-i64-NEXT:    mov h7, v1.h[2]
; CHECK-i64-NEXT:    fcvtzs x8, s6
; CHECK-i64-NEXT:    mov h6, v1.h[1]
; CHECK-i64-NEXT:    frintx s16, s16
; CHECK-i64-NEXT:    fcvtzs x14, s17
; CHECK-i64-NEXT:    fcvtzs x15, s19
; CHECK-i64-NEXT:    fcvtzs x10, s4
; CHECK-i64-NEXT:    mov h4, v3.h[1]
; CHECK-i64-NEXT:    fcvtzs x11, s5
; CHECK-i64-NEXT:    mov h5, v1.h[3]
; CHECK-i64-NEXT:    mov h3, v3.h[3]
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    fcvt s7, h7
; CHECK-i64-NEXT:    fcvt s6, h6
; CHECK-i64-NEXT:    fcvtzs x12, s16
; CHECK-i64-NEXT:    frintx s16, s2
; CHECK-i64-NEXT:    fmov d2, x8
; CHECK-i64-NEXT:    fcvt s4, h4
; CHECK-i64-NEXT:    fcvt s3, h3
; CHECK-i64-NEXT:    fcvt s5, h5
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    frintx s7, s7
; CHECK-i64-NEXT:    frintx s17, s6
; CHECK-i64-NEXT:    fmov d6, x9
; CHECK-i64-NEXT:    mov v2.d[1], x10
; CHECK-i64-NEXT:    frintx s4, s4
; CHECK-i64-NEXT:    frintx s18, s3
; CHECK-i64-NEXT:    frintx s5, s5
; CHECK-i64-NEXT:    fcvtzs x8, s1
; CHECK-i64-NEXT:    fcvtzs x9, s7
; CHECK-i64-NEXT:    fmov d3, x11
; CHECK-i64-NEXT:    fcvtzs x11, s0
; CHECK-i64-NEXT:    fmov d7, x12
; CHECK-i64-NEXT:    fcvtzs x12, s16
; CHECK-i64-NEXT:    fcvtzs x16, s17
; CHECK-i64-NEXT:    fcvtzs x17, s4
; CHECK-i64-NEXT:    fmov d0, x13
; CHECK-i64-NEXT:    fmov d1, x15
; CHECK-i64-NEXT:    fcvtzs x18, s18
; CHECK-i64-NEXT:    fcvtzs x0, s5
; CHECK-i64-NEXT:    fmov d4, x8
; CHECK-i64-NEXT:    fmov d5, x9
; CHECK-i64-NEXT:    mov v0.d[1], x14
; CHECK-i64-NEXT:    mov v1.d[1], x11
; CHECK-i64-NEXT:    mov v3.d[1], x12
; CHECK-i64-NEXT:    mov v4.d[1], x16
; CHECK-i64-NEXT:    mov v6.d[1], x17
; CHECK-i64-NEXT:    mov v7.d[1], x18
; CHECK-i64-NEXT:    mov v5.d[1], x0
; CHECK-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16f16(<16 x half> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16f16(<16 x half>)

define <32 x iXLen> @lrint_v32f16(<32 x half> %x) {
; CHECK-i32-LABEL: lrint_v32f16:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    ext v5.16b, v0.16b, v0.16b, #8
; CHECK-i32-NEXT:    ext v4.16b, v1.16b, v1.16b, #8
; CHECK-i32-NEXT:    ext v17.16b, v2.16b, v2.16b, #8
; CHECK-i32-NEXT:    mov h6, v5.h[1]
; CHECK-i32-NEXT:    fcvt s7, h5
; CHECK-i32-NEXT:    mov h16, v5.h[2]
; CHECK-i32-NEXT:    mov h5, v5.h[3]
; CHECK-i32-NEXT:    mov h18, v4.h[1]
; CHECK-i32-NEXT:    mov h20, v4.h[3]
; CHECK-i32-NEXT:    mov h19, v4.h[2]
; CHECK-i32-NEXT:    fcvt s21, h4
; CHECK-i32-NEXT:    mov h23, v17.h[1]
; CHECK-i32-NEXT:    ext v4.16b, v3.16b, v3.16b, #8
; CHECK-i32-NEXT:    fcvt s22, h17
; CHECK-i32-NEXT:    fcvt s6, h6
; CHECK-i32-NEXT:    frintx s7, s7
; CHECK-i32-NEXT:    fcvt s16, h16
; CHECK-i32-NEXT:    fcvt s5, h5
; CHECK-i32-NEXT:    fcvt s18, h18
; CHECK-i32-NEXT:    fcvt s20, h20
; CHECK-i32-NEXT:    fcvt s19, h19
; CHECK-i32-NEXT:    frintx s22, s22
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    fcvtzs w12, s7
; CHECK-i32-NEXT:    frintx s7, s16
; CHECK-i32-NEXT:    frintx s5, s5
; CHECK-i32-NEXT:    frintx s16, s21
; CHECK-i32-NEXT:    fcvt s21, h23
; CHECK-i32-NEXT:    frintx s18, s18
; CHECK-i32-NEXT:    frintx s20, s20
; CHECK-i32-NEXT:    frintx s19, s19
; CHECK-i32-NEXT:    fcvtzs w15, s22
; CHECK-i32-NEXT:    mov h22, v1.h[2]
; CHECK-i32-NEXT:    fcvtzs w17, s6
; CHECK-i32-NEXT:    mov h6, v17.h[2]
; CHECK-i32-NEXT:    mov h17, v17.h[3]
; CHECK-i32-NEXT:    fcvtzs w9, s7
; CHECK-i32-NEXT:    mov h7, v4.h[2]
; CHECK-i32-NEXT:    fcvtzs w8, s5
; CHECK-i32-NEXT:    mov h5, v4.h[1]
; CHECK-i32-NEXT:    fcvtzs w13, s16
; CHECK-i32-NEXT:    frintx s16, s21
; CHECK-i32-NEXT:    fcvtzs w14, s18
; CHECK-i32-NEXT:    fcvtzs w10, s20
; CHECK-i32-NEXT:    fcvt s18, h4
; CHECK-i32-NEXT:    fcvt s6, h6
; CHECK-i32-NEXT:    fcvt s17, h17
; CHECK-i32-NEXT:    mov h20, v0.h[2]
; CHECK-i32-NEXT:    fcvt s7, h7
; CHECK-i32-NEXT:    fcvtzs w11, s19
; CHECK-i32-NEXT:    mov h19, v0.h[1]
; CHECK-i32-NEXT:    fcvt s5, h5
; CHECK-i32-NEXT:    fcvtzs w0, s16
; CHECK-i32-NEXT:    mov h21, v1.h[1]
; CHECK-i32-NEXT:    frintx s18, s18
; CHECK-i32-NEXT:    mov h4, v4.h[3]
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    frintx s16, s17
; CHECK-i32-NEXT:    mov h17, v0.h[3]
; CHECK-i32-NEXT:    fcvt s0, h0
; CHECK-i32-NEXT:    fcvt s19, h19
; CHECK-i32-NEXT:    frintx s5, s5
; CHECK-i32-NEXT:    fcvtzs w2, s18
; CHECK-i32-NEXT:    fcvt s18, h21
; CHECK-i32-NEXT:    fcvt s21, h2
; CHECK-i32-NEXT:    fcvtzs w18, s6
; CHECK-i32-NEXT:    frintx s6, s7
; CHECK-i32-NEXT:    fcvt s7, h20
; CHECK-i32-NEXT:    fcvtzs w16, s16
; CHECK-i32-NEXT:    fcvt s16, h17
; CHECK-i32-NEXT:    fcvt s17, h1
; CHECK-i32-NEXT:    frintx s0, s0
; CHECK-i32-NEXT:    fcvtzs w3, s5
; CHECK-i32-NEXT:    frintx s5, s19
; CHECK-i32-NEXT:    fcvt s19, h22
; CHECK-i32-NEXT:    mov h1, v1.h[3]
; CHECK-i32-NEXT:    fcvtzs w1, s6
; CHECK-i32-NEXT:    frintx s6, s7
; CHECK-i32-NEXT:    mov h7, v2.h[1]
; CHECK-i32-NEXT:    frintx s17, s17
; CHECK-i32-NEXT:    frintx s20, s16
; CHECK-i32-NEXT:    fmov s16, w12
; CHECK-i32-NEXT:    fcvtzs w4, s0
; CHECK-i32-NEXT:    frintx s0, s18
; CHECK-i32-NEXT:    fcvtzs w5, s5
; CHECK-i32-NEXT:    frintx s5, s19
; CHECK-i32-NEXT:    frintx s18, s21
; CHECK-i32-NEXT:    fcvt s19, h3
; CHECK-i32-NEXT:    fcvtzs w12, s6
; CHECK-i32-NEXT:    fcvt s6, h7
; CHECK-i32-NEXT:    mov h7, v3.h[1]
; CHECK-i32-NEXT:    fcvtzs w6, s17
; CHECK-i32-NEXT:    fmov s17, w13
; CHECK-i32-NEXT:    mov v16.s[1], w17
; CHECK-i32-NEXT:    fcvtzs w17, s20
; CHECK-i32-NEXT:    fcvtzs w7, s0
; CHECK-i32-NEXT:    mov h0, v2.h[2]
; CHECK-i32-NEXT:    mov h20, v3.h[2]
; CHECK-i32-NEXT:    fcvtzs w13, s5
; CHECK-i32-NEXT:    fmov s5, w15
; CHECK-i32-NEXT:    frintx s6, s6
; CHECK-i32-NEXT:    fcvt s7, h7
; CHECK-i32-NEXT:    mov v17.s[1], w14
; CHECK-i32-NEXT:    fcvtzs w14, s18
; CHECK-i32-NEXT:    frintx s18, s19
; CHECK-i32-NEXT:    mov h2, v2.h[3]
; CHECK-i32-NEXT:    fcvt s0, h0
; CHECK-i32-NEXT:    mov h3, v3.h[3]
; CHECK-i32-NEXT:    mov v5.s[1], w0
; CHECK-i32-NEXT:    fcvt s19, h20
; CHECK-i32-NEXT:    fcvt s1, h1
; CHECK-i32-NEXT:    mov v16.s[2], w9
; CHECK-i32-NEXT:    fcvtzs w15, s6
; CHECK-i32-NEXT:    frintx s6, s7
; CHECK-i32-NEXT:    fmov s7, w2
; CHECK-i32-NEXT:    fcvtzs w0, s18
; CHECK-i32-NEXT:    fcvt s20, h2
; CHECK-i32-NEXT:    fcvt s18, h4
; CHECK-i32-NEXT:    frintx s21, s0
; CHECK-i32-NEXT:    fcvt s3, h3
; CHECK-i32-NEXT:    fmov s0, w4
; CHECK-i32-NEXT:    frintx s19, s19
; CHECK-i32-NEXT:    fmov s2, w6
; CHECK-i32-NEXT:    fmov s4, w14
; CHECK-i32-NEXT:    fcvtzs w2, s6
; CHECK-i32-NEXT:    mov v7.s[1], w3
; CHECK-i32-NEXT:    frintx s1, s1
; CHECK-i32-NEXT:    fmov s6, w0
; CHECK-i32-NEXT:    mov v0.s[1], w5
; CHECK-i32-NEXT:    frintx s20, s20
; CHECK-i32-NEXT:    mov v2.s[1], w7
; CHECK-i32-NEXT:    fcvtzs w3, s21
; CHECK-i32-NEXT:    mov v4.s[1], w15
; CHECK-i32-NEXT:    fcvtzs w14, s19
; CHECK-i32-NEXT:    frintx s18, s18
; CHECK-i32-NEXT:    frintx s3, s3
; CHECK-i32-NEXT:    mov v6.s[1], w2
; CHECK-i32-NEXT:    mov v17.s[2], w11
; CHECK-i32-NEXT:    fcvtzs w15, s1
; CHECK-i32-NEXT:    fcvtzs w0, s20
; CHECK-i32-NEXT:    mov v5.s[2], w18
; CHECK-i32-NEXT:    mov v0.s[2], w12
; CHECK-i32-NEXT:    mov v7.s[2], w1
; CHECK-i32-NEXT:    mov v2.s[2], w13
; CHECK-i32-NEXT:    mov v4.s[2], w3
; CHECK-i32-NEXT:    fcvtzs w9, s18
; CHECK-i32-NEXT:    fcvtzs w11, s3
; CHECK-i32-NEXT:    mov v16.s[3], w8
; CHECK-i32-NEXT:    mov v6.s[2], w14
; CHECK-i32-NEXT:    mov v17.s[3], w10
; CHECK-i32-NEXT:    mov v0.s[3], w17
; CHECK-i32-NEXT:    mov v5.s[3], w16
; CHECK-i32-NEXT:    mov v2.s[3], w15
; CHECK-i32-NEXT:    mov v4.s[3], w0
; CHECK-i32-NEXT:    mov v7.s[3], w9
; CHECK-i32-NEXT:    mov v1.16b, v16.16b
; CHECK-i32-NEXT:    mov v6.s[3], w11
; CHECK-i32-NEXT:    mov v3.16b, v17.16b
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v32f16:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v4.16b, v1.16b, v1.16b, #8
; CHECK-i64-NEXT:    ext v5.16b, v2.16b, v2.16b, #8
; CHECK-i64-NEXT:    ext v6.16b, v3.16b, v3.16b, #8
; CHECK-i64-NEXT:    ext v7.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    mov h19, v0.h[1]
; CHECK-i64-NEXT:    fcvt s21, h0
; CHECK-i64-NEXT:    mov h23, v1.h[2]
; CHECK-i64-NEXT:    fcvt s22, h1
; CHECK-i64-NEXT:    fcvt s26, h2
; CHECK-i64-NEXT:    mov h27, v2.h[1]
; CHECK-i64-NEXT:    mov h28, v2.h[2]
; CHECK-i64-NEXT:    mov h16, v4.h[2]
; CHECK-i64-NEXT:    fcvt s17, h5
; CHECK-i64-NEXT:    mov h18, v5.h[2]
; CHECK-i64-NEXT:    mov h20, v6.h[2]
; CHECK-i64-NEXT:    fcvt s24, h7
; CHECK-i64-NEXT:    fcvt s25, h6
; CHECK-i64-NEXT:    fcvt s19, h19
; CHECK-i64-NEXT:    frintx s22, s22
; CHECK-i64-NEXT:    fcvt s16, h16
; CHECK-i64-NEXT:    frintx s17, s17
; CHECK-i64-NEXT:    fcvt s18, h18
; CHECK-i64-NEXT:    fcvt s20, h20
; CHECK-i64-NEXT:    frintx s16, s16
; CHECK-i64-NEXT:    fcvtzs x12, s17
; CHECK-i64-NEXT:    frintx s17, s18
; CHECK-i64-NEXT:    frintx s18, s21
; CHECK-i64-NEXT:    fcvt s21, h23
; CHECK-i64-NEXT:    frintx s23, s24
; CHECK-i64-NEXT:    frintx s24, s25
; CHECK-i64-NEXT:    frintx s25, s19
; CHECK-i64-NEXT:    mov h19, v7.h[1]
; CHECK-i64-NEXT:    fcvtzs x13, s16
; CHECK-i64-NEXT:    frintx s16, s20
; CHECK-i64-NEXT:    frintx s20, s26
; CHECK-i64-NEXT:    fcvtzs x9, s23
; CHECK-i64-NEXT:    mov h23, v3.h[2]
; CHECK-i64-NEXT:    fcvt s26, h27
; CHECK-i64-NEXT:    fcvtzs x15, s24
; CHECK-i64-NEXT:    fcvtzs x10, s25
; CHECK-i64-NEXT:    fcvt s24, h28
; CHECK-i64-NEXT:    mov h25, v3.h[3]
; CHECK-i64-NEXT:    fcvtzs x14, s17
; CHECK-i64-NEXT:    frintx s21, s21
; CHECK-i64-NEXT:    fmov d17, x12
; CHECK-i64-NEXT:    fcvtzs x12, s16
; CHECK-i64-NEXT:    fmov d16, x13
; CHECK-i64-NEXT:    fcvtzs x13, s22
; CHECK-i64-NEXT:    fcvt s22, h3
; CHECK-i64-NEXT:    mov h3, v3.h[1]
; CHECK-i64-NEXT:    mov h27, v0.h[2]
; CHECK-i64-NEXT:    mov h28, v2.h[3]
; CHECK-i64-NEXT:    fcvt s23, h23
; CHECK-i64-NEXT:    frintx s26, s26
; CHECK-i64-NEXT:    fcvtzs x16, s20
; CHECK-i64-NEXT:    frintx s20, s24
; CHECK-i64-NEXT:    fcvt s24, h25
; CHECK-i64-NEXT:    fcvtzs x11, s18
; CHECK-i64-NEXT:    fmov d18, x14
; CHECK-i64-NEXT:    fcvtzs x14, s21
; CHECK-i64-NEXT:    frintx s22, s22
; CHECK-i64-NEXT:    fcvt s3, h3
; CHECK-i64-NEXT:    fcvt s25, h27
; CHECK-i64-NEXT:    fcvt s27, h28
; CHECK-i64-NEXT:    frintx s23, s23
; CHECK-i64-NEXT:    mov h21, v1.h[3]
; CHECK-i64-NEXT:    fmov d2, x15
; CHECK-i64-NEXT:    fcvtzs x15, s26
; CHECK-i64-NEXT:    fmov d26, x13
; CHECK-i64-NEXT:    mov h1, v1.h[1]
; CHECK-i64-NEXT:    fcvtzs x13, s20
; CHECK-i64-NEXT:    frintx s20, s24
; CHECK-i64-NEXT:    fmov d24, x14
; CHECK-i64-NEXT:    fcvtzs x14, s22
; CHECK-i64-NEXT:    frintx s3, s3
; CHECK-i64-NEXT:    fmov d22, x16
; CHECK-i64-NEXT:    frintx s27, s27
; CHECK-i64-NEXT:    fcvtzs x16, s23
; CHECK-i64-NEXT:    fcvt s21, h21
; CHECK-i64-NEXT:    frintx s25, s25
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    mov h0, v0.h[3]
; CHECK-i64-NEXT:    mov h23, v7.h[2]
; CHECK-i64-NEXT:    mov v22.d[1], x15
; CHECK-i64-NEXT:    fcvtzs x15, s20
; CHECK-i64-NEXT:    fmov d20, x13
; CHECK-i64-NEXT:    fcvtzs x13, s3
; CHECK-i64-NEXT:    fmov d3, x14
; CHECK-i64-NEXT:    fcvtzs x14, s27
; CHECK-i64-NEXT:    fmov d27, x16
; CHECK-i64-NEXT:    frintx s21, s21
; CHECK-i64-NEXT:    mov h7, v7.h[3]
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    fcvt s0, h0
; CHECK-i64-NEXT:    fcvt s23, h23
; CHECK-i64-NEXT:    fcvt s19, h19
; CHECK-i64-NEXT:    mov v27.d[1], x15
; CHECK-i64-NEXT:    fcvtzs x15, s25
; CHECK-i64-NEXT:    mov h25, v6.h[3]
; CHECK-i64-NEXT:    mov h6, v6.h[1]
; CHECK-i64-NEXT:    mov v3.d[1], x13
; CHECK-i64-NEXT:    fcvtzs x13, s21
; CHECK-i64-NEXT:    mov h21, v5.h[1]
; CHECK-i64-NEXT:    mov h5, v5.h[3]
; CHECK-i64-NEXT:    mov v20.d[1], x14
; CHECK-i64-NEXT:    fcvtzs x14, s1
; CHECK-i64-NEXT:    mov h1, v4.h[1]
; CHECK-i64-NEXT:    frintx s0, s0
; CHECK-i64-NEXT:    fcvt s25, h25
; CHECK-i64-NEXT:    fcvt s7, h7
; CHECK-i64-NEXT:    stp q3, q27, [x8, #192]
; CHECK-i64-NEXT:    fcvt s6, h6
; CHECK-i64-NEXT:    mov h3, v4.h[3]
; CHECK-i64-NEXT:    stp q22, q20, [x8, #128]
; CHECK-i64-NEXT:    fcvt s21, h21
; CHECK-i64-NEXT:    fcvt s5, h5
; CHECK-i64-NEXT:    mov v24.d[1], x13
; CHECK-i64-NEXT:    mov v26.d[1], x14
; CHECK-i64-NEXT:    fcvt s4, h4
; CHECK-i64-NEXT:    frintx s22, s25
; CHECK-i64-NEXT:    fmov d20, x12
; CHECK-i64-NEXT:    fcvt s1, h1
; CHECK-i64-NEXT:    frintx s6, s6
; CHECK-i64-NEXT:    fcvt s3, h3
; CHECK-i64-NEXT:    fcvtzs x12, s0
; CHECK-i64-NEXT:    frintx s5, s5
; CHECK-i64-NEXT:    frintx s21, s21
; CHECK-i64-NEXT:    fmov d0, x11
; CHECK-i64-NEXT:    stp q26, q24, [x8, #64]
; CHECK-i64-NEXT:    fmov d24, x15
; CHECK-i64-NEXT:    frintx s4, s4
; CHECK-i64-NEXT:    fcvtzs x11, s22
; CHECK-i64-NEXT:    frintx s22, s23
; CHECK-i64-NEXT:    frintx s1, s1
; CHECK-i64-NEXT:    fcvtzs x13, s6
; CHECK-i64-NEXT:    frintx s3, s3
; CHECK-i64-NEXT:    frintx s6, s7
; CHECK-i64-NEXT:    fcvtzs x14, s5
; CHECK-i64-NEXT:    mov v24.d[1], x12
; CHECK-i64-NEXT:    frintx s5, s19
; CHECK-i64-NEXT:    fcvtzs x12, s21
; CHECK-i64-NEXT:    mov v0.d[1], x10
; CHECK-i64-NEXT:    fcvtzs x10, s4
; CHECK-i64-NEXT:    mov v20.d[1], x11
; CHECK-i64-NEXT:    fcvtzs x11, s22
; CHECK-i64-NEXT:    mov v2.d[1], x13
; CHECK-i64-NEXT:    fcvtzs x15, s3
; CHECK-i64-NEXT:    fcvtzs x13, s1
; CHECK-i64-NEXT:    mov v18.d[1], x14
; CHECK-i64-NEXT:    fcvtzs x14, s6
; CHECK-i64-NEXT:    stp q0, q24, [x8]
; CHECK-i64-NEXT:    mov v17.d[1], x12
; CHECK-i64-NEXT:    fcvtzs x12, s5
; CHECK-i64-NEXT:    fmov d0, x10
; CHECK-i64-NEXT:    fmov d1, x11
; CHECK-i64-NEXT:    stp q2, q20, [x8, #224]
; CHECK-i64-NEXT:    fmov d2, x9
; CHECK-i64-NEXT:    mov v16.d[1], x15
; CHECK-i64-NEXT:    stp q17, q18, [x8, #160]
; CHECK-i64-NEXT:    mov v0.d[1], x13
; CHECK-i64-NEXT:    mov v1.d[1], x14
; CHECK-i64-NEXT:    mov v2.d[1], x12
; CHECK-i64-NEXT:    stp q0, q16, [x8, #96]
; CHECK-i64-NEXT:    stp q2, q1, [x8, #32]
; CHECK-i64-NEXT:    ret
  %a = call <32 x iXLen> @llvm.lrint.v32iXLen.v32f16(<32 x half> %x)
  ret <32 x iXLen> %a
}
declare <32 x iXLen> @llvm.lrint.v32iXLen.v32f16(<32 x half>)

define <1 x iXLen> @lrint_v1f32(<1 x float> %x) {
; CHECK-i32-LABEL: lrint_v1f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.2s, v0.2s
; CHECK-i32-NEXT:    fcvtzs v0.2s, v0.2s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-SD-LABEL: lrint_v1f32:
; CHECK-i64-SD:       // %bb.0:
; CHECK-i64-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-i64-SD-NEXT:    frintx s0, s0
; CHECK-i64-SD-NEXT:    fcvtzs x8, s0
; CHECK-i64-SD-NEXT:    fmov d0, x8
; CHECK-i64-SD-NEXT:    ret
;
; CHECK-i64-GI-LABEL: lrint_v1f32:
; CHECK-i64-GI:       // %bb.0:
; CHECK-i64-GI-NEXT:    frintx s0, s0
; CHECK-i64-GI-NEXT:    fcvtzs x8, s0
; CHECK-i64-GI-NEXT:    fmov d0, x8
; CHECK-i64-GI-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f32(<1 x float> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f32(<1 x float>)

define <2 x iXLen> @lrint_v2f32(<2 x float> %x) {
; CHECK-i32-LABEL: lrint_v2f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.2s, v0.2s
; CHECK-i32-NEXT:    fcvtzs v0.2s, v0.2s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v2f32:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx v0.2s, v0.2s
; CHECK-i64-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f32(<2 x float> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f32(<2 x float>)

define <4 x iXLen> @lrint_v4f32(<4 x float> %x) {
; CHECK-i32-LABEL: lrint_v4f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.4s, v0.4s
; CHECK-i32-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v4f32:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    frintx v0.2s, v0.2s
; CHECK-i64-NEXT:    frintx v1.2s, v1.2s
; CHECK-i64-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-i64-NEXT:    fcvtl v1.2d, v1.2s
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f32(<4 x float> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f32(<4 x float>)

define <8 x iXLen> @lrint_v8f32(<8 x float> %x) {
; CHECK-i32-LABEL: lrint_v8f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.4s, v0.4s
; CHECK-i32-NEXT:    frintx v1.4s, v1.4s
; CHECK-i32-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-i32-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v8f32:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    ext v3.16b, v1.16b, v1.16b, #8
; CHECK-i64-NEXT:    frintx v0.2s, v0.2s
; CHECK-i64-NEXT:    frintx v1.2s, v1.2s
; CHECK-i64-NEXT:    frintx v2.2s, v2.2s
; CHECK-i64-NEXT:    frintx v3.2s, v3.2s
; CHECK-i64-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-i64-NEXT:    fcvtl v1.2d, v1.2s
; CHECK-i64-NEXT:    fcvtl v4.2d, v2.2s
; CHECK-i64-NEXT:    fcvtl v3.2d, v3.2s
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v2.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v4.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f32(<8 x float> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f32(<8 x float>)

define <16 x iXLen> @lrint_v16f32(<16 x float> %x) {
; CHECK-i32-LABEL: lrint_v16f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.4s, v0.4s
; CHECK-i32-NEXT:    frintx v1.4s, v1.4s
; CHECK-i32-NEXT:    frintx v2.4s, v2.4s
; CHECK-i32-NEXT:    frintx v3.4s, v3.4s
; CHECK-i32-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-i32-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-i32-NEXT:    fcvtzs v2.4s, v2.4s
; CHECK-i32-NEXT:    fcvtzs v3.4s, v3.4s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v16f32:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v4.16b, v1.16b, v1.16b, #8
; CHECK-i64-NEXT:    ext v5.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    ext v6.16b, v2.16b, v2.16b, #8
; CHECK-i64-NEXT:    ext v7.16b, v3.16b, v3.16b, #8
; CHECK-i64-NEXT:    frintx v0.2s, v0.2s
; CHECK-i64-NEXT:    frintx v1.2s, v1.2s
; CHECK-i64-NEXT:    frintx v2.2s, v2.2s
; CHECK-i64-NEXT:    frintx v3.2s, v3.2s
; CHECK-i64-NEXT:    frintx v5.2s, v5.2s
; CHECK-i64-NEXT:    frintx v4.2s, v4.2s
; CHECK-i64-NEXT:    frintx v6.2s, v6.2s
; CHECK-i64-NEXT:    frintx v7.2s, v7.2s
; CHECK-i64-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-i64-NEXT:    fcvtl v1.2d, v1.2s
; CHECK-i64-NEXT:    fcvtl v16.2d, v2.2s
; CHECK-i64-NEXT:    fcvtl v18.2d, v3.2s
; CHECK-i64-NEXT:    fcvtl v5.2d, v5.2s
; CHECK-i64-NEXT:    fcvtl v17.2d, v4.2s
; CHECK-i64-NEXT:    fcvtl v19.2d, v6.2s
; CHECK-i64-NEXT:    fcvtl v7.2d, v7.2s
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v2.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v4.2d, v16.2d
; CHECK-i64-NEXT:    fcvtzs v6.2d, v18.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v5.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v17.2d
; CHECK-i64-NEXT:    fcvtzs v5.2d, v19.2d
; CHECK-i64-NEXT:    fcvtzs v7.2d, v7.2d
; CHECK-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16f32(<16 x float> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16f32(<16 x float>)

define <32 x iXLen> @lrint_v32f32(<32 x float> %x) {
; CHECK-i32-LABEL: lrint_v32f32:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.4s, v0.4s
; CHECK-i32-NEXT:    frintx v1.4s, v1.4s
; CHECK-i32-NEXT:    frintx v2.4s, v2.4s
; CHECK-i32-NEXT:    frintx v3.4s, v3.4s
; CHECK-i32-NEXT:    frintx v4.4s, v4.4s
; CHECK-i32-NEXT:    frintx v5.4s, v5.4s
; CHECK-i32-NEXT:    frintx v6.4s, v6.4s
; CHECK-i32-NEXT:    frintx v7.4s, v7.4s
; CHECK-i32-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-i32-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-i32-NEXT:    fcvtzs v2.4s, v2.4s
; CHECK-i32-NEXT:    fcvtzs v3.4s, v3.4s
; CHECK-i32-NEXT:    fcvtzs v4.4s, v4.4s
; CHECK-i32-NEXT:    fcvtzs v5.4s, v5.4s
; CHECK-i32-NEXT:    fcvtzs v6.4s, v6.4s
; CHECK-i32-NEXT:    fcvtzs v7.4s, v7.4s
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v32f32:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ext v16.16b, v7.16b, v7.16b, #8
; CHECK-i64-NEXT:    ext v17.16b, v6.16b, v6.16b, #8
; CHECK-i64-NEXT:    frintx v7.2s, v7.2s
; CHECK-i64-NEXT:    frintx v6.2s, v6.2s
; CHECK-i64-NEXT:    ext v18.16b, v5.16b, v5.16b, #8
; CHECK-i64-NEXT:    ext v21.16b, v4.16b, v4.16b, #8
; CHECK-i64-NEXT:    ext v22.16b, v2.16b, v2.16b, #8
; CHECK-i64-NEXT:    frintx v5.2s, v5.2s
; CHECK-i64-NEXT:    ext v23.16b, v3.16b, v3.16b, #8
; CHECK-i64-NEXT:    frintx v4.2s, v4.2s
; CHECK-i64-NEXT:    ext v19.16b, v0.16b, v0.16b, #8
; CHECK-i64-NEXT:    ext v20.16b, v1.16b, v1.16b, #8
; CHECK-i64-NEXT:    frintx v16.2s, v16.2s
; CHECK-i64-NEXT:    frintx v17.2s, v17.2s
; CHECK-i64-NEXT:    fcvtl v7.2d, v7.2s
; CHECK-i64-NEXT:    fcvtl v6.2d, v6.2s
; CHECK-i64-NEXT:    frintx v18.2s, v18.2s
; CHECK-i64-NEXT:    frintx v21.2s, v21.2s
; CHECK-i64-NEXT:    frintx v2.2s, v2.2s
; CHECK-i64-NEXT:    frintx v3.2s, v3.2s
; CHECK-i64-NEXT:    fcvtl v5.2d, v5.2s
; CHECK-i64-NEXT:    frintx v23.2s, v23.2s
; CHECK-i64-NEXT:    fcvtl v4.2d, v4.2s
; CHECK-i64-NEXT:    frintx v1.2s, v1.2s
; CHECK-i64-NEXT:    fcvtl v16.2d, v16.2s
; CHECK-i64-NEXT:    fcvtl v17.2d, v17.2s
; CHECK-i64-NEXT:    fcvtzs v7.2d, v7.2d
; CHECK-i64-NEXT:    fcvtzs v6.2d, v6.2d
; CHECK-i64-NEXT:    fcvtl v18.2d, v18.2s
; CHECK-i64-NEXT:    fcvtl v21.2d, v21.2s
; CHECK-i64-NEXT:    frintx v20.2s, v20.2s
; CHECK-i64-NEXT:    fcvtl v3.2d, v3.2s
; CHECK-i64-NEXT:    fcvtzs v5.2d, v5.2d
; CHECK-i64-NEXT:    frintx v0.2s, v0.2s
; CHECK-i64-NEXT:    fcvtl v2.2d, v2.2s
; CHECK-i64-NEXT:    fcvtzs v4.2d, v4.2d
; CHECK-i64-NEXT:    fcvtzs v16.2d, v16.2d
; CHECK-i64-NEXT:    fcvtzs v17.2d, v17.2d
; CHECK-i64-NEXT:    fcvtl v1.2d, v1.2s
; CHECK-i64-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-i64-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-i64-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-i64-NEXT:    stp q6, q17, [x8, #192]
; CHECK-i64-NEXT:    fcvtl v6.2d, v23.2s
; CHECK-i64-NEXT:    frintx v17.2s, v19.2s
; CHECK-i64-NEXT:    stp q7, q16, [x8, #224]
; CHECK-i64-NEXT:    frintx v7.2s, v22.2s
; CHECK-i64-NEXT:    fcvtzs v16.2d, v18.2d
; CHECK-i64-NEXT:    fcvtzs v18.2d, v21.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v6.2d, v6.2d
; CHECK-i64-NEXT:    stp q5, q16, [x8, #160]
; CHECK-i64-NEXT:    fcvtl v7.2d, v7.2s
; CHECK-i64-NEXT:    fcvtl v5.2d, v20.2s
; CHECK-i64-NEXT:    stp q4, q18, [x8, #128]
; CHECK-i64-NEXT:    fcvtl v4.2d, v17.2s
; CHECK-i64-NEXT:    stp q3, q6, [x8, #96]
; CHECK-i64-NEXT:    fcvtzs v7.2d, v7.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v5.2d
; CHECK-i64-NEXT:    stp q1, q3, [x8, #32]
; CHECK-i64-NEXT:    stp q2, q7, [x8, #64]
; CHECK-i64-NEXT:    fcvtzs v2.2d, v4.2d
; CHECK-i64-NEXT:    stp q0, q2, [x8]
; CHECK-i64-NEXT:    ret
  %a = call <32 x iXLen> @llvm.lrint.v32iXLen.v32f32(<32 x float> %x)
  ret <32 x iXLen> %a
}
declare <32 x iXLen> @llvm.lrint.v32iXLen.v32f32(<32 x float>)

define <1 x iXLen> @lrint_v1f64(<1 x double> %x) {
; CHECK-i32-LABEL: lrint_v1f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx d0, d0
; CHECK-i32-NEXT:    fcvtzs w8, d0
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v1f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx d0, d0
; CHECK-i64-NEXT:    fcvtzs x8, d0
; CHECK-i64-NEXT:    fmov d0, x8
; CHECK-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f64(<1 x double> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f64(<1 x double>)

define <2 x iXLen> @lrint_v2f64(<2 x double> %x) {
; CHECK-i32-LABEL: lrint_v2f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.2d, v0.2d
; CHECK-i32-NEXT:    mov d1, v0.d[1]
; CHECK-i32-NEXT:    fcvtzs w8, d0
; CHECK-i32-NEXT:    fcvtzs w9, d1
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    mov v0.s[1], w9
; CHECK-i32-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v2f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f64(<2 x double> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f64(<2 x double>)

define <4 x iXLen> @lrint_v4f64(<4 x double> %x) {
; CHECK-i32-LABEL: lrint_v4f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.2d, v0.2d
; CHECK-i32-NEXT:    frintx v1.2d, v1.2d
; CHECK-i32-NEXT:    mov d2, v0.d[1]
; CHECK-i32-NEXT:    fcvtzs w8, d0
; CHECK-i32-NEXT:    fcvtzs w9, d2
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    fcvtzs w8, d1
; CHECK-i32-NEXT:    mov d1, v1.d[1]
; CHECK-i32-NEXT:    mov v0.s[1], w9
; CHECK-i32-NEXT:    mov v0.s[2], w8
; CHECK-i32-NEXT:    fcvtzs w8, d1
; CHECK-i32-NEXT:    mov v0.s[3], w8
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v4f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx v0.2d, v0.2d
; CHECK-i64-NEXT:    frintx v1.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f64(<4 x double> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f64(<4 x double>)

define <8 x iXLen> @lrint_v8f64(<8 x double> %x) {
; CHECK-i32-LABEL: lrint_v8f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v2.2d, v2.2d
; CHECK-i32-NEXT:    frintx v0.2d, v0.2d
; CHECK-i32-NEXT:    frintx v3.2d, v3.2d
; CHECK-i32-NEXT:    mov d4, v0.d[1]
; CHECK-i32-NEXT:    mov d5, v2.d[1]
; CHECK-i32-NEXT:    fcvtzs w8, d0
; CHECK-i32-NEXT:    fcvtzs w9, d2
; CHECK-i32-NEXT:    frintx v2.2d, v1.2d
; CHECK-i32-NEXT:    fcvtzs w10, d4
; CHECK-i32-NEXT:    fcvtzs w11, d5
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    fmov s1, w9
; CHECK-i32-NEXT:    fcvtzs w8, d2
; CHECK-i32-NEXT:    mov d2, v2.d[1]
; CHECK-i32-NEXT:    fcvtzs w9, d3
; CHECK-i32-NEXT:    mov d3, v3.d[1]
; CHECK-i32-NEXT:    mov v0.s[1], w10
; CHECK-i32-NEXT:    mov v1.s[1], w11
; CHECK-i32-NEXT:    mov v0.s[2], w8
; CHECK-i32-NEXT:    fcvtzs w8, d2
; CHECK-i32-NEXT:    mov v1.s[2], w9
; CHECK-i32-NEXT:    fcvtzs w9, d3
; CHECK-i32-NEXT:    mov v0.s[3], w8
; CHECK-i32-NEXT:    mov v1.s[3], w9
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v8f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx v0.2d, v0.2d
; CHECK-i64-NEXT:    frintx v1.2d, v1.2d
; CHECK-i64-NEXT:    frintx v2.2d, v2.2d
; CHECK-i64-NEXT:    frintx v3.2d, v3.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f64(<8 x double> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f64(<8 x double>)

define <16 x iXLen> @lrint_v16f64(<16 x double> %x) {
; CHECK-i32-LABEL: lrint_v16f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v0.2d, v0.2d
; CHECK-i32-NEXT:    frintx v2.2d, v2.2d
; CHECK-i32-NEXT:    frintx v4.2d, v4.2d
; CHECK-i32-NEXT:    frintx v6.2d, v6.2d
; CHECK-i32-NEXT:    frintx v17.2d, v1.2d
; CHECK-i32-NEXT:    frintx v5.2d, v5.2d
; CHECK-i32-NEXT:    fcvtzs w8, d0
; CHECK-i32-NEXT:    mov d16, v0.d[1]
; CHECK-i32-NEXT:    fcvtzs w9, d2
; CHECK-i32-NEXT:    mov d2, v2.d[1]
; CHECK-i32-NEXT:    fcvtzs w10, d4
; CHECK-i32-NEXT:    mov d4, v4.d[1]
; CHECK-i32-NEXT:    fcvtzs w11, d6
; CHECK-i32-NEXT:    mov d6, v6.d[1]
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    fcvtzs w8, d16
; CHECK-i32-NEXT:    frintx v16.2d, v3.2d
; CHECK-i32-NEXT:    fmov s1, w9
; CHECK-i32-NEXT:    fcvtzs w9, d2
; CHECK-i32-NEXT:    fmov s2, w10
; CHECK-i32-NEXT:    fcvtzs w10, d4
; CHECK-i32-NEXT:    frintx v4.2d, v7.2d
; CHECK-i32-NEXT:    fmov s3, w11
; CHECK-i32-NEXT:    fcvtzs w11, d6
; CHECK-i32-NEXT:    mov d6, v17.d[1]
; CHECK-i32-NEXT:    mov v0.s[1], w8
; CHECK-i32-NEXT:    fcvtzs w8, d17
; CHECK-i32-NEXT:    mov d7, v16.d[1]
; CHECK-i32-NEXT:    mov v1.s[1], w9
; CHECK-i32-NEXT:    fcvtzs w9, d16
; CHECK-i32-NEXT:    mov v2.s[1], w10
; CHECK-i32-NEXT:    fcvtzs w10, d5
; CHECK-i32-NEXT:    mov d5, v5.d[1]
; CHECK-i32-NEXT:    mov v3.s[1], w11
; CHECK-i32-NEXT:    fcvtzs w11, d4
; CHECK-i32-NEXT:    mov d4, v4.d[1]
; CHECK-i32-NEXT:    mov v0.s[2], w8
; CHECK-i32-NEXT:    fcvtzs w8, d6
; CHECK-i32-NEXT:    mov v1.s[2], w9
; CHECK-i32-NEXT:    fcvtzs w9, d7
; CHECK-i32-NEXT:    mov v2.s[2], w10
; CHECK-i32-NEXT:    fcvtzs w10, d5
; CHECK-i32-NEXT:    mov v3.s[2], w11
; CHECK-i32-NEXT:    fcvtzs w11, d4
; CHECK-i32-NEXT:    mov v0.s[3], w8
; CHECK-i32-NEXT:    mov v1.s[3], w9
; CHECK-i32-NEXT:    mov v2.s[3], w10
; CHECK-i32-NEXT:    mov v3.s[3], w11
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v16f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    frintx v0.2d, v0.2d
; CHECK-i64-NEXT:    frintx v1.2d, v1.2d
; CHECK-i64-NEXT:    frintx v2.2d, v2.2d
; CHECK-i64-NEXT:    frintx v3.2d, v3.2d
; CHECK-i64-NEXT:    frintx v4.2d, v4.2d
; CHECK-i64-NEXT:    frintx v5.2d, v5.2d
; CHECK-i64-NEXT:    frintx v6.2d, v6.2d
; CHECK-i64-NEXT:    frintx v7.2d, v7.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-i64-NEXT:    fcvtzs v4.2d, v4.2d
; CHECK-i64-NEXT:    fcvtzs v5.2d, v5.2d
; CHECK-i64-NEXT:    fcvtzs v6.2d, v6.2d
; CHECK-i64-NEXT:    fcvtzs v7.2d, v7.2d
; CHECK-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16f64(<16 x double> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16f64(<16 x double>)

define <32 x iXLen> @lrint_v32f64(<32 x double> %x) {
; CHECK-i32-LABEL: lrint_v32f64:
; CHECK-i32:       // %bb.0:
; CHECK-i32-NEXT:    frintx v17.2d, v0.2d
; CHECK-i32-NEXT:    frintx v19.2d, v2.2d
; CHECK-i32-NEXT:    frintx v0.2d, v1.2d
; CHECK-i32-NEXT:    frintx v1.2d, v4.2d
; CHECK-i32-NEXT:    frintx v2.2d, v3.2d
; CHECK-i32-NEXT:    frintx v3.2d, v5.2d
; CHECK-i32-NEXT:    ldp q16, q5, [sp]
; CHECK-i32-NEXT:    frintx v18.2d, v6.2d
; CHECK-i32-NEXT:    frintx v4.2d, v7.2d
; CHECK-i32-NEXT:    ldp q22, q6, [sp, #64]
; CHECK-i32-NEXT:    mov d20, v17.d[1]
; CHECK-i32-NEXT:    mov d21, v19.d[1]
; CHECK-i32-NEXT:    fcvtzs w8, d17
; CHECK-i32-NEXT:    fcvtzs w9, d19
; CHECK-i32-NEXT:    ldp q17, q7, [sp, #32]
; CHECK-i32-NEXT:    fcvtzs w12, d0
; CHECK-i32-NEXT:    mov d19, v1.d[1]
; CHECK-i32-NEXT:    fcvtzs w13, d1
; CHECK-i32-NEXT:    frintx v16.2d, v16.2d
; CHECK-i32-NEXT:    mov d23, v18.d[1]
; CHECK-i32-NEXT:    fcvtzs w15, d18
; CHECK-i32-NEXT:    fcvtzs w10, d20
; CHECK-i32-NEXT:    fcvtzs w11, d21
; CHECK-i32-NEXT:    mov d21, v0.d[1]
; CHECK-i32-NEXT:    fmov s0, w8
; CHECK-i32-NEXT:    fmov s1, w9
; CHECK-i32-NEXT:    frintx v17.2d, v17.2d
; CHECK-i32-NEXT:    frintx v20.2d, v22.2d
; CHECK-i32-NEXT:    mov d22, v2.d[1]
; CHECK-i32-NEXT:    fcvtzs w14, d19
; CHECK-i32-NEXT:    mov d18, v16.d[1]
; CHECK-i32-NEXT:    frintx v7.2d, v7.2d
; CHECK-i32-NEXT:    mov v0.s[1], w10
; CHECK-i32-NEXT:    fcvtzs w10, d2
; CHECK-i32-NEXT:    mov v1.s[1], w11
; CHECK-i32-NEXT:    fcvtzs w8, d21
; CHECK-i32-NEXT:    ldp q21, q19, [sp, #96]
; CHECK-i32-NEXT:    fmov s2, w13
; CHECK-i32-NEXT:    fcvtzs w11, d23
; CHECK-i32-NEXT:    mov d23, v3.d[1]
; CHECK-i32-NEXT:    fcvtzs w9, d22
; CHECK-i32-NEXT:    mov d22, v17.d[1]
; CHECK-i32-NEXT:    fcvtzs w13, d18
; CHECK-i32-NEXT:    mov v0.s[2], w12
; CHECK-i32-NEXT:    fcvtzs w12, d16
; CHECK-i32-NEXT:    mov v1.s[2], w10
; CHECK-i32-NEXT:    fcvtzs w10, d3
; CHECK-i32-NEXT:    fmov s3, w15
; CHECK-i32-NEXT:    frintx v21.2d, v21.2d
; CHECK-i32-NEXT:    mov v2.s[1], w14
; CHECK-i32-NEXT:    mov d16, v20.d[1]
; CHECK-i32-NEXT:    fcvtzs w14, d17
; CHECK-i32-NEXT:    mov d17, v4.d[1]
; CHECK-i32-NEXT:    fcvtzs w15, d22
; CHECK-i32-NEXT:    frintx v22.2d, v5.2d
; CHECK-i32-NEXT:    mov v3.s[1], w11
; CHECK-i32-NEXT:    fcvtzs w11, d4
; CHECK-i32-NEXT:    fmov s4, w12
; CHECK-i32-NEXT:    fcvtzs w12, d20
; CHECK-i32-NEXT:    mov d18, v21.d[1]
; CHECK-i32-NEXT:    mov d20, v7.d[1]
; CHECK-i32-NEXT:    fmov s5, w14
; CHECK-i32-NEXT:    fcvtzs w14, d21
; CHECK-i32-NEXT:    mov v2.s[2], w10
; CHECK-i32-NEXT:    mov v4.s[1], w13
; CHECK-i32-NEXT:    fcvtzs w13, d16
; CHECK-i32-NEXT:    frintx v16.2d, v6.2d
; CHECK-i32-NEXT:    fcvtzs w10, d23
; CHECK-i32-NEXT:    mov v3.s[2], w11
; CHECK-i32-NEXT:    fcvtzs w11, d17
; CHECK-i32-NEXT:    fmov s6, w12
; CHECK-i32-NEXT:    mov v5.s[1], w15
; CHECK-i32-NEXT:    fcvtzs w15, d18
; CHECK-i32-NEXT:    frintx v18.2d, v19.2d
; CHECK-i32-NEXT:    fcvtzs w12, d22
; CHECK-i32-NEXT:    mov d19, v22.d[1]
; CHECK-i32-NEXT:    mov v0.s[3], w8
; CHECK-i32-NEXT:    mov v1.s[3], w9
; CHECK-i32-NEXT:    mov v6.s[1], w13
; CHECK-i32-NEXT:    fcvtzs w13, d7
; CHECK-i32-NEXT:    fmov s7, w14
; CHECK-i32-NEXT:    fcvtzs w14, d16
; CHECK-i32-NEXT:    mov d16, v16.d[1]
; CHECK-i32-NEXT:    mov v2.s[3], w10
; CHECK-i32-NEXT:    mov v4.s[2], w12
; CHECK-i32-NEXT:    fcvtzs w12, d19
; CHECK-i32-NEXT:    mov v3.s[3], w11
; CHECK-i32-NEXT:    mov v7.s[1], w15
; CHECK-i32-NEXT:    fcvtzs w15, d18
; CHECK-i32-NEXT:    mov d18, v18.d[1]
; CHECK-i32-NEXT:    mov v5.s[2], w13
; CHECK-i32-NEXT:    fcvtzs w13, d20
; CHECK-i32-NEXT:    mov v6.s[2], w14
; CHECK-i32-NEXT:    fcvtzs w14, d16
; CHECK-i32-NEXT:    mov v4.s[3], w12
; CHECK-i32-NEXT:    mov v7.s[2], w15
; CHECK-i32-NEXT:    fcvtzs w15, d18
; CHECK-i32-NEXT:    mov v5.s[3], w13
; CHECK-i32-NEXT:    mov v6.s[3], w14
; CHECK-i32-NEXT:    mov v7.s[3], w15
; CHECK-i32-NEXT:    ret
;
; CHECK-i64-LABEL: lrint_v32f64:
; CHECK-i64:       // %bb.0:
; CHECK-i64-NEXT:    ldp q17, q16, [sp, #96]
; CHECK-i64-NEXT:    frintx v7.2d, v7.2d
; CHECK-i64-NEXT:    ldp q19, q18, [sp, #64]
; CHECK-i64-NEXT:    frintx v6.2d, v6.2d
; CHECK-i64-NEXT:    ldp q21, q20, [sp, #32]
; CHECK-i64-NEXT:    frintx v5.2d, v5.2d
; CHECK-i64-NEXT:    frintx v16.2d, v16.2d
; CHECK-i64-NEXT:    frintx v17.2d, v17.2d
; CHECK-i64-NEXT:    frintx v4.2d, v4.2d
; CHECK-i64-NEXT:    frintx v18.2d, v18.2d
; CHECK-i64-NEXT:    frintx v19.2d, v19.2d
; CHECK-i64-NEXT:    frintx v3.2d, v3.2d
; CHECK-i64-NEXT:    ldp q23, q22, [sp]
; CHECK-i64-NEXT:    frintx v20.2d, v20.2d
; CHECK-i64-NEXT:    frintx v21.2d, v21.2d
; CHECK-i64-NEXT:    frintx v2.2d, v2.2d
; CHECK-i64-NEXT:    frintx v1.2d, v1.2d
; CHECK-i64-NEXT:    fcvtzs v16.2d, v16.2d
; CHECK-i64-NEXT:    fcvtzs v17.2d, v17.2d
; CHECK-i64-NEXT:    frintx v0.2d, v0.2d
; CHECK-i64-NEXT:    frintx v22.2d, v22.2d
; CHECK-i64-NEXT:    fcvtzs v18.2d, v18.2d
; CHECK-i64-NEXT:    frintx v23.2d, v23.2d
; CHECK-i64-NEXT:    fcvtzs v19.2d, v19.2d
; CHECK-i64-NEXT:    fcvtzs v20.2d, v20.2d
; CHECK-i64-NEXT:    fcvtzs v7.2d, v7.2d
; CHECK-i64-NEXT:    fcvtzs v6.2d, v6.2d
; CHECK-i64-NEXT:    fcvtzs v5.2d, v5.2d
; CHECK-i64-NEXT:    fcvtzs v4.2d, v4.2d
; CHECK-i64-NEXT:    stp q17, q16, [x8, #224]
; CHECK-i64-NEXT:    fcvtzs v16.2d, v21.2d
; CHECK-i64-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-i64-NEXT:    fcvtzs v17.2d, v22.2d
; CHECK-i64-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-i64-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-i64-NEXT:    stp q19, q18, [x8, #192]
; CHECK-i64-NEXT:    fcvtzs v18.2d, v23.2d
; CHECK-i64-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-i64-NEXT:    stp q4, q5, [x8, #64]
; CHECK-i64-NEXT:    stp q6, q7, [x8, #96]
; CHECK-i64-NEXT:    stp q2, q3, [x8, #32]
; CHECK-i64-NEXT:    stp q0, q1, [x8]
; CHECK-i64-NEXT:    stp q18, q17, [x8, #128]
; CHECK-i64-NEXT:    stp q16, q20, [x8, #160]
; CHECK-i64-NEXT:    ret
  %a = call <32 x iXLen> @llvm.lrint.v32iXLen.v16f64(<32 x double> %x)
  ret <32 x iXLen> %a
}
declare <32 x iXLen> @llvm.lrint.v32iXLen.v32f64(<32 x double>)
