; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve,+bf16 < %s | FileCheck %s --check-prefixes=CHECK,CHECK-LE
; RUN: llc -mtriple=aarch64_be-linux-gnu -mattr=+sve,+bf16 < %s | FileCheck %s --check-prefixes=CHECK,CHECK-BE

; ST1B

define void @st1_nxv16i8(ptr %addr, i64 %off, <vscale x 16 x i8> %val) {
; CHECK-LABEL: st1_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    st1b { z0.b }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  store <vscale x 16 x i8> %val, ptr %ptr
  ret void
}

define void @st1_nxv16i8_bitcast_from_i16(ptr %addr, i64 %off, <vscale x 8 x i16> %val) {
; CHECK-LE-LABEL: st1_nxv16i8_bitcast_from_i16:
; CHECK-LE:       // %bb.0:
; CHECK-LE-NEXT:    ptrue p0.b
; CHECK-LE-NEXT:    st1b { z0.b }, p0, [x0, x1]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: st1_nxv16i8_bitcast_from_i16:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ptrue p0.h
; CHECK-BE-NEXT:    add x8, x0, x1
; CHECK-BE-NEXT:    st1h { z0.h }, p0, [x8]
; CHECK-BE-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  store <vscale x 8 x i16> %val, ptr %ptr
  ret void
}

define void @st1_nxv16i8_bitcast_from_i32(ptr %addr, i64 %off, <vscale x 4 x i32> %val) {
; CHECK-LE-LABEL: st1_nxv16i8_bitcast_from_i32:
; CHECK-LE:       // %bb.0:
; CHECK-LE-NEXT:    ptrue p0.b
; CHECK-LE-NEXT:    st1b { z0.b }, p0, [x0, x1]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: st1_nxv16i8_bitcast_from_i32:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ptrue p0.s
; CHECK-BE-NEXT:    add x8, x0, x1
; CHECK-BE-NEXT:    st1w { z0.s }, p0, [x8]
; CHECK-BE-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  store <vscale x 4 x i32> %val, ptr %ptr
  ret void
}

define void @st1_nxv16i8_bitcast_from_i64(ptr %addr, i64 %off, <vscale x 2 x i64> %val) {
; CHECK-LE-LABEL: st1_nxv16i8_bitcast_from_i64:
; CHECK-LE:       // %bb.0:
; CHECK-LE-NEXT:    ptrue p0.b
; CHECK-LE-NEXT:    st1b { z0.b }, p0, [x0, x1]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: st1_nxv16i8_bitcast_from_i64:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ptrue p0.d
; CHECK-BE-NEXT:    add x8, x0, x1
; CHECK-BE-NEXT:    st1d { z0.d }, p0, [x8]
; CHECK-BE-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  store <vscale x 2 x i64> %val, ptr %ptr
  ret void
}

define void @st1_nxv8i16_trunc8(ptr %addr, i64 %off, <vscale x 8 x i16> %val) {
; CHECK-LABEL: st1_nxv8i16_trunc8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  %trunc = trunc <vscale x 8 x i16> %val to <vscale x 8 x i8>
  store <vscale x 8 x i8> %trunc, ptr %ptr
  ret void
}

define void @st1_nxv4i32_trunc8(ptr %addr, i64 %off, <vscale x 4 x i32> %val) {
; CHECK-LABEL: st1_nxv4i32_trunc8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1b { z0.s }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  %trunc = trunc <vscale x 4 x i32> %val to <vscale x 4 x i8>
  store <vscale x 4 x i8> %trunc, ptr %ptr
  ret void
}

define void @st1_nxv2i64_trunc8(ptr %addr, i64 %off, <vscale x 2 x i64> %val) {
; CHECK-LABEL: st1_nxv2i64_trunc8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1b { z0.d }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i8, ptr %addr, i64 %off
  %trunc = trunc <vscale x 2 x i64> %val to <vscale x 2 x i8>
  store <vscale x 2 x i8> %trunc, ptr %ptr
  ret void
}

; ST1H

define void @st1_nxv8i16(ptr %addr, i64 %off, <vscale x 8 x i16> %val) {
; CHECK-LABEL: st1_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i16, ptr %addr, i64 %off
  store <vscale x 8 x i16> %val, ptr %ptr
  ret void
}

define void @st1_nxv4i32_trunc16(ptr %addr, i64 %off, <vscale x 4 x i32> %val) {
; CHECK-LABEL: st1_nxv4i32_trunc16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i16, ptr %addr, i64 %off
  %trunc = trunc <vscale x 4 x i32> %val to <vscale x 4 x i16>
  store <vscale x 4 x i16> %trunc, ptr %ptr
  ret void
}

define void @st1_nxv2i64_trunc16(ptr %addr, i64 %off, <vscale x 2 x i64> %val) {
; CHECK-LABEL: st1_nxv2i64_trunc16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i16, ptr %addr, i64 %off
  %trunc = trunc <vscale x 2 x i64> %val to <vscale x 2 x i16>
  store <vscale x 2 x i16> %trunc, ptr %ptr
  ret void
}

define void @st1_nxv8f16(ptr %addr, i64 %off, <vscale x 8 x half> %val) {
; CHECK-LABEL: st1_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds half, ptr %addr, i64 %off
  store <vscale x 8 x half> %val, ptr %ptr
  ret void
}

define void @st1_nxv8bf16(ptr %addr, i64 %off, <vscale x 8 x bfloat> %val) {
; CHECK-LABEL: st1_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds bfloat, ptr %addr, i64 %off
  store <vscale x 8 x bfloat> %val, ptr %ptr
  ret void
}

define void @st1_nxv4f16(ptr %addr, i64 %off, <vscale x 4 x half> %val) {
; CHECK-LABEL: st1_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds half, ptr %addr, i64 %off
  store <vscale x 4 x half> %val, ptr %ptr
  ret void
}

define void @st1_nxv4bf16(ptr %addr, i64 %off, <vscale x 4 x bfloat> %val) {
; CHECK-LABEL: st1_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds bfloat, ptr %addr, i64 %off
  store <vscale x 4 x bfloat> %val, ptr %ptr
  ret void
}

define void @st1_nxv2f16(ptr %addr, i64 %off, <vscale x 2 x half> %val) {
; CHECK-LABEL: st1_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds half, ptr %addr, i64 %off
  store <vscale x 2 x half> %val, ptr %ptr
  ret void
}

define void @st1_nxv2bf16(ptr %addr, i64 %off, <vscale x 2 x bfloat> %val) {
; CHECK-LABEL: st1_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds bfloat, ptr %addr, i64 %off
  store <vscale x 2 x bfloat> %val, ptr %ptr
  ret void
}

; ST1W

define void @st1_nxv4i32(ptr %addr, i64 %off, <vscale x 4 x i32> %val) {
; CHECK-LABEL: st1_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i32, ptr %addr, i64 %off
  store <vscale x 4 x i32> %val, ptr %ptr
  ret void
}

define void @st1_nxv2i64_trunc32(ptr %addr, i64 %off, <vscale x 2 x i64> %val) {
; CHECK-LABEL: st1_nxv2i64_trunc32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i32, ptr %addr, i64 %off
  %trunc = trunc <vscale x 2 x i64> %val to <vscale x 2 x i32>
  store <vscale x 2 x i32> %trunc, ptr %ptr
  ret void
}

define void @st1_nxv4f32(ptr %addr, i64 %off, <vscale x 4 x float> %val) {
; CHECK-LABEL: st1_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1w { z0.s }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds float, ptr %addr, i64 %off
  store <vscale x 4 x float> %val, ptr %ptr
  ret void
}

define void @st1_nxv2f32(ptr %addr, i64 %off, <vscale x 2 x float> %val) {
; CHECK-LABEL: st1_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds float, ptr %addr, i64 %off
  store <vscale x 2 x float> %val, ptr %ptr
  ret void
}

; ST1D

define void @st1_nxv2i64(ptr %addr, i64 %off, <vscale x 2 x i64> %val) {
; CHECK-LABEL: st1_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0, x1, lsl #3]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds i64, ptr %addr, i64 %off
  store <vscale x 2 x i64> %val, ptr %ptr
  ret void
}

define void @st1_nxv2f64(ptr %addr, i64 %off, <vscale x 2 x double> %val) {
; CHECK-LABEL: st1_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1d { z0.d }, p0, [x0, x1, lsl #3]
; CHECK-NEXT:    ret
  %ptr = getelementptr inbounds double, ptr %addr, i64 %off
  store <vscale x 2 x double> %val, ptr %ptr
  ret void
}
