; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -aarch64-sve-vector-bits-min=256  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_256
; RUN: llc -aarch64-sve-vector-bits-min=512  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512
; RUN: llc -aarch64-sve-vector-bits-min=2048 < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512

target triple = "aarch64-unknown-linux-gnu"

;
; extractelement
;

; Don't use SVE for 64-bit vectors.
define half @extractelement_v4f16(<4 x half> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    ret
    %r = extractelement <4 x half> %op1, i64 3
    ret half %r
}

; Don't use SVE for 128-bit vectors.
define half @extractelement_v8f16(<8 x half> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov h0, v0.h[7]
; CHECK-NEXT:    ret
    %r = extractelement <8 x half> %op1, i64 7
    ret half %r
}

define half @extractelement_v16f16(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    mov z0.h, z0.h[15]
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
    %op1 = load <16 x half>, ptr %a
    %r = extractelement <16 x half> %op1, i64 15
    ret half %r
}

define half @extractelement_v32f16(ptr %a) #0 {
; VBITS_GE_256-LABEL: extractelement_v32f16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    mov z0.h, z0.h[15]
; VBITS_GE_256-NEXT:    // kill: def $h0 killed $h0 killed $z0
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: extractelement_v32f16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    mov z0.h, z0.h[31]
; VBITS_GE_512-NEXT:    // kill: def $h0 killed $h0 killed $z0
; VBITS_GE_512-NEXT:    ret
    %op1 = load <32 x half>, ptr %a
    %r = extractelement <32 x half> %op1, i64 31
    ret half %r
}

define half @extractelement_v64f16(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: extractelement_v64f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    mov w8, #63 // =0x3f
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.h, xzr, x8
; CHECK-NEXT:    lastb h0, p0, z0.h
; CHECK-NEXT:    ret
    %op1 = load <64 x half>, ptr %a
    %r = extractelement <64 x half> %op1, i64 63
    ret half %r
}

define half @extractelement_v128f16(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: extractelement_v128f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    mov w8, #127 // =0x7f
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.h, xzr, x8
; CHECK-NEXT:    lastb h0, p0, z0.h
; CHECK-NEXT:    ret
    %op1 = load <128 x half>, ptr %a
    %r = extractelement <128 x half> %op1, i64 127
    ret half %r
}

; Don't use SVE for 64-bit vectors.
define float @extractelement_v2f32(<2 x float> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    ret
    %r = extractelement <2 x float> %op1, i64 1
    ret float %r
}

; Don't use SVE for 128-bit vectors.
define float @extractelement_v4f32(<4 x float> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov s0, v0.s[3]
; CHECK-NEXT:    ret
    %r = extractelement <4 x float> %op1, i64 3
    ret float %r
}

define float @extractelement_v8f32(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    mov z0.s, z0.s[7]
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
    %op1 = load <8 x float>, ptr %a
    %r = extractelement <8 x float> %op1, i64 7
    ret float %r
}

define float @extractelement_v16f32(ptr %a) #0 {
; VBITS_GE_256-LABEL: extractelement_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    mov z0.s, z0.s[7]
; VBITS_GE_256-NEXT:    // kill: def $s0 killed $s0 killed $z0
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: extractelement_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    mov z0.s, z0.s[15]
; VBITS_GE_512-NEXT:    // kill: def $s0 killed $s0 killed $z0
; VBITS_GE_512-NEXT:    ret
    %op1 = load <16 x float>, ptr %a
    %r = extractelement <16 x float> %op1, i64 15
    ret float %r
}

define float @extractelement_v32f32(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: extractelement_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    mov w8, #31 // =0x1f
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.s, xzr, x8
; CHECK-NEXT:    lastb s0, p0, z0.s
; CHECK-NEXT:    ret
    %op1 = load <32 x float>, ptr %a
    %r = extractelement <32 x float> %op1, i64 31
    ret float %r
}

define float @extractelement_v64f32(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: extractelement_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    mov w8, #63 // =0x3f
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.s, xzr, x8
; CHECK-NEXT:    lastb s0, p0, z0.s
; CHECK-NEXT:    ret
    %op1 = load <64 x float>, ptr %a
    %r = extractelement <64 x float> %op1, i64 63
    ret float %r
}

; Don't use SVE for 64-bit vectors.
define double @extractelement_v1f64(<1 x double> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
    %r = extractelement <1 x double> %op1, i64 0
    ret double %r
}

; Don't use SVE for 128-bit vectors.
define double @extractelement_v2f64(<2 x double> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    ret
    %r = extractelement <2 x double> %op1, i64 1
    ret double %r
}

define double @extractelement_v4f64(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: extractelement_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    mov z0.d, z0.d[3]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %op1 = load <4 x double>, ptr %a
    %r = extractelement <4 x double> %op1, i64 3
    ret double %r
}

define double @extractelement_v8f64(ptr %a) #0 {
; VBITS_GE_256-LABEL: extractelement_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    mov z0.d, z0.d[3]
; VBITS_GE_256-NEXT:    // kill: def $d0 killed $d0 killed $z0
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: extractelement_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    mov z0.d, z0.d[7]
; VBITS_GE_512-NEXT:    // kill: def $d0 killed $d0 killed $z0
; VBITS_GE_512-NEXT:    ret
    %op1 = load <8 x double>, ptr %a
    %r = extractelement <8 x double> %op1, i64 7
    ret double %r
}

define double @extractelement_v16f64(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: extractelement_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.d, xzr, x8
; CHECK-NEXT:    lastb d0, p0, z0.d
; CHECK-NEXT:    ret
    %op1 = load <16 x double>, ptr %a
    %r = extractelement <16 x double> %op1, i64 15
    ret double %r
}

define double @extractelement_v32f64(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: extractelement_v32f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    mov w8, #31 // =0x1f
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    whilels p0.d, xzr, x8
; CHECK-NEXT:    lastb d0, p0, z0.d
; CHECK-NEXT:    ret
    %op1 = load <32 x double>, ptr %a
    %r = extractelement <32 x double> %op1, i64 31
    ret double %r
}

attributes #0 = { "target-features"="+sve" }
