; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc %s -mtriple=aarch64 -mattr=+v8.3a,+fullfp16 -o - | FileCheck %s

define <4 x half> @test_16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #0
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot0.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c)
  ret <4 x half> %res
}

define <4 x half> @test_16x4_lane_1(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_16x4_lane_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.h[1], #0
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <4 x half> %c to <2 x i32>
  %c.dup = shufflevector <2 x i32> %c.cast , <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %c.res = bitcast <2 x i32> %c.dup to <4 x half>
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot0.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c.res)
  ret <4 x half> %res
}

define <4 x half> @test_rot90_16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_rot90_16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #90
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot90.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c)
  ret <4 x half> %res
}

define <4 x half> @test_rot90_16x4_lane_0(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_rot90_16x4_lane_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.h[0], #90
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <4 x half> %c to <2 x i32>
  %c.dup = shufflevector <2 x i32> %c.cast , <2 x i32> undef, <2 x i32> <i32 0, i32 0>
  %c.res = bitcast <2 x i32> %c.dup to <4 x half>
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot90.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c.res)
  ret <4 x half> %res
}

define <4 x half> @test_rot180_16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_rot180_16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #180
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot180.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c)
  ret <4 x half> %res
}

define <4 x half> @test_rot180_16x4_lane_0(<4 x half> %a, <4 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot180_16x4_lane_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.h[0], #180
; CHECK-NEXT:    ret
entry:

  %c.cast = bitcast <8 x half> %c to <4 x i32>
  %c.dup = shufflevector <4 x i32> %c.cast , <4 x i32> undef, <2 x i32> <i32 0, i32 0>
  %c.res = bitcast <2 x i32> %c.dup to <4 x half>
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot180.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c.res)
  ret <4 x half> %res
}

define <4 x half> @test_rot270_16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: test_rot270_16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #270
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot270.v4f16(<4 x half> %a, <4 x half> %b, <4 x half> %c)
  ret <4 x half> %res
}

define <2 x float> @test_32x2(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; CHECK-LABEL: test_32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2s, v1.2s, v2.2s, #0
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x float> @llvm.aarch64.neon.vcmla.rot0.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %res
}

define <2 x float> @test_rot90_32x2(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; CHECK-LABEL: test_rot90_32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2s, v1.2s, v2.2s, #90
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x float> @llvm.aarch64.neon.vcmla.rot90.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %res
}

define <2 x float> @test_rot180_32x2(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; CHECK-LABEL: test_rot180_32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2s, v1.2s, v2.2s, #180
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x float> @llvm.aarch64.neon.vcmla.rot180.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %res
}

define <2 x float> @test_rot270_32x2(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; CHECK-LABEL: test_rot270_32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2s, v1.2s, v2.2s, #270
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x float> @llvm.aarch64.neon.vcmla.rot270.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %res
}

define <8 x half> @test_16x8(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.8h, #0
; CHECK-NEXT:    ret
entry:
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot0.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  ret <8 x half> %res
}

define <8 x half> @test_16x8_lane_0(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_16x8_lane_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.h[0], #0
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <8 x half> %c to <4 x i32>
  %c.dup = shufflevector <4 x i32> %c.cast , <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %c.res = bitcast <4 x i32> %c.dup to <8 x half>
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot0.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c.res)
  ret <8 x half> %res
}

define <8 x half> @test_rot90_16x8(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot90_16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.8h, #90
; CHECK-NEXT:    ret
entry:
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot90.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  ret <8 x half> %res
}

define <8 x half> @test_rot90_16x8_lane_1(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot90_16x8_lane_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.h[1], #90
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <8 x half> %c to <4 x i32>
  %c.dup = shufflevector <4 x i32> %c.cast , <4 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %c.res = bitcast <4 x i32> %c.dup to <8 x half>
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot90.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c.res)
  ret <8 x half> %res
}

define <8 x half> @test_rot180_16x8(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot180_16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.8h, #180
; CHECK-NEXT:    ret
entry:
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot180.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  ret <8 x half> %res
}

define <8 x half> @test_rot180_16x8_lane_1(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot180_16x8_lane_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.h[1], #180
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <8 x half> %c to <4 x i32>
  %c.dup = shufflevector <4 x i32> %c.cast , <4 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %c.res = bitcast <4 x i32> %c.dup to <8 x half>
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot180.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c.res)
  ret <8 x half> %res
}

define <8 x half> @test_rot270_16x8(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot270_16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.8h, #270
; CHECK-NEXT:    ret
entry:
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot270.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  ret <8 x half> %res
}

define <8 x half> @test_rot270_16x8_lane_0(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; CHECK-LABEL: test_rot270_16x8_lane_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.8h, v1.8h, v2.h[0], #270
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <8 x half> %c to <4 x i32>
  %c.dup = shufflevector <4 x i32> %c.cast , <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %c.res = bitcast <4 x i32> %c.dup to <8 x half>
  %res = tail call <8 x half> @llvm.aarch64.neon.vcmla.rot270.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c.res)
  ret <8 x half> %res
}

define <4 x float> @test_32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test_32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #0
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot0.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  ret <4 x float> %res
}

define <4 x float> @test_32x4_lane_0(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test_32x4_lane_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.s[0], #0
; CHECK-NEXT:    ret
entry:
  %c.cast = bitcast <4 x float> %c to <2 x i64>
  %c.dup = shufflevector <2 x i64> %c.cast , <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %c.res = bitcast <2 x i64> %c.dup to <4 x float>
  %res = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot0.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c.res)
  ret <4 x float> %res
}

define <4 x float> @test_rot90_32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test_rot90_32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #90
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot90.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  ret <4 x float> %res
}

define <4 x float> @test_rot180_32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test_rot180_32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #180
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot180.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  ret <4 x float> %res
}

define <4 x float> @test_rot270_32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: test_rot270_32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #270
; CHECK-NEXT:    ret
entry:
  %res = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot270.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  ret <4 x float> %res
}

define <2 x double> @test_64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: test_64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #0
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot0.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @test_rot90_64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: test_rot90_64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #90
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot90.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @test_rot180_64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: test_rot180_64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #180
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot180.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @test_rot270_64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: test_rot270_64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #270
; CHECK-NEXT:    ret
entry:
  %res = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <4 x float> @reassoc_f32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: reassoc_f32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #0
; CHECK-NEXT:    ret
entry:
  %d = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot0.v4f32(<4 x float> zeroinitializer, <4 x float> %b, <4 x float> %c)
  %res = fadd fast <4 x float> %d, %a
  ret <4 x float> %res
}

define <4 x float> @reassoc_c_f32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: reassoc_c_f32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4s, v1.4s, v2.4s, #90
; CHECK-NEXT:    ret
entry:
  %d = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot90.v4f32(<4 x float> zeroinitializer, <4 x float> %b, <4 x float> %c)
  %res = fadd fast <4 x float> %a, %d
  ret <4 x float> %res
}

define <4 x half> @reassoc_f16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: reassoc_f16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #180
; CHECK-NEXT:    ret
entry:
  %d = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot180.v4f16(<4 x half> zeroinitializer, <4 x half> %b, <4 x half> %c)
  %res = fadd fast <4 x half> %d, %a
  ret <4 x half> %res
}

define <4 x half> @reassoc_c_f16x4(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; CHECK-LABEL: reassoc_c_f16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.4h, v1.4h, v2.4h, #270
; CHECK-NEXT:    ret
entry:
  %d = tail call <4 x half> @llvm.aarch64.neon.vcmla.rot270.v4f16(<4 x half> zeroinitializer, <4 x half> %b, <4 x half> %c)
  %res = fadd fast <4 x half> %a, %d
  ret <4 x half> %res
}

define <2 x double> @reassoc_f64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c, <2 x double> %g) {
; CHECK-LABEL: reassoc_f64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #270
; CHECK-NEXT:    fcmla v0.2d, v2.2d, v3.2d, #270
; CHECK-NEXT:    ret
entry:
  %d = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  %e = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double> zeroinitializer, <2 x double> %c, <2 x double> %g)
  %res = fadd fast <2 x double> %e, %d
  ret <2 x double> %res
}

define <2 x double> @reassoc_c_f64x2(<2 x double> %a, <2 x double> %b, <2 x double> %c, <2 x double> %g) {
; CHECK-LABEL: reassoc_c_f64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fadd v0.2d, v0.2d, v0.2d
; CHECK-NEXT:    fcmla v0.2d, v1.2d, v2.2d, #270
; CHECK-NEXT:    fcmla v0.2d, v2.2d, v3.2d, #270
; CHECK-NEXT:    ret
entry:
  %d = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  %e = tail call <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double> %a, <2 x double> %c, <2 x double> %g)
  %res = fadd fast <2 x double> %e, %d
  ret <2 x double> %res
}

define <4 x float> @reassoc_nonfast_f32x4(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: reassoc_nonfast_f32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v3.2d, #0000000000000000
; CHECK-NEXT:    fcmla v3.4s, v1.4s, v2.4s, #0
; CHECK-NEXT:    fadd v0.4s, v3.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %d = tail call <4 x float> @llvm.aarch64.neon.vcmla.rot0.v4f32(<4 x float> zeroinitializer, <4 x float> %b, <4 x float> %c)
  %res = fadd <4 x float> %d, %a
  ret <4 x float> %res
}

declare <4 x half> @llvm.aarch64.neon.vcmla.rot0.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <4 x half> @llvm.aarch64.neon.vcmla.rot90.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <4 x half> @llvm.aarch64.neon.vcmla.rot180.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <4 x half> @llvm.aarch64.neon.vcmla.rot270.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <8 x half> @llvm.aarch64.neon.vcmla.rot0.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <8 x half> @llvm.aarch64.neon.vcmla.rot90.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <8 x half> @llvm.aarch64.neon.vcmla.rot180.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <8 x half> @llvm.aarch64.neon.vcmla.rot270.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <2 x float> @llvm.aarch64.neon.vcmla.rot0.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <2 x float> @llvm.aarch64.neon.vcmla.rot90.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <2 x float> @llvm.aarch64.neon.vcmla.rot180.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <2 x float> @llvm.aarch64.neon.vcmla.rot270.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <4 x float> @llvm.aarch64.neon.vcmla.rot0.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <4 x float> @llvm.aarch64.neon.vcmla.rot90.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <4 x float> @llvm.aarch64.neon.vcmla.rot180.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <4 x float> @llvm.aarch64.neon.vcmla.rot270.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <2 x double> @llvm.aarch64.neon.vcmla.rot0.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <2 x double> @llvm.aarch64.neon.vcmla.rot90.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <2 x double> @llvm.aarch64.neon.vcmla.rot180.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <2 x double> @llvm.aarch64.neon.vcmla.rot270.v2f64(<2 x double>, <2 x double>, <2 x double>)
