; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -emulated-tls -mtriple aarch64-apple-darwin -global-isel -global-isel-abort=2 %s -o - 2>&1 | FileCheck %s

; This file checks that the fallback path for instructions with emulated TLS variables to selection dag works.

; CHECK:        warning: Instruction selection used fallback path for main

@x = thread_local global i32 42, align 4

define i32 @main(i32 %argc, ptr %argv) {
; CHECK-LABEL: main:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! ; 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:  Lloh0:
; CHECK-NEXT:    adrp x0, ___emutls_v.x@PAGE
; CHECK-NEXT:  Lloh1:
; CHECK-NEXT:    add x0, x0, ___emutls_v.x@PAGEOFF
; CHECK-NEXT:    bl ___emutls_get_address
; CHECK-NEXT:    ldr w0, [x0]
; CHECK-NEXT:    ldp x29, x30, [sp], #16 ; 16-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:    .loh AdrpAdd Lloh0, Lloh1
entry:
  %0 = load i32, ptr @x, align 4
  ret i32 %0
}
