; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -stop-after=irtranslator -global-isel -global-isel-abort=1 -verify-machineinstrs %s -o - | FileCheck %s

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-linux-gnu"

define i32 @args_i32(i32 %w0, i32 %w1, i32 %w2, i32 %w3,
  ; CHECK-LABEL: name: args_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2, $w3, $w4, $w5, $w6, $w7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $w4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $w5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $w6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $w7
  ; CHECK-NEXT:   $w0 = COPY [[COPY]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
                     i32 %w4, i32 %w5, i32 %w6, i32 %w7) {
  ret i32 %w0
}

define i64 @args_i64(i64 %x0, i64 %x1, i64 %x2, i64 %x3,
  ; CHECK-LABEL: name: args_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK-NEXT:   $x0 = COPY [[COPY]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0
                     i64 %x4, i64 %x5, i64 %x6, i64 %x7) {
  ret i64 %x0
}


define ptr @args_ptrs(ptr %x0, ptr %x1, ptr %x2, ptr %x3,
  ; CHECK-LABEL: name: args_ptrs
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(p0) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(p0) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(p0) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(p0) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(p0) = COPY $x5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(p0) = COPY $x6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(p0) = COPY $x7
  ; CHECK-NEXT:   $x0 = COPY [[COPY]](p0)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0
                      ptr %x4, ptr %x5, ptr %x6, ptr %x7) {
  ret ptr %x0
}

define [1 x double] @args_arr([1 x double] %d0) {
  ; CHECK-LABEL: name: args_arr
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $d0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $d0
  ; CHECK-NEXT:   $d0 = COPY [[COPY]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
  ret [1 x double] %d0
}

declare void @varargs(i32, double, i64, ...)
define void @test_varargs() {
  ; CHECK-LABEL: name: test_varargs
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 42
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.000000e+00
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 12
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s8) = G_CONSTANT i8 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s16) = G_CONSTANT i16 1
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+00
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_FCONSTANT double 2.000000e+00
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[C3]](s8)
  ; CHECK-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[C4]](s16)
  ; CHECK-NEXT:   $w0 = COPY [[C]](s32)
  ; CHECK-NEXT:   $d0 = COPY [[C1]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[C2]](s64)
  ; CHECK-NEXT:   $w2 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   $w3 = COPY [[ANYEXT1]](s32)
  ; CHECK-NEXT:   $w4 = COPY [[C5]](s32)
  ; CHECK-NEXT:   $s1 = COPY [[C6]](s32)
  ; CHECK-NEXT:   $d2 = COPY [[C7]](s64)
  ; CHECK-NEXT:   BL @varargs, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $w0, implicit $d0, implicit $x1, implicit $w2, implicit $w3, implicit $w4, implicit $s1, implicit $d2
  ; CHECK-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   RET_ReallyLR
  call void(i32, double, i64, ...) @varargs(i32 42, double 1.0, i64 12, i8 3, i16 1, i32 4, float 1.0, double 2.0)
  ret void
}

; signext/zeroext parameters on the stack: not part of any real ABI as far as I
; know, but ELF currently allocates 8 bytes for a signext parameter on the
; stack. The ADJCALLSTACK ops should reflect this, even if the difference is
; theoretical.
declare void @stack_ext_needed([8 x i64], i8 signext %in)
define void @test_stack_ext_needed() {
  ; CHECK-LABEL: name: test_stack_ext_needed
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(s64) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s8) = G_CONSTANT i8 42
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 8, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $sp
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C1]](s64)
  ; CHECK-NEXT:   G_STORE [[C]](s8), [[PTR_ADD]](p0) :: (store (s8) into stack)
  ; CHECK-NEXT:   $x0 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x3 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x4 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x5 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x6 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   $x7 = COPY [[DEF]](s64)
  ; CHECK-NEXT:   BL @stack_ext_needed, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit $x1, implicit $x2, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7
  ; CHECK-NEXT:   ADJCALLSTACKUP 8, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   RET_ReallyLR
  call void @stack_ext_needed([8 x i64] undef, i8 signext 42)
  ret void
}

; Check that we can lower incoming i128 types into constituent s64 gprs.
define void @callee_s128(i128 %a, i128 %b, ptr %ptr) {
  ; CHECK-LABEL: name: callee_s128
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(p0) = COPY $x4
  ; CHECK-NEXT:   G_STORE [[MV1]](s128), [[COPY4]](p0) :: (store (s128) into %ir.ptr)
  ; CHECK-NEXT:   RET_ReallyLR
  store i128 %b, ptr %ptr
  ret void
}

; Check we can lower outgoing s128 arguments into s64 gprs.
define void @caller_s128(ptr %ptr) {
  ; CHECK-LABEL: name: caller_s128
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK-NEXT:   [[LOAD:%[0-9]+]]:_(s128) = G_LOAD [[COPY]](p0) :: (load (s128) from %ir.ptr)
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[LOAD]](s128)
  ; CHECK-NEXT:   [[UV2:%[0-9]+]]:_(s64), [[UV3:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[LOAD]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[UV2]](s64)
  ; CHECK-NEXT:   $x3 = COPY [[UV3]](s64)
  ; CHECK-NEXT:   $x4 = COPY [[COPY]](p0)
  ; CHECK-NEXT:   BL @callee_s128, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit $x1, implicit $x2, implicit $x3, implicit $x4
  ; CHECK-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   RET_ReallyLR
  %v = load i128, ptr %ptr
  call void @callee_s128(i128 %v, i128 %v, ptr %ptr)
  ret void
}


declare i64 @i8i16callee(i64 %a1, i64 %a2, i64 %a3, i8 signext %a4, i16 signext %a5, i64 %a6, i64 %a7, i64 %a8, i8 signext %b1, i16 signext %b2, i8 signext %b3, i8 signext %b4) nounwind readnone noinline

define i32 @i8i16caller() nounwind readnone {
  ; CHECK-LABEL: name: i8i16caller
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s8) = G_CONSTANT i8 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s16) = G_CONSTANT i16 4
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 6
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; CHECK-NEXT:   [[C8:%[0-9]+]]:_(s8) = G_CONSTANT i8 97
  ; CHECK-NEXT:   [[C9:%[0-9]+]]:_(s16) = G_CONSTANT i16 98
  ; CHECK-NEXT:   [[C10:%[0-9]+]]:_(s8) = G_CONSTANT i8 99
  ; CHECK-NEXT:   [[C11:%[0-9]+]]:_(s8) = G_CONSTANT i8 100
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 32, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $sp
  ; CHECK-NEXT:   [[C12:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C12]](s64)
  ; CHECK-NEXT:   G_STORE [[C8]](s8), [[PTR_ADD]](p0) :: (store (s8) into stack)
  ; CHECK-NEXT:   [[C13:%[0-9]+]]:_(s64) = G_CONSTANT i64 8
  ; CHECK-NEXT:   [[PTR_ADD1:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C13]](s64)
  ; CHECK-NEXT:   G_STORE [[C9]](s16), [[PTR_ADD1]](p0) :: (store (s16) into stack + 8, align 1)
  ; CHECK-NEXT:   [[C14:%[0-9]+]]:_(s64) = G_CONSTANT i64 16
  ; CHECK-NEXT:   [[PTR_ADD2:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C14]](s64)
  ; CHECK-NEXT:   G_STORE [[C10]](s8), [[PTR_ADD2]](p0) :: (store (s8) into stack + 16)
  ; CHECK-NEXT:   [[C15:%[0-9]+]]:_(s64) = G_CONSTANT i64 24
  ; CHECK-NEXT:   [[PTR_ADD3:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C15]](s64)
  ; CHECK-NEXT:   G_STORE [[C11]](s8), [[PTR_ADD3]](p0) :: (store (s8) into stack + 24)
  ; CHECK-NEXT:   $x0 = COPY [[C]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[C1]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[C2]](s64)
  ; CHECK-NEXT:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[C3]](s8)
  ; CHECK-NEXT:   $w3 = COPY [[SEXT]](s32)
  ; CHECK-NEXT:   [[SEXT1:%[0-9]+]]:_(s32) = G_SEXT [[C4]](s16)
  ; CHECK-NEXT:   $w4 = COPY [[SEXT1]](s32)
  ; CHECK-NEXT:   $x5 = COPY [[C5]](s64)
  ; CHECK-NEXT:   $x6 = COPY [[C6]](s64)
  ; CHECK-NEXT:   $x7 = COPY [[C7]](s64)
  ; CHECK-NEXT:   BL @i8i16callee, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit $x1, implicit $x2, implicit $w3, implicit $w4, implicit $x5, implicit $x6, implicit $x7, implicit-def $x0
  ; CHECK-NEXT:   ADJCALLSTACKUP 32, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY1]](s64)
  ; CHECK-NEXT:   $w0 = COPY [[TRUNC]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
entry:
  %call = tail call i64 @i8i16callee(i64 0, i64 1, i64 2, i8 signext 3, i16 signext 4, i64 5, i64 6, i64 7, i8 97, i16  98, i8  99, i8  100)
  %conv = trunc i64 %call to i32
  ret i32 %conv
}

define void @arg_v2i64(<2 x i64> %arg) {
  ; CHECK-LABEL: name: arg_v2i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   G_STORE [[COPY]](<2 x s64>), [[DEF]](p0) :: (store (<2 x s64>) into `ptr undef`)
  ; CHECK-NEXT:   RET_ReallyLR
  store <2 x i64> %arg, ptr undef
  ret void
}

define void @arg_v8i64(<8 x i64> %arg) {
  ; CHECK-LABEL: name: arg_v8i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0, $q1, $q2, $q3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<2 x s64>) = COPY $q1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(<2 x s64>) = COPY $q2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(<2 x s64>) = COPY $q3
  ; CHECK-NEXT:   [[CONCAT_VECTORS:%[0-9]+]]:_(<8 x s64>) = G_CONCAT_VECTORS [[COPY]](<2 x s64>), [[COPY1]](<2 x s64>), [[COPY2]](<2 x s64>), [[COPY3]](<2 x s64>)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   G_STORE [[CONCAT_VECTORS]](<8 x s64>), [[DEF]](p0) :: (store (<8 x s64>) into `ptr undef`)
  ; CHECK-NEXT:   RET_ReallyLR
  store <8 x i64> %arg, ptr undef
  ret void
}

define void @arg_v4f32(<4 x float> %arg) {
  ; CHECK-LABEL: name: arg_v4f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK-NEXT:   [[BITCAST:%[0-9]+]]:_(<4 x s32>) = G_BITCAST [[COPY]](<2 x s64>)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   G_STORE [[BITCAST]](<4 x s32>), [[DEF]](p0) :: (store (<4 x s32>) into `ptr undef`)
  ; CHECK-NEXT:   RET_ReallyLR
  store <4 x float> %arg, ptr undef
  ret void
}

define void @ret_arg_v16f32(<16 x float> %arg) {
  ; CHECK-LABEL: name: ret_arg_v16f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0, $q1, $q2, $q3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<2 x s64>) = COPY $q1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(<2 x s64>) = COPY $q2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(<2 x s64>) = COPY $q3
  ; CHECK-NEXT:   [[BITCAST:%[0-9]+]]:_(<4 x s32>) = G_BITCAST [[COPY]](<2 x s64>)
  ; CHECK-NEXT:   [[BITCAST1:%[0-9]+]]:_(<4 x s32>) = G_BITCAST [[COPY1]](<2 x s64>)
  ; CHECK-NEXT:   [[BITCAST2:%[0-9]+]]:_(<4 x s32>) = G_BITCAST [[COPY2]](<2 x s64>)
  ; CHECK-NEXT:   [[BITCAST3:%[0-9]+]]:_(<4 x s32>) = G_BITCAST [[COPY3]](<2 x s64>)
  ; CHECK-NEXT:   [[CONCAT_VECTORS:%[0-9]+]]:_(<16 x s32>) = G_CONCAT_VECTORS [[BITCAST]](<4 x s32>), [[BITCAST1]](<4 x s32>), [[BITCAST2]](<4 x s32>), [[BITCAST3]](<4 x s32>)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   G_STORE [[CONCAT_VECTORS]](<16 x s32>), [[DEF]](p0) :: (store (<16 x s32>) into `ptr undef`)
  ; CHECK-NEXT:   RET_ReallyLR
  store <16 x float> %arg, ptr undef
  ret void
}
