; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<scalar-evolution>' \
; RUN:  -scalar-evolution-classify-expressions=0 -disable-output %s 2>&1 | FileCheck %s

define void @infer_via_ranges(ptr %arr, i32 %n) {
; CHECK-LABEL: 'infer_via_ranges'
; CHECK-NEXT:  Determining loop execution counts for: @infer_via_ranges
; CHECK-NEXT:  Loop %loop: <multiple exits> backedge-taken count is ((-1 + %n) umin %n)
; CHECK-NEXT:    exit count for loop: %n
; CHECK-NEXT:    exit count for in.bounds: (-1 + %n)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 -2147483648
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-1 + %n) umin %n)
; CHECK-NEXT:    symbolic max exit count for loop: %n
; CHECK-NEXT:    symbolic max exit count for in.bounds: (-1 + %n)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  %first.itr.check = icmp sgt i32 %n, 0
  %start = sub i32 %n, 1
  br i1 %first.itr.check, label %loop, label %exit

 loop:
  %idx = phi i32 [ %start, %entry ] , [ %idx.dec, %in.bounds ]
  %idx.dec = sub i32 %idx, 1
  %abc = icmp sge i32 %idx, 0
  br i1 %abc, label %in.bounds, label %out.of.bounds

 in.bounds:
  %addr = getelementptr i32, ptr %arr, i32 %idx
  store i32 0, ptr %addr
  %next = icmp sgt i32 %idx.dec, -1
  br i1 %next, label %loop, label %exit

 out.of.bounds:
  ret void

 exit:
  ret void
}
