; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<cost-model>' 2>&1 -disable-output -mtriple=amdgcn-unknown-amdhsa < %s | FileCheck -check-prefixes=ALL,UNPACKEDID %s
; RUN: opt -passes='print<cost-model>' 2>&1 -disable-output -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=ALL,PACKEDID %s

; RUN: opt -passes='print<cost-model>' -cost-kind=code-size 2>&1 -disable-output -mtriple=amdgcn-unknown-amdhsa < %s | FileCheck -check-prefixes=SIZE,SIZE-UNPACKEDID %s
; RUN: opt -passes='print<cost-model>' -cost-kind=code-size 2>&1 -disable-output -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=SIZE,SIZE-PACKEDID %s

define i32 @workitem_id_x() {
; ALL-LABEL: 'workitem_id_x'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.x()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workitem_id_x'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.x()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workitem.id.x()
  ret i32 %result
}

define amdgpu_kernel void @kernel_workitem_id_x(ptr addrspace(1) %ptr) {
; ALL-LABEL: 'kernel_workitem_id_x'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.x()
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; SIZE-LABEL: 'kernel_workitem_id_x'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.x()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %result = call i32 @llvm.amdgcn.workitem.id.x()
  store i32 %result, ptr addrspace(1) %ptr
  ret void
}

define i32 @workitem_id_y() {
; ALL-LABEL: 'workitem_id_y'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workitem_id_y'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workitem.id.y()
  ret i32 %result
}

define amdgpu_kernel void @kernel_workitem_id_y(ptr addrspace(1) %ptr) {
; ALL-LABEL: 'kernel_workitem_id_y'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; SIZE-LABEL: 'kernel_workitem_id_y'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %result = call i32 @llvm.amdgcn.workitem.id.y()
  store i32 %result, ptr addrspace(1) %ptr
  ret void
}

define i32 @workitem_id_z() {
; ALL-LABEL: 'workitem_id_z'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workitem_id_z'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.y()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workitem.id.y()
  ret i32 %result
}

define amdgpu_kernel void @kernel_workitem_id_z(ptr addrspace(1) %ptr) {
; ALL-LABEL: 'kernel_workitem_id_z'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.z()
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; SIZE-LABEL: 'kernel_workitem_id_z'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workitem.id.z()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %result, ptr addrspace(1) %ptr, align 4
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %result = call i32 @llvm.amdgcn.workitem.id.z()
  store i32 %result, ptr addrspace(1) %ptr
  ret void
}

define i32 @workgroup_id_x() {
; ALL-LABEL: 'workgroup_id_x'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.x()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workgroup_id_x'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.x()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workgroup.id.x()
  ret i32 %result
}

define i32 @workgroup_id_y() {
; ALL-LABEL: 'workgroup_id_y'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.y()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workgroup_id_y'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.y()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workgroup.id.y()
  ret i32 %result
}

define i32 @workgroup_id_z() {
; ALL-LABEL: 'workgroup_id_z'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.y()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'workgroup_id_z'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.workgroup.id.y()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.workgroup.id.y()
  ret i32 %result
}

define i32 @lds_kernel_id() {
; ALL-LABEL: 'lds_kernel_id'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.lds.kernel.id()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 %result
;
; SIZE-LABEL: 'lds_kernel_id'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i32 @llvm.amdgcn.lds.kernel.id()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %result
;
  %result = call i32 @llvm.amdgcn.lds.kernel.id()
  ret i32 %result
}

define ptr addrspace(4) @dispatch_ptr() {
; ALL-LABEL: 'dispatch_ptr'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.dispatch.ptr()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret ptr addrspace(4) %result
;
; SIZE-LABEL: 'dispatch_ptr'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.dispatch.ptr()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret ptr addrspace(4) %result
;
  %result = call ptr addrspace(4) @llvm.amdgcn.dispatch.ptr()
  ret ptr addrspace(4) %result
}

define i64 @dispatch_id_() {
; ALL-LABEL: 'dispatch_id_'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i64 @llvm.amdgcn.dispatch.id()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i64 %result
;
; SIZE-LABEL: 'dispatch_id_'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call i64 @llvm.amdgcn.dispatch.id()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %result
;
  %result = call i64 @llvm.amdgcn.dispatch.id()
  ret i64 %result
}

define ptr addrspace(4) @implicitarg_ptr() {
; ALL-LABEL: 'implicitarg_ptr'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.implicitarg.ptr()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret ptr addrspace(4) %result
;
; SIZE-LABEL: 'implicitarg_ptr'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.implicitarg.ptr()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret ptr addrspace(4) %result
;
  %result = call ptr addrspace(4) @llvm.amdgcn.implicitarg.ptr()
  ret ptr addrspace(4) %result
}

define ptr addrspace(4) @queue_ptr() {
; ALL-LABEL: 'queue_ptr'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.queue.ptr()
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret ptr addrspace(4) %result
;
; SIZE-LABEL: 'queue_ptr'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %result = call ptr addrspace(4) @llvm.amdgcn.queue.ptr()
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret ptr addrspace(4) %result
;
  %result = call ptr addrspace(4) @llvm.amdgcn.queue.ptr()
  ret ptr addrspace(4) %result
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; PACKEDID: {{.*}}
; SIZE-PACKEDID: {{.*}}
; SIZE-UNPACKEDID: {{.*}}
; UNPACKEDID: {{.*}}
