/* Library libcerf:
 *   Compute complex error functions, based on a new implementation of
 *   Faddeeva's w_of_z. Also provide Dawson and Voigt functions.
 *
 * File widthtest.c:
 *   Test the function voigt_hwhm.
 *
 * Copyright:
 *   (C) 2025 Forschungszentrum Jülich GmbH
 *
 * Licence:
 *   ../LICENSE
 *
 * Authors:
 *   Joachim Wuttke, Forschungszentrum Jülich, 2013
 *
 * Website:
 *   http://apps.jcns.fz-juelich.de/libcerf
 *
 * Revision history:
 *   ../CHANGELOG
 */

#ifdef __cplusplus
#include <cassert>
#else
#include <assert.h>
#endif
#include <math.h>
#include <stdio.h>
#include "cerf.h"

#include "auto_test_voigt_hwhm.c" // Generated by the PPAPP code generator.

int test_one(double x, double fref)
{
    double fappr = voigt_hwhm(1., x);
    double relerr = fabs((fappr-fref) / fref) / pow(2.,-53);
    if (relerr > ppapp_maxrelerr) {
        printf("x=%23.16e -> fref=%23.16e fappr=%23.16e relerr/eps=%8g tol=%8g\n",
               x, fref, fappr, relerr, ppapp_maxrelerr);
        return 1;
    }

    fappr = voigt_hwhm(1e180, 1e180*x) / 1e180;
    relerr = fabs((fappr-fref) / fref) / pow(2.,-53);
    if (relerr > ppapp_maxrelerr + 1) {
        printf("x=%23.16e -> fref=%23.16e fappr=%23.16e relerr/eps=%8g tol=%8g\n",
               x, fref, fappr, relerr, ppapp_maxrelerr);
        return 1;
    }

    fappr = voigt_hwhm(1e-180, x*1e-180) / 1e-180;
    relerr = fabs((fappr-fref) / fref) / pow(2.,-53);
    if (relerr > ppapp_maxrelerr + 1) {
        printf("x=%23.16e -> fref=%23.16e fappr=%23.16e relerr/eps=%8g tol=%8g\n",
               x, fref, fappr, relerr, ppapp_maxrelerr);
        return 1;
    }

    return 0;
}

//! Program run_computation.
//! Writes a table of some representative x and f(x), the latter computed in polynomial approximation.

int main(void) {
    int failed = run_tests();
    if (failed) {
        printf("test_computation: %d test cases failed\n", failed);
        return 1;
    }
    return 0;
}
