.TH TWILL 1 "3 February 2026" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if n .ds TX TeX
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.\"=====================================================================
.SH NAME
twill, twill-refsort \- translate a literate programming WEB to TeX with mini-indexes
.SH SYNOPSIS
.PP
\f[B]twill\f[R] [\f[B]-x\f[R]]
\f[I]webfile\f[R][\f[B].web\f[R]]
[{\f[I]changefile\f[R][\f[B].ch\f[R]]|\f[B]-\f[R]}
[\f[I]outfile\f[R][\f[B].tex\f[R]]]]
.PD 0
.PP
\f[B]twill-refsort\f[R] <
\f[I]reffile\f[B].ref\f[R] >
\f[I]sreffile\f[B].sref\f[R]
.PD
.\"=====================================================================
.SH DESCRIPTION
The
.B twill
program is used to create a \*(TX file for viewing a literate program
written in WEB.  The output \*(TX file name is formed by adding
.I .tex
to the root of the \*(WB file name.
.PP
\fBtwill\fP is like
.BR weave (1),
but also supplies cross-reference information in the form of
`mini-indexes' for each spread of pages, for identifiers used on that
spread, and a `master index' at the end that it gathers automatically.
.PP
You need to run
.B twill
twice, once to prime the pump and once to get decent answers.
Moreover, you must run the output twice through \*(TX.
.PP
For a program \fIfoo.web\fP, after a first
.I tex foo
you will have output that looks like final pages
except that the entries of mini-indexes will not be alphabetized.
The first run produces an auxiliary file named
.IR foo.ref .
.br
Run
.I twill-refsort <foo.ref >foo.sref
and then another
.I tex foo
will produce alphabetized output.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing, and
.BR weave (1)
for options accepted.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable WEBINPUTS is used to search for the input files,
If it is not set, it uses the system default. See the
Kpathsea manual at https://tug.org/kpathsea for the details of the
searching.
.\"=====================================================================
.SH BUGS
The table of contents file, \fICONTENTS.tex\fP, is generated but ignored
(unless macros in \fItwimac-web.tex\fP are redefined).
.\"=====================================================================
.SH FILES
.TP \w'@@'u+2n
.I $TEXMFMAIN/tex/plain/cweb/cwebbin/twimac-web.tex
\*(TX macros used by
.B twill
output.
.\"=====================================================================
.SH "SEE ALSO"
.BR tangle (1)
for references, authors, and other information about WEB in general.
.PP
Donald E. Knuth, Mini-indexes for literate programs,
Software\-Concepts and Tools, 15(1):2-11, 1994.
.br
https://arxiv.org/abs/cs/9401102
.PP
CTWILL program source, section 287:
.br
https://mirror.ctan.org/info/knuth-pdf/cweb/ctwill.pdf
.br
(Not all features described there are available in the older
\fBtwill\fP system, but you will get the gist.)
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
