.TH TFTOPL 1 "30 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX
.\"=====================================================================
.SH NAME
tftopl \- convert a TeX font metric (tfm) file to property list (pl) format
.SH SYNOPSIS
.B tftopl
.RI [ options ]
.IR tfm_file [ \fB.tfm\fP ]
.RI [ pl_file [ \fB.pl\fP ]]
.\"=====================================================================
.SH DESCRIPTION
The
.B tftopl
program translates a (binary) \*(TX font metric file to a (plain text)
property list file. Then you can view or edit the contents of the tfm
file. It also serves as a tfm-file validating program, i.e., if no error
messages are given, the input file is correct.
.PP
The
.I pl_file
is extended with
.B .pl
if necessary.
If
.I pl_file
is not given, standard output is used. Likewise, 
.I tfm_file
is extended with
.B .tfm
if it lacks a suffix.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
.TP
.BI -charcode-format= format
The argument
.I format
specifies how character codes are output in the pl file. By default (the
historical behavior), ASCII letters and digits are output using the "C"
code (i.e., as themselves), and other characters are output in octal;
unless the font's coding scheme starts with "TeX math sy" or "TeX math
ex", in which case all character codes are output in octal.
.IP
If
.I format
is
.BR ascii ,
all character codes that correspond to graphic characters, besides the
left and right parentheses, are output in ASCII.
.IP
Finally, if
.I format
is
.BR octal ,
all character codes are output in octal.
(This option is the same as in
\fBvftovp\fP.)
.TP
.B -verbose
By default, the program operates silently. With this option, some
reports are printed on stdout.
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH ENVIRONMENT
The program looks for
.I tfm_file
using the environment variables TFMFONTS and TEXFONTS, in that order. If
neither are set, it uses the system default.
.\"=====================================================================
.SH "SEE ALSO"
.BR pltotf (1),
.br
Donald E. Knuth,
.IR "\*(OXware" .
.PP
Font utility topic on CTAN: https://ctan.org/topic/font-util
.br
Package page on CTAN: https://ctan.org/pkg/tftopl
.br
Section in the Web2c manual (with an example and summary of the pl format):
https://tug.org/texinfohtml/web2c.html#tftopl-invocation
.br
Typeset source code, including the tfm file format description:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
Donald E. Knuth wrote the program. It was published as
part of the
.I \*(OXware
technical report from Stanford. Howard Trickey and Pavel Curtis
originally ported it to Unix.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
